/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.WritableSubHandler;
import net.openhft.chronicle.network.cluster.handlers.Registerable;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CspTcpHandler<T extends NetworkContext>
extends WireTcpHandler<T> {
    protected final List<WriteMarshallable> writers = new ArrayList<WriteMarshallable>();
    @NotNull
    private final Map<Long, SubHandler> cidToHandle = new HashMap<Long, SubHandler>();
    private final Map<Object, SubHandler> registry = new HashMap<Object, SubHandler>();
    @Nullable
    private SubHandler handler;
    @Nullable
    private HeartbeatEventHandler heartbeatEventHandler;
    private long lastCid;

    @Nullable
    protected SubHandler handler() {
        return this.handler;
    }

    @Override
    public void close() {
        this.cidToHandle.values().forEach(Closeable::closeQuietly);
        super.close();
    }

    protected boolean readMeta(@NotNull WireIn wireIn) {
        StringBuilder event = Wires.acquireStringBuilder();
        ValueIn valueIn = wireIn.readEventName(event);
        if (CoreFields.csp.contentEquals(event)) {
            String csp = valueIn.text();
            event.setLength(0);
            valueIn = wireIn.readEventName(event);
            if (!CoreFields.cid.contentEquals(event)) {
                throw new IllegalStateException("expecting 'cid' but eventName=" + event);
            }
            long cid = valueIn.int64();
            event.setLength(0);
            valueIn = wireIn.readEventName(event);
            if (CoreFields.handler.contentEquals(event)) {
                if (this.cidToHandle.containsKey(cid)) {
                    String registeredCsp = this.cidToHandle.get(cid).csp();
                    if (!csp.equals(registeredCsp)) {
                        Jvm.warn().on(this.getClass(), "cid: " + cid + " already has handler registered with different csp, registered csp:" + registeredCsp + ", received csp: " + csp);
                    }
                    return false;
                }
                this.handler = (SubHandler)valueIn.typedMarshallable();
                this.handler.nc(this.nc());
                this.handler.closeable(this);
                try {
                    if (this.handler instanceof Registerable) {
                        Registerable registerable = (Registerable)((Object)this.handler);
                        this.registry.put(registerable.registryKey(), this.handler);
                        registerable.registry(this.registry);
                    }
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), (Throwable)e);
                }
                if (this.handler instanceof ConnectionListener) {
                    this.nc().addConnectionListener((ConnectionListener)((Object)this.handler));
                }
                if (this.handler() instanceof HeartbeatEventHandler) {
                    assert (this.heartbeatEventHandler == null) : "its assumed that you will only have a single heartbeatReceiver per connection";
                    this.heartbeatEventHandler = (HeartbeatEventHandler)((Object)this.handler());
                }
                this.handler.cid(cid);
                this.handler.csp(csp);
                this.lastCid = cid;
                this.cidToHandle.put(cid, this.handler);
                if (this.handler instanceof WritableSubHandler) {
                    this.writers.add(((WritableSubHandler)((Object)this.handler)).writer());
                }
            } else {
                throw new IllegalStateException("expecting 'cid' but eventName=" + event);
            }
            return true;
        }
        if (CoreFields.cid.contentEquals(event)) {
            long cid = valueIn.int64();
            if (cid == this.lastCid) {
                return false;
            }
            this.lastCid = cid;
            this.handler = this.cidToHandle.get(cid);
            if (this.handler == null) {
                throw new IllegalStateException("handler not found : for CID=" + cid + ", known cids=" + this.cidToHandle.keySet());
            }
        } else {
            throw new IllegalStateException("expecting either csp or cid, event=" + event);
        }
        return false;
    }

    @Nullable
    protected HeartbeatEventHandler heartbeatEventHandler() {
        return this.heartbeatEventHandler;
    }
}

