/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.tcp.ISocketChannel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkLog {
    private static final Logger LOG = LoggerFactory.getLogger((String)NetworkLog.class.getName());
    @NotNull
    private final String desc;
    private long lastOut = System.currentTimeMillis();

    public NetworkLog(@NotNull ISocketChannel channel, String op) {
        this.desc = channel.isOpen() ? op + " " + channel.getLocalAddress().getPort() + " " + channel.getRemoteAddress().getPort() : "";
    }

    public void idle() {
        if (!Jvm.isDebug() || !LOG.isDebugEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastOut > 2000L) {
            this.lastOut = now;
            Jvm.debug().on(this.getClass(), this.desc + " idle");
        }
    }

    public void log(@NotNull ByteBuffer bytes, int start, int end) {
        if (!Jvm.isDebug() || !LOG.isDebugEnabled()) {
            return;
        }
        this.log0(bytes, start, end);
    }

    private void log0(@NotNull ByteBuffer bytes, int start, int end) {
        StringBuilder sb = new StringBuilder(this.desc);
        sb.append(" len: ").append(end - start).append(" - ");
        if (end - start > 128) {
            int i;
            for (i = start; i < start + 64; ++i) {
                this.appendByte(bytes, sb, i);
            }
            sb.append(" ... ");
            for (i = end - 64; i < end; ++i) {
                this.appendByte(bytes, sb, i);
            }
        } else {
            for (int i = start; i < end; ++i) {
                this.appendByte(bytes, sb, i);
            }
        }
        Jvm.debug().on(this.getClass(), sb.toString());
    }

    private void appendByte(@NotNull ByteBuffer bytes, @NotNull StringBuilder sb, int i) {
        sb.append(RandomDataInput.charToString[bytes.get(i) & 0xFF]);
    }
}

