/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.Timer;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.cluster.AbstractSubHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeartbeatHandler<T extends ClusteredNetworkContext>
extends AbstractSubHandler<T>
implements Demarshallable,
WriteMarshallable,
HeartbeatEventHandler {
    private final long heartbeatIntervalMs;
    private final long heartbeatTimeoutMs;
    private final AtomicBoolean hasHeartbeats = new AtomicBoolean();
    private volatile long lastTimeMessageReceived;
    @Nullable
    private ConnectionListener connectionMonitor;
    @Nullable
    private Timer timer;

    @UsedViaReflection
    public HeartbeatHandler(@NotNull WireIn w) {
        this.heartbeatTimeoutMs = w.read(() -> "heartbeatTimeoutMs").int64();
        this.heartbeatIntervalMs = w.read(() -> "heartbeatIntervalMs").int64();
        assert (this.heartbeatTimeoutMs >= 1000L) : "heartbeatTimeoutMs=" + this.heartbeatTimeoutMs + ", this is too small";
        assert (this.heartbeatIntervalMs >= 500L) : "heartbeatIntervalMs=" + this.heartbeatIntervalMs + ", this is too small";
        this.onMessageReceived();
    }

    private HeartbeatHandler(long heartbeatTimeoutMs, long heartbeatIntervalMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        assert (heartbeatTimeoutMs > heartbeatIntervalMs) : "heartbeatIntervalMs=" + heartbeatIntervalMs + ", heartbeatTimeoutMs=" + heartbeatTimeoutMs;
        assert (heartbeatTimeoutMs >= 1000L) : "heartbeatTimeoutMs=" + heartbeatTimeoutMs + ", this is too small";
        assert (heartbeatIntervalMs >= 500L) : "heartbeatIntervalMs=" + heartbeatIntervalMs + ", this is too small";
    }

    private static WriteMarshallable heartbeatHandler(long heartbeatTimeoutMs, long heartbeatIntervalMs, long cid) {
        return w -> w.writeDocument(true, d -> d.writeEventName((WireKey)CoreFields.csp).text("/").writeEventName((WireKey)CoreFields.cid).int64(cid).writeEventName((WireKey)CoreFields.handler).typedMarshallable(new HeartbeatHandler(heartbeatTimeoutMs, heartbeatIntervalMs)));
    }

    @Override
    public void onInitialize(@NotNull WireOut outWire) {
        if (((ClusteredNetworkContext)this.nc()).isAcceptor()) {
            HeartbeatHandler.heartbeatHandler(this.heartbeatTimeoutMs, this.heartbeatIntervalMs, this.cid()).writeMarshallable(outWire);
        }
        WriteMarshallable heartbeatMessage = w -> {
            w.writeDocument(true, d -> d.write((WireKey)CoreFields.cid).int64(this.cid()));
            w.writeDocument(false, d -> d.write(() -> "heartbeat").text(""));
        };
        this.connectionMonitor = ((ClusteredNetworkContext)this.nc()).acquireConnectionListener();
        this.timer = new Timer(((ClusteredNetworkContext)this.nc()).eventLoop());
        this.startPeriodicHeartbeatCheck();
        this.startPeriodicallySendingHeartbeats(heartbeatMessage);
    }

    private void startPeriodicallySendingHeartbeats(WriteMarshallable heartbeatMessage) {
        VanillaEventHandler task = () -> {
            if (this.isClosed()) {
                throw new InvalidEventHandlerException("closed");
            }
            WireOutPublisher wireOutPublisher = ((ClusteredNetworkContext)this.nc()).wireOutPublisher();
            if (wireOutPublisher.isEmpty()) {
                wireOutPublisher.publish(heartbeatMessage);
            }
            return true;
        };
        this.timer.scheduleAtFixedRate(task, this.heartbeatIntervalMs, this.heartbeatIntervalMs);
    }

    @Override
    public boolean isClosed() {
        return this.closable().isClosed();
    }

    public void writeMarshallable(@NotNull WireOut w) {
        w.write(() -> "heartbeatTimeoutMs").int64(this.heartbeatTimeoutMs);
        assert (this.heartbeatIntervalMs > 0L);
        w.write(() -> "heartbeatIntervalMs").int64(this.heartbeatIntervalMs);
    }

    @Override
    public void onRead(@NotNull WireIn inWire, @NotNull WireOut outWire) {
        if (inWire.isEmpty()) {
            return;
        }
        inWire.read(() -> "heartbeat").text();
    }

    @Override
    public void close() {
        if (this.connectionMonitor != null) {
            this.connectionMonitor.onDisconnected(this.localIdentifier(), this.remoteIdentifier(), ((ClusteredNetworkContext)this.nc()).isAcceptor());
        }
        this.lastTimeMessageReceived = Long.MAX_VALUE;
        Closeable closable = this.closable();
        if (closable != null && !closable.isClosed()) {
            Closeable.closeQuietly((Object)closable);
        }
    }

    @Override
    public void onMessageReceived() {
        this.lastTimeMessageReceived = System.currentTimeMillis();
    }

    private VanillaEventHandler heartbeatCheck() {
        return () -> {
            boolean prev;
            if (this.closable().isClosed()) {
                throw new InvalidEventHandlerException("closed");
            }
            boolean hasHeartbeats = this.hasReceivedHeartbeat();
            if (hasHeartbeats != (prev = this.hasHeartbeats.getAndSet(hasHeartbeats))) {
                if (!hasHeartbeats) {
                    this.connectionMonitor.onDisconnected(this.localIdentifier(), this.remoteIdentifier(), ((ClusteredNetworkContext)this.nc()).isAcceptor());
                    this.close();
                    Runnable socketReconnector = ((ClusteredNetworkContext)this.nc()).socketReconnector();
                    TerminationEventHandler teHandler = ((ClusteredNetworkContext)this.nc()).terminationEventHandler();
                    if (teHandler != null && teHandler.isTerminated() && socketReconnector != null) {
                        socketReconnector.run();
                    }
                    throw new InvalidEventHandlerException("closed");
                }
                this.connectionMonitor.onConnected(this.localIdentifier(), this.remoteIdentifier(), ((ClusteredNetworkContext)this.nc()).isAcceptor());
            }
            return true;
        };
    }

    private void startPeriodicHeartbeatCheck() {
        this.timer.scheduleAtFixedRate(this.heartbeatCheck(), 0L, this.heartbeatTimeoutMs);
    }

    private boolean hasReceivedHeartbeat() {
        boolean result;
        long currentTimeMillis = System.currentTimeMillis();
        boolean bl = result = this.lastTimeMessageReceived + this.heartbeatTimeoutMs >= currentTimeMillis;
        if (!result) {
            Jvm.warn().on(this.getClass(), Integer.toHexString(this.hashCode()) + " missed heartbeat, lastTimeMessageReceived=" + this.lastTimeMessageReceived + ", currentTimeMillis=" + currentTimeMillis);
        }
        return result;
    }

    public static class Factory
    implements Function<ClusterContext, WriteMarshallable>,
    Demarshallable {
        @UsedViaReflection
        private Factory(WireIn w) {
        }

        public Factory() {
        }

        @Override
        @NotNull
        public WriteMarshallable apply(@NotNull ClusterContext clusterContext) {
            long heartbeatTimeoutMs = clusterContext.heartbeatTimeoutMs();
            long heartbeatIntervalMs = clusterContext.heartbeatIntervalMs();
            return HeartbeatHandler.heartbeatHandler(heartbeatTimeoutMs, heartbeatIntervalMs, HeartbeatHandler.class.hashCode());
        }
    }
}

