/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MethodReader;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class MethodTcpHandler<I, O, N extends NetworkContext<N>>
extends WireTcpHandler<N> {
    private final Supplier<I> implSupplier;
    private final Class<O> outClass;
    private final Consumer<O> outSetter;
    private MethodReader reader;
    private O output;

    public MethodTcpHandler(Supplier<I> implSupplier, Class<O> outClass, Consumer<O> outSetter) {
        this.implSupplier = implSupplier;
        this.outClass = outClass;
        this.outSetter = outSetter;
    }

    @Override
    protected Wire initialiseOutWire(Bytes out, @NotNull WireType wireType) {
        Wire wire = super.initialiseOutWire(out, wireType);
        this.output = wire.methodWriter(this.outClass, new Class[0]);
        return wire;
    }

    @Override
    protected Wire initialiseInWire(@NotNull WireType wireType, Bytes in) {
        Wire wire = super.initialiseInWire(wireType, in);
        this.reader = wire.methodReader(new Object[]{this.implSupplier.get()});
        return wire;
    }

    @Override
    protected void onRead(@NotNull DocumentContext in, @NotNull WireOut out) {
        long pos;
        do {
            pos = in.wire().bytes().readPosition();
            if (this.reader.readOne()) continue;
            return;
        } while (pos > in.wire().bytes().readPosition());
        Jvm.warn().on(this.getClass(), "unable to parse data at the end of message " + in.wire().bytes().toDebugString());
    }

    @Override
    protected void onInitialize() {
    }
}

