/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Cluster<E extends HostDetails, C extends ClusterContext>
implements Marshallable,
Closeable {
    @NotNull
    private final Map<String, E> hostDetails = new ConcurrentSkipListMap<String, E>();
    private final String clusterName;
    @Nullable
    private C clusterContext;

    public Cluster(String clusterName) {
        this.clusterName = clusterName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public C clusterContext() {
        return this.clusterContext;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.hostDetails.clear();
        if (wire.isEmpty()) {
            return;
        }
        while (!wire.isEmpty()) {
            StringBuilder sb = Wires.acquireStringBuilder();
            ValueIn valueIn = wire.readEventName(sb);
            if ("context".contentEquals(sb)) {
                this.clusterContext = (ClusterContext)valueIn.typedMarshallable();
                ((ClusterContext)this.clusterContext).clusterName(this.clusterName);
                continue;
            }
            valueIn.marshallable(details -> {
                E hd = this.newHostDetails();
                ((HostDetails)hd).readMarshallable(details);
                this.hostDetails.put(sb.toString(), hd);
            });
        }
    }

    @Nullable
    @net.openhft.chronicle.core.annotation.Nullable
    public HostDetails findHostDetails(int id) {
        for (HostDetails hd : this.hostDetails.values()) {
            if (hd.hostId() != id) continue;
            return hd;
        }
        return null;
    }

    @Nullable
    public <H extends HostDetails, C extends ClusterContext> ConnectionStrategy findConnectionStrategy(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.connectionStrategy();
    }

    @Nullable
    public ConnectionManager findConnectionManager(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.connectionManager();
    }

    @Nullable
    public TerminationEventHandler findTerminationEventHandler(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.terminationEventHandler();
    }

    @Nullable
    public ConnectionChangedNotifier findClusterNotifier(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.clusterNotifier();
    }

    @NotNull
    protected abstract E newHostDetails();

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, E> entry2 : this.hostDetails.entrySet()) {
            wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
        }
    }

    @NotNull
    public Collection<E> hostDetails() {
        return this.hostDetails.values();
    }

    public void close() {
        this.hostDetails().forEach(Closeable::closeQuietly);
    }

    public void install() {
        if (this.clusterContext != null && this.hostDetails != null && this.hostDetails.values() != null) {
            this.hostDetails.values().forEach(arg_0 -> this.clusterContext.accept(arg_0));
        }
    }
}

