/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwaysStartOnPrimaryConnectionStrategy
implements ConnectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AlwaysStartOnPrimaryConnectionStrategy.class);
    private int tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
    private int timeoutMs = Integer.getInteger("client.timeout", 1000);
    private int pausePeriodMs = Integer.getInteger("client.timeout", 500);

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        Wires.readMarshallable((Object)this, (WireIn)wire, (boolean)false);
    }

    @Override
    @Nullable
    public SocketChannel connect(String name, SocketAddressSupplier socketAddressSupplier, @NotNull NetworkStatsListener<? extends NetworkContext> networkStatsListener, boolean hasLoggedInPreviously) {
        if (socketAddressSupplier.get() == null || hasLoggedInPreviously) {
            socketAddressSupplier.resetToPrimary();
        } else {
            socketAddressSupplier.failoverToNextAddress();
        }
        long start = System.currentTimeMillis();
        while (true) {
            if (start + (long)this.timeoutMs < System.currentTimeMillis()) {
                String oldAddress = socketAddressSupplier.toString();
                if (this.isAtEnd(socketAddressSupplier)) {
                    return null;
                }
                socketAddressSupplier.failoverToNextAddress();
                if ("(none)".equals(oldAddress)) {
                    LOG.info("Connection Dropped to address=" + oldAddress + ", so will fail over to" + socketAddressSupplier + ", name=" + name);
                }
                if (socketAddressSupplier.get() == null) {
                    Jvm.warn().on(this.getClass(), "failed to establish a socket connection of any of the following servers=" + socketAddressSupplier.all() + " so will re-attempt");
                    socketAddressSupplier.resetToPrimary();
                }
                start = System.currentTimeMillis();
            }
            SocketChannel socketChannel = null;
            try {
                InetSocketAddress socketAddress = socketAddressSupplier.get();
                if (socketAddress == null) {
                    Jvm.warn().on(AlwaysStartOnPrimaryConnectionStrategy.class, "failed to obtain socketAddress");
                    continue;
                }
                socketChannel = this.openSocketChannel(socketAddress, this.tcpBufferSize);
                if (socketChannel == null) {
                    Jvm.warn().on(this.getClass(), "unable to connected to " + socketAddressSupplier.toString());
                    Jvm.pause((long)this.pausePeriodMs);
                    continue;
                }
                Jvm.debug().on(this.getClass(), "successfully connected to " + socketAddressSupplier.toString());
                if (networkStatsListener != null) {
                    networkStatsListener.onHostPort(socketAddress.getHostString(), socketAddress.getPort());
                }
                return socketChannel;
            }
            catch (Throwable e) {
                if (socketChannel != null) {
                    Closeable.closeQuietly(socketChannel);
                }
                if (Jvm.isDebug()) {
                    LOG.info("", e);
                }
                socketAddressSupplier.failoverToNextAddress();
                Jvm.pause((long)this.pausePeriodMs);
                continue;
            }
            break;
        }
    }

    private boolean isAtEnd(SocketAddressSupplier socketAddressSupplier) {
        return socketAddressSupplier.size() - 1 == socketAddressSupplier.index();
    }
}

