/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.network.TCPRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(SocketAddressSupplier.class);
    private final String name;
    private final List<RemoteAddressSupplier> remoteAddresses = new ArrayList<RemoteAddressSupplier>();
    private final long failoverTimeout = Integer.getInteger("tcp.failover.time", 2000).intValue();
    @Nullable
    private RemoteAddressSupplier current;
    private int addressCount = 0;

    public SocketAddressSupplier(@NotNull String[] connectURIs, @NotNull String name) {
        this.name = name;
        for (String connectURI : connectURIs) {
            this.remoteAddresses.add(new RemoteAddressSupplier(connectURI));
        }
        assert (!this.remoteAddresses.isEmpty());
    }

    public static SocketAddressSupplier uri(String connectURI) {
        return new SocketAddressSupplier(new String[]{connectURI}, "");
    }

    @NotNull
    public List<RemoteAddressSupplier> all() {
        return this.remoteAddresses;
    }

    public String name() {
        return this.name;
    }

    public void failoverToNextAddress() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing over to next address");
        }
        this.next();
    }

    public void startAddresses() {
        this.addressCount = 0;
        this.current = this.remoteAddresses.get(this.addressCount);
    }

    private void next() {
        this.addressCount = (this.addressCount + 1) % this.remoteAddresses.size();
        this.current = this.remoteAddresses.get(this.addressCount);
    }

    public long timeoutMS() {
        return this.failoverTimeout;
    }

    @Override
    @Nullable
    public InetSocketAddress get() {
        RemoteAddressSupplier current = this.current;
        if (current == null) {
            return null;
        }
        return current.get();
    }

    @NotNull
    public String toString() {
        RemoteAddressSupplier current = this.current;
        if (current == null) {
            return "(none)";
        }
        InetSocketAddress socketAddress = current.get();
        if (socketAddress == null) {
            return "(none)";
        }
        return ((Object)socketAddress).toString().replaceAll("0:0:0:0:0:0:0:0", "localhost") + " - " + current.toString();
    }

    private class RemoteAddressSupplier
    implements Supplier<SocketAddress> {
        private final InetSocketAddress remoteAddress;
        private final String description;

        public RemoteAddressSupplier(String description) {
            this.description = description;
            this.remoteAddress = TCPRegistry.lookup(description);
        }

        @Override
        public InetSocketAddress get() {
            return this.remoteAddress;
        }

        public String toString() {
            return this.description;
        }
    }
}

