/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConnector
implements Closeable {
    public static final int BUFFER_SIZE = 0x800000;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteConnector.class);
    @NotNull
    private final Function<NetworkContext, TcpEventHandler> tcpHandlerSupplier;
    @NotNull
    private final Integer tcpBufferSize;
    private volatile boolean closed;
    private volatile List<Closeable> closeables = new ArrayList<Closeable>();

    public RemoteConnector(@NotNull Function<NetworkContext, TcpEventHandler> tcpHandlerSupplier) {
        this.tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", 0x800000);
        this.tcpHandlerSupplier = tcpHandlerSupplier;
    }

    public void connect(String remoteHostPort, EventLoop eventLoop, NetworkContext nc, long timeOutMs) {
        InetSocketAddress address = TCPRegistry.lookup(remoteHostPort);
        long timeoutTime = System.currentTimeMillis() + timeOutMs;
        AtomicLong nextPeriod = new AtomicLong();
        eventLoop.addHandler((EventHandler)new RCEventHandler(nextPeriod, timeoutTime, remoteHostPort, nc, eventLoop, address));
    }

    private static void closeSocket(SocketChannel socketChannel) {
        if (socketChannel == null) {
            return;
        }
        try {
            Socket socket = socketChannel.socket();
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        List<Closeable> closeables = this.closeables;
        this.closeables = null;
        closeables.forEach(Closeable::closeQuietly);
    }

    private SocketChannel openSocketChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel result = SocketChannel.open(socketAddress);
        result.configureBlocking(false);
        Socket socket = result.socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(this.tcpBufferSize);
        socket.setSendBufferSize(this.tcpBufferSize);
        socket.setSoTimeout(0);
        socket.setSoLinger(false, 0);
        return result;
    }

    class RCEventHandler
    implements EventHandler,
    Closeable {
        private final InetSocketAddress address;
        private volatile boolean closed;
        private final AtomicLong nextPeriod;
        private final long timeoutTime;
        private final String remoteHostPort;
        private final NetworkContext nc;
        private final EventLoop eventLoop;

        public RCEventHandler(AtomicLong nextPeriod, long timeoutTime, String remoteHostPort, NetworkContext nc, EventLoop eventLoop, InetSocketAddress address) {
            this.nextPeriod = nextPeriod;
            this.timeoutTime = timeoutTime;
            this.remoteHostPort = remoteHostPort;
            this.nc = nc;
            this.eventLoop = eventLoop;
            this.address = address;
        }

        public boolean action() throws InvalidEventHandlerException, InterruptedException {
            SocketChannel sc;
            if (this.closed) {
                throw new InvalidEventHandlerException();
            }
            long time = System.currentTimeMillis();
            if (time <= this.nextPeriod.get()) {
                return false;
            }
            this.nextPeriod.set(time + 1000L);
            if (time > this.timeoutTime) {
                throw Jvm.rethrow((Throwable)new TimeoutException("timed out attempting to connect to " + this.remoteHostPort + " as " + this.address));
            }
            try {
                sc = RemoteConnector.this.openSocketChannel(this.address);
            }
            catch (IOException e) {
                return false;
            }
            if (sc == null) {
                return false;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("accepted connection " + sc);
            }
            this.nc.socketChannel(sc);
            this.nc.isAcceptor(false);
            TcpEventHandler eventHandler = (TcpEventHandler)RemoteConnector.this.tcpHandlerSupplier.apply(this.nc);
            this.eventLoop.addHandler((EventHandler)eventHandler);
            List closeables = RemoteConnector.this.closeables;
            if (closeables == null) {
                Closeable.closeQuietly((Object)eventHandler);
            } else {
                closeables.add(() -> RemoteConnector.closeSocket(sc));
            }
            throw new InvalidEventHandlerException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "remoteHostPort=" + this.remoteHostPort + "}";
        }

        public void close() {
            this.closed = true;
        }

        public void notifyClosing() {
            this.closed = true;
        }
    }
}

