/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;

public class WireTypeSniffingTcpHandler<T extends NetworkContext>
implements TcpHandler {
    private final TcpEventHandler handlerManager;
    private final T nc;
    private final Function<T, TcpHandler> delegateHandlerFactory;

    public WireTypeSniffingTcpHandler(@NotNull TcpEventHandler handlerManager, @NotNull T nc, @NotNull Function<T, TcpHandler> delegateHandlerFactory) {
        this.handlerManager = handlerManager;
        this.nc = nc;
        this.delegateHandlerFactory = delegateHandlerFactory;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        if (in.readRemaining() < 5L) {
            return;
        }
        int required = Wires.lengthOf((long)in.readInt(in.readPosition()));
        assert (required < 0xA00000);
        if (in.readRemaining() < (long)(required + 4)) {
            return;
        }
        byte b = in.readByte(4L);
        WireType wireType = (b & 0x80) == 0 ? WireType.TEXT : WireType.BINARY;
        this.nc.wireType(wireType);
        this.handlerManager.tcpHandler(this.delegateHandlerFactory.apply(this.nc));
    }
}

