/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConnector
implements Closeable {
    public static final int BUFFER_SIZE = 0x800000;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteConnector.class);
    @NotNull
    private final Function<NetworkContext, TcpEventHandler> tcpHandlerSupplier;
    @NotNull
    private final Integer tcpBufferSize;
    private volatile boolean closed;
    private InetSocketAddress address;
    private SocketChannel sc;
    private List<Closeable> closeables = new ArrayList<Closeable>();

    public RemoteConnector(@NotNull Function<NetworkContext, TcpEventHandler> tcpHandlerSupplier) {
        this.tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", 0x800000);
        this.tcpHandlerSupplier = tcpHandlerSupplier;
    }

    public void connect(String remoteHostPort, EventLoop eventLoop, Consumer<SocketChannel> onHandshaking, NetworkContext nc, double timeOutMs) throws InvalidEventHandlerException {
        block8: {
            this.address = TCPRegistry.lookup(remoteHostPort);
            try {
                long start = System.currentTimeMillis();
                IOException exception = null;
                while (true) {
                    try {
                        this.sc = this.openSocketChannel(this.address);
                        exception = null;
                    }
                    catch (IOException e) {
                        if (exception == null) {
                            exception = e;
                        }
                        Thread.sleep(100L);
                        if (!((double)System.currentTimeMillis() - timeOutMs > (double)start)) continue;
                        throw exception;
                    }
                    break;
                }
                if (this.sc != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("accepted connection " + this.sc);
                    }
                    onHandshaking.accept(this.sc);
                    this.sc.configureBlocking(false);
                    nc.socketChannel(this.sc);
                    nc.isServerSocket(false);
                    TcpEventHandler eventHandler = this.tcpHandlerSupplier.apply(nc);
                    eventLoop.addHandler((EventHandler)eventHandler);
                    this.closeables.add(eventHandler);
                }
            }
            catch (Exception e) {
                if (this.closed) break block8;
                LOG.error("", (Throwable)e);
                this.closeSocket();
            }
        }
    }

    private void closeSocket() {
        SocketChannel socketChannel = this.sc;
        if (socketChannel == null) {
            return;
        }
        try {
            Socket socket = this.sc.socket();
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeSocket();
        this.closeables.forEach(Closeable::closeQuietly);
    }

    private SocketChannel openSocketChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel result = SocketChannel.open(socketAddress);
        result.configureBlocking(false);
        Socket socket = result.socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(this.tcpBufferSize);
        socket.setSendBufferSize(this.tcpBufferSize);
        socket.setSoTimeout(0);
        socket.setSoLinger(false, 0);
        return result;
    }
}

