/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.HeaderTcpHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.WireTypeSniffingTcpHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class LegacyHanderFactory {
    public static <T extends NetworkContext> Function<T, TcpEventHandler> legacyTcpEventHandlerFactory(@NotNull Function<T, TcpHandler> defaultHandedFactory, long heartbeatIntervalTicks, long heartbeatIntervalTimeout) {
        return networkContext -> {
            try {
                TcpEventHandler handler = new TcpEventHandler((NetworkContext)networkContext);
                Function<Marshallable, TcpHandler> consumer = o -> {
                    if (o instanceof SessionDetailsProvider) {
                        NetworkContext nc = networkContext;
                        nc.heartbeatIntervalTicks(heartbeatIntervalTicks);
                        nc.heartBeatTimeoutTicks(heartbeatIntervalTimeout);
                        nc.sessionDetails((SessionDetailsProvider)o);
                        return (TcpHandler)defaultHandedFactory.apply(nc);
                    }
                    if (o instanceof TcpHandler) {
                        return (TcpHandler)o;
                    }
                    throw new UnsupportedOperationException("");
                };
                HeaderTcpHandler headerTcpHandler = new HeaderTcpHandler(handler, consumer, (NetworkContext)networkContext);
                WireTypeSniffingTcpHandler<Object> wireTypeSniffingTcpHandler = new WireTypeSniffingTcpHandler<Object>(handler, networkContext, nc -> headerTcpHandler);
                handler.tcpHandler(wireTypeSniffingTcpHandler);
                return handler;
            }
            catch (IOException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        };
    }

    public static <T extends NetworkContext> Function<T, TcpEventHandler> legacyTcpEventHandlerFactory(@NotNull Function<T, TcpHandler> defaultHandedFactory) {
        return LegacyHanderFactory.legacyTcpEventHandlerFactory(defaultHandedFactory, 20000L, 40000L);
    }

    public static <T extends NetworkContext> Function<T, TcpEventHandler> simpleTcpEventHandlerFactory(@NotNull Function<T, TcpHandler> defaultHandedFactory) {
        return networkContext -> {
            try {
                networkContext.wireOutPublisher(new VanillaWireOutPublisher(WireType.TEXT));
                TcpEventHandler handler = new TcpEventHandler((NetworkContext)networkContext);
                handler.tcpHandler(new WireTypeSniffingTcpHandler<NetworkContext>(handler, (NetworkContext)networkContext, defaultHandedFactory));
                return handler;
            }
            catch (IOException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        };
    }
}

