/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerThreadingStrategy {
    SINGLE_THREADED("uses a single threaded prioritised event loop, where the reads take priority over the asynchronous writes"),
    MULTI_THREADED_BUSY_WAITING("each client connection is devoted to its own busy waiting thread, This is ideal when you have a small number of client connections on a server with a large number of free cores");

    private final String description;
    public static ServerThreadingStrategy value;
    private static final Logger LOG;

    private ServerThreadingStrategy(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    static ServerThreadingStrategy serverThreadingStrategy() {
        return value;
    }

    static {
        value = SINGLE_THREADED;
        LOG = LoggerFactory.getLogger(ServerThreadingStrategy.class);
        String serverThreadingStrategy = System.getProperty("ServerThreadingStrategy");
        if (serverThreadingStrategy != null) {
            try {
                value = Enum.valueOf(ServerThreadingStrategy.class, serverThreadingStrategy);
            }
            catch (Exception e) {
                LOG.error("unable to apply -DServerThreadingStrategy=" + serverThreadingStrategy + ", so defaulting to " + (Object)((Object)value));
            }
        }
    }
}

