/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.TcpHandler;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.network.event.HandlerPriority;

public class TcpEventHandler
implements EventHandler {
    public static final int CAPACITY = 131072;
    private final SocketChannel sc;
    private final TcpHandler handler;
    private final ByteBuffer inBB = ByteBuffer.allocateDirect(131072);
    private final Bytes inBBB = Bytes.wrap((ByteBuffer)this.inBB.slice());
    private final ByteBuffer outBB = ByteBuffer.allocateDirect(131072);
    private final Bytes outBBB = Bytes.wrap((ByteBuffer)this.outBB.slice());

    public TcpEventHandler(SocketChannel sc, TcpHandler handler) throws IOException {
        this.sc = sc;
        sc.configureBlocking(false);
        sc.socket().setTcpNoDelay(true);
        this.handler = handler;
        this.outBB.limit(0);
    }

    @Override
    public HandlerPriority priority() {
        return HandlerPriority.HIGH;
    }

    @Override
    public void eventLoop(EventLoop eventLoop) {
        eventLoop.addHandler(new WriteEventHandler());
    }

    @Override
    public boolean runOnce() {
        try {
            int read;
            int n = read = this.inBB.remaining() > 0 ? this.sc.read(this.inBB) : 1;
            if (read < 0) {
                this.closeSC();
            } else if (read > 0) {
                this.invokeHandler();
            }
        }
        catch (IOException e) {
            this.handleIOE(e);
        }
        return false;
    }

    void invokeHandler() throws IOException {
        this.inBBB.limit((long)this.inBB.position());
        this.outBBB.position((long)this.outBB.limit());
        this.handler.process(this.inBBB, this.outBBB);
        if (this.outBBB.position() > (long)this.outBB.limit()) {
            this.outBB.limit((int)this.outBBB.position());
            this.tryWrite();
        }
        if (this.inBBB.position() > 0L) {
            this.inBB.position((int)this.inBBB.position());
            this.inBB.limit((int)this.inBBB.limit());
            this.inBB.compact();
            this.inBBB.position(0L);
            this.inBBB.limit((long)this.inBB.position());
        }
    }

    @Override
    public boolean isDead() {
        return !this.sc.isOpen();
    }

    void handleIOE(IOException e) {
        e.printStackTrace();
        this.closeSC();
    }

    private void closeSC() {
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean tryWrite() throws IOException {
        int wrote = this.sc.write(this.outBB);
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.outBB.compact().flip();
            this.outBBB.position((long)this.outBB.limit());
            this.outBBB.limit((long)this.outBB.capacity());
            return true;
        }
        return false;
    }

    class WriteEventHandler
    implements EventHandler {
        WriteEventHandler() {
        }

        @Override
        public boolean runOnce() {
            try {
                if (TcpEventHandler.this.outBB.remaining() == 0 || TcpEventHandler.this.tryWrite()) {
                    TcpEventHandler.this.invokeHandler();
                    TcpEventHandler.this.tryWrite();
                }
            }
            catch (ClosedChannelException cce) {
                TcpEventHandler.this.closeSC();
            }
            catch (IOException e) {
                TcpEventHandler.this.handleIOE(e);
            }
            return false;
        }

        @Override
        public boolean isDead() {
            return !TcpEventHandler.this.sc.isOpen();
        }
    }
}

