/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.WebServiceException;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.threads.NamedThreadFactory;

public class BlockingEventLoop
implements EventLoop {
    private final EventLoop parent;
    private final ExecutorService service;

    public BlockingEventLoop(EventLoop parent, String name) {
        this.parent = parent;
        this.service = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(name, Boolean.valueOf(true)));
    }

    @Override
    public void addHandler(EventHandler handler) {
        this.service.submit(() -> {
            handler.eventLoop(this.parent);
            while (!handler.isDead()) {
                handler.runOnce();
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.service.shutdown();
    }

    @Override
    public void close() throws WebServiceException {
        this.service.shutdown();
        try {
            if (this.service.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
            this.service.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
    }
}

