/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.client;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.client.IORuntimeException;
import net.openhft.chronicle.hash.RemoteCallTimeoutException;
import net.openhft.chronicle.hash.impl.util.CloseablesManager;
import net.openhft.chronicle.network.event.EventGroup;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientWiredStatelessTcpConnectionHub {
    private static final Logger LOG = LoggerFactory.getLogger(ClientWiredStatelessTcpConnectionHub.class);
    public static final int SIZE_OF_SIZE = 2;
    protected final String name;
    protected final InetSocketAddress remoteAddress;
    public final long timeoutMs;
    protected final int tcpBufferSize;
    private final ReentrantLock inBytesLock = new ReentrantLock(true);
    private final ReentrantLock outBytesLock = new ReentrantLock();
    @NotNull
    private final AtomicLong transactionID = new AtomicLong(0L);
    @Nullable
    protected CloseablesManager closeables;
    private final Wire outWire = new TextWire(Bytes.elasticByteBuffer());
    long largestChunkSoFar = 0L;
    private final Wire intWire = new TextWire(Bytes.elasticByteBuffer());
    public int localIdentifier;
    private SocketChannel clientChannel;
    private volatile long parkedTransactionId;
    private volatile long parkedTransactionTimeStamp;
    private long limitOfLast = 0L;
    private long startTime;
    private boolean doHandShaking;
    public static boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;

    public ClientWiredStatelessTcpConnectionHub(byte localIdentifier, boolean doHandShaking, InetSocketAddress remoteAddress, int tcpBufferSize, long timeout) {
        this.localIdentifier = localIdentifier;
        this.doHandShaking = doHandShaking;
        this.tcpBufferSize = tcpBufferSize;
        this.remoteAddress = remoteAddress;
        this.name = " connected to " + remoteAddress.toString();
        this.timeoutMs = timeout;
        this.attemptConnect(remoteAddress);
    }

    private synchronized void attemptConnect(InetSocketAddress remoteAddress) {
        this.closeExisting();
        try {
            SocketChannel socketChannel = ClientWiredStatelessTcpConnectionHub.openSocketChannel(this.closeables);
            if (socketChannel.connect(remoteAddress)) {
                this.clientChannel = socketChannel;
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            if (this.closeables != null) {
                this.closeables.closeQuietly();
            }
            this.clientChannel = null;
        }
    }

    public ReentrantLock inBytesLock() {
        return this.inBytesLock;
    }

    public ReentrantLock outBytesLock() {
        return this.outBytesLock;
    }

    protected void checkVersion(@NotNull String csp) {
        String clientVersion;
        String serverVersion = this.serverApplicationVersion(csp);
        if (!serverVersion.equals(clientVersion = this.clientVersion())) {
            LOG.warn("DIFFERENT CHRONICLE-MAP VERSIONS: The Chronicle-Map-Server and Stateless-Client are on different versions,  we suggest that you use the same version, server=" + this.serverApplicationVersion(csp) + ", " + "client=" + clientVersion);
        }
    }

    private void checkTimeout(long timeoutTime) {
        if (timeoutTime < System.currentTimeMillis() && !IS_DEBUG) {
            throw new RemoteCallTimeoutException("timeout=" + timeoutTime + "ms");
        }
    }

    protected synchronized void lazyConnect(long timeoutMs, InetSocketAddress remoteAddress) {
        SocketChannel result;
        if (this.clientChannel != null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("attempting to connect to " + remoteAddress + " ,name=" + this.name);
        }
        long timeoutAt = System.currentTimeMillis() + timeoutMs;
        while (true) {
            this.checkTimeout(timeoutAt);
            this.closeExisting();
            try {
                result = ClientWiredStatelessTcpConnectionHub.openSocketChannel(this.closeables);
                if (!result.connect(remoteAddress)) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                result.socket().setTcpNoDelay(true);
                if (!this.doHandShaking) continue;
            }
            catch (IOException e) {
                if (this.closeables == null) continue;
                this.closeables.closeQuietly();
                continue;
            }
            catch (Exception e) {
                if (this.closeables != null) {
                    this.closeables.closeQuietly();
                }
                throw e;
            }
            break;
        }
        this.clientChannel = result;
    }

    static SocketChannel openSocketChannel(CloseablesManager closeables) throws IOException {
        SocketChannel result = null;
        try {
            result = SocketChannel.open();
            result.socket().setTcpNoDelay(true);
        }
        finally {
            if (result != null) {
                try {
                    closeables.add(result);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return result;
    }

    protected void closeExisting() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = new CloseablesManager();
    }

    public synchronized void close() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = null;
        this.clientChannel = null;
    }

    public long nextUniqueTransaction(long time) {
        long old;
        long id = time;
        do {
            if ((old = this.transactionID.get()) < id) continue;
            id = old + 1L;
        } while (!this.transactionID.compareAndSet(old, id));
        return id;
    }

    @NotNull
    public String serverApplicationVersion(@NotNull String csp) {
        TextWire wire = new TextWire(Bytes.elasticByteBuffer());
        String result = this.proxyReturnString(Events.getApplicationVersion, (Wire)wire, csp, 0L);
        return result == null ? "" : result;
    }

    @NotNull
    String clientVersion() {
        throw new UnsupportedOperationException("todo");
    }

    public void writeSocket(@NotNull Wire wire) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        long timeoutTime = this.startTime + this.timeoutMs;
        try {
            while (true) {
                if (this.clientChannel == null) {
                    this.lazyConnect(this.timeoutMs, this.remoteAddress);
                }
                try {
                    this.writeLength(wire);
                    this.writeSocket(wire, timeoutTime);
                }
                catch (ClosedChannelException e) {
                    this.checkTimeout(timeoutTime);
                    this.lazyConnect(this.timeoutMs, this.remoteAddress);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(Wire outWire) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        Bytes bytes = outWire.bytes();
        long position = bytes.position();
        if (position > Integer.MAX_VALUE || position < Integer.MIN_VALUE) {
            throw new IllegalStateException("message too large");
        }
        long pos = bytes.position();
        try {
            bytes.reset();
            int size = (int)(position - bytes.position());
            bytes.writeUnsignedShort(size - 2);
        }
        finally {
            bytes.position(pos);
        }
    }

    public Wire proxyReply(long timeoutTime, long tid) {
        assert (this.inBytesLock().isHeldByCurrentThread());
        try {
            Wire wire = this.proxyReplyThrowable(timeoutTime, tid);
            return wire;
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException(e);
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        catch (AssertionError e) {
            LOG.error("name=" + this.name, (Throwable)((Object)e));
            throw e;
        }
    }

    private Wire proxyReplyThrowable(long timeoutTime, long tid) throws IOException {
        assert (this.inBytesLock().isHeldByCurrentThread());
        while (true) {
            if (this.parkedTransactionId == 0L) {
                int messageSize;
                Bytes bytes;
                block12: {
                    assert (this.parkedTransactionTimeStamp == 0L);
                    bytes = this.intWire.bytes();
                    if ((long)this.inWireByteBuffer().position() == bytes.position()) {
                        this.inWireClear();
                    }
                    this.readSocket(2, timeoutTime);
                    messageSize = bytes.readUnsignedShort(bytes.position());
                    try {
                        assert (messageSize > 0) : "Invalid message size " + messageSize;
                        assert (messageSize < 0x40000000) : "Invalid message size " + messageSize;
                    }
                    catch (AssertionError e) {
                        if ($assertionsDisabled || messageSize < 0x40000000) break block12;
                        throw new AssertionError((Object)("Invalid message size " + messageSize));
                    }
                }
                int remainingBytes0 = messageSize;
                this.readSocket(remainingBytes0, timeoutTime);
                bytes.skip(2L);
                bytes.limit(bytes.position() + (long)messageSize);
                System.out.println("\n--------------------------------\nclient reads\n" + Wires.fromSizePrefixedBlobs((Bytes)bytes));
                int headerlen = bytes.readVolatileInt();
                assert (!Wires.isData((long)headerlen));
                long tid0 = this.intWire.read((WireKey)CoreFields.tid).int64();
                if (tid0 == tid) {
                    this.clearParked();
                    return this.intWire;
                }
                this.parkedTransactionTimeStamp = System.currentTimeMillis();
                this.parkedTransactionId = tid0;
                this.pause();
                continue;
            }
            if (this.parkedTransactionId == tid) {
                this.clearParked();
                return this.intWire;
            }
            if (System.currentTimeMillis() - timeoutTime <= this.parkedTransactionTimeStamp) continue;
            LOG.error("name=" + this.name, (Throwable)new IllegalStateException("Skipped Message with transaction-id=" + this.parkedTransactionTimeStamp + ", this can occur when you have another thread which has called the " + "stateless client and terminated abruptly before the message has been " + "returned from the server and hence consumed by the other thread."));
            this.clearParked();
            this.pause();
        }
    }

    private void inWireClear() {
        this.inWireByteBuffer().clear();
        Bytes bytes = this.intWire.bytes();
        bytes.clear();
    }

    private void clearParked() {
        assert (this.inBytesLock().isHeldByCurrentThread());
        this.parkedTransactionId = 0L;
        this.parkedTransactionTimeStamp = 0L;
    }

    private void pause() {
        assert (!this.outBytesLock().isHeldByCurrentThread());
        assert (this.inBytesLock().isHeldByCurrentThread());
        this.inBytesLock().unlock();
        this.inBytesLock().lock();
    }

    private void readSocket(int requiredNumberOfBytes, long timeoutTime) throws IOException {
        assert (this.inBytesLock().isHeldByCurrentThread());
        ByteBuffer buffer = this.inWireByteBuffer();
        int position = buffer.position();
        try {
            buffer.limit(position + requiredNumberOfBytes);
        }
        catch (IllegalArgumentException e) {
            buffer = this.inWireByteBuffer(position + requiredNumberOfBytes);
            buffer.limit(position + requiredNumberOfBytes);
            buffer.position(position);
        }
        long start = buffer.position();
        while ((long)buffer.position() - start < (long)requiredNumberOfBytes) {
            assert (this.clientChannel != null);
            int len = this.clientChannel.read(buffer);
            if (len == -1) {
                throw new IORuntimeException("Disconnection to server");
            }
            this.checkTimeout(timeoutTime);
        }
    }

    private ByteBuffer inWireByteBuffer() {
        Bytes bytes = this.intWire.bytes();
        return (ByteBuffer)bytes.underlyingObject();
    }

    private ByteBuffer inWireByteBuffer(long requiredCapacity) {
        Bytes bytes = this.intWire.bytes();
        bytes.ensureCapacity(requiredCapacity);
        return (ByteBuffer)bytes.underlyingObject();
    }

    private void writeSocket(Wire outWire, long timeoutTime) throws IOException {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        Bytes bytes = outWire.bytes();
        long outBytesPosition = bytes.position();
        if (this.outBytesLock().hasQueuedThreads() && outBytesPosition + this.largestChunkSoFar <= (long)this.tcpBufferSize) {
            return;
        }
        ByteBuffer outBuffer = (ByteBuffer)bytes.underlyingObject();
        outBuffer.limit((int)bytes.position());
        outBuffer.position(2);
        if (EventGroup.IS_DEBUG) {
            this.writeBytesToStandardOut(bytes, outBuffer);
        }
        outBuffer.position(0);
        this.upateLargestChunkSoFarSize(outBuffer);
        while (outBuffer.remaining() > 0) {
            int len = this.clientChannel.write(outBuffer);
            if (len == -1) {
                throw new IORuntimeException("Disconnection to server");
            }
            if (outBuffer.remaining() > 0 && this.outBytesLock().hasQueuedThreads() && (long)outBuffer.remaining() + this.largestChunkSoFar <= (long)this.tcpBufferSize) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("continuing -  without all the data being written to the buffer as it will be written by the next thread");
                }
                outBuffer.compact();
                bytes.limit((long)outBuffer.limit());
                bytes.position((long)outBuffer.position());
                return;
            }
            this.checkTimeout(timeoutTime);
        }
        outBuffer.clear();
        bytes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytesToStandardOut(Bytes<?> bytes, ByteBuffer outBuffer) {
        long position = bytes.position();
        long limit = bytes.limit();
        try {
            bytes.limit((long)outBuffer.limit());
            bytes.position((long)outBuffer.position());
            try {
                System.out.println("\n--------------------------------------------\nclient writes:\n\n" + Wires.fromSizePrefixedBlobs(bytes));
            }
            catch (Exception e) {
                System.out.println("\n--------------------------------------------\nclient writes:\n\n" + Bytes.toDebugString(bytes));
            }
        }
        finally {
            bytes.limit(limit);
            bytes.position(position);
        }
    }

    private void upateLargestChunkSoFarSize(ByteBuffer outBuffer) {
        int sizeOfThisChunk = (int)((long)outBuffer.limit() - this.limitOfLast);
        if (this.largestChunkSoFar < (long)sizeOfThisChunk) {
            this.largestChunkSoFar = sizeOfThisChunk;
        }
        this.limitOfLast = outBuffer.limit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long proxySend(@NotNull WireKey eventName, long startTime, @NotNull Wire wire, @NotNull String csp, long cid) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        this.outBytesLock().lock();
        try {
            long tid = this.writeHeader(startTime, wire, csp, cid);
            wire.writeDocument(false, wireOut -> {
                wireOut.writeEventName(eventName);
                wireOut.writeValue().marshallable(w -> {});
            });
            this.writeSocket(wire);
            long l = tid;
            return l;
        }
        finally {
            this.outBytesLock().unlock();
        }
    }

    @Nullable
    public String proxyReturnString(@NotNull WireKey messageId, String csp, long cid) {
        return this.proxyReturnString(messageId, this.outWire, csp, cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String proxyReturnString(@NotNull WireKey eventId, Wire outWire, String csp, long cid) {
        long tid;
        long startTime = System.currentTimeMillis();
        this.outBytesLock().lock();
        try {
            tid = this.proxySend(eventId, startTime, outWire, csp, cid);
        }
        finally {
            this.outBytesLock().unlock();
        }
        long timeoutTime = startTime + this.timeoutMs;
        this.inBytesLock().lock();
        try {
            Wire wire = this.proxyReply(timeoutTime, tid);
            int datalen = wire.bytes().readVolatileInt();
            assert (Wires.isData((long)datalen));
            String string = wire.read((WireKey)CoreFields.reply).text();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.inBytesLock().unlock();
        }
    }

    public Wire outWire() {
        assert (this.outBytesLock().isHeldByCurrentThread());
        return this.outWire;
    }

    public long writeHeader(long startTime, Wire wire, String csp, long cid) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        this.markSize(wire);
        this.startTime(startTime);
        long tid = this.nextUniqueTransaction(startTime);
        wire.writeDocument(true, wireOut -> {
            if (cid == 0L) {
                wireOut.write((WireKey)CoreFields.csp).text((CharSequence)csp);
            } else {
                wireOut.write((WireKey)CoreFields.cid).int64(cid);
            }
            wireOut.write((WireKey)CoreFields.tid).int64(tid);
        });
        return tid;
    }

    public void markSize(Wire outWire) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        Bytes bytes = outWire.bytes();
        bytes.mark();
        bytes.skip(2L);
    }

    public void startTime(long startTime) {
        this.startTime = startTime;
    }

    public static enum Events implements WireKey
    {
        getApplicationVersion;

    }
}

