/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.impl.SerializableDataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableDataAccess<T extends Externalizable>
extends SerializableDataAccess<T> {
    private Class<T> tClass;

    public ExternalizableDataAccess(Class<T> tClass) {
        this.tClass = tClass;
    }

    protected Class<T> tClass() {
        return this.tClass;
    }

    protected T createInstance() {
        try {
            return (T)((Externalizable)this.tClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Externalizable " + this.tClass + " must have a public no-arg constructor", e);
        }
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = this.createInstance();
        }
        try {
            using.readExternal(new ObjectInputStream(this.in));
            this.bytes.readPosition(0L);
            return using;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        this.instance = instance;
        this.bytes.clear();
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.out);
            instance.writeExternal(out);
            out.flush();
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataAccess<T> copy() {
        return new ExternalizableDataAccess<T>(this.tClass);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.tClass = wireIn.read(() -> "tClass").typeLiteral();
        this.initTransients();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "tClass").typeLiteral(this.tClass);
    }
}

