/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeProvider {
    private static final AtomicLong lastTimeHolder = new AtomicLong();

    private TimeProvider() {
    }

    public static long currentTime() {
        long lastTime;
        long now = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        do {
            if (now > (lastTime = lastTimeHolder.get())) continue;
            return lastTime;
        } while (!lastTimeHolder.compareAndSet(lastTime, now));
        return now;
    }

    public static long systemTimeIntervalBetween(long earlierTime, long laterTime, TimeUnit systemTimeIntervalUnit) {
        long intervalNanos = laterTime - earlierTime;
        return systemTimeIntervalUnit.convert(intervalNanos, TimeUnit.NANOSECONDS);
    }
}

