/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

abstract class AbstractCharSequenceUtf8DataAccess<T extends CharSequence>
extends AbstractData<T>
implements DataAccess<T>,
Data<T> {
    private transient Bytes bytes;
    transient T cs;

    AbstractCharSequenceUtf8DataAccess() {
        this.initTransients();
    }

    private void initTransients() {
        this.bytes = Bytes.allocateElasticDirect((long)1L);
    }

    @Override
    public Data<T> getData(@NotNull T cs) {
        this.cs = cs;
        this.bytes.clear();
        BytesUtil.appendUtf8((StreamingDataOutput)this.bytes, cs);
        return this;
    }

    @Override
    public void uninit() {
        this.cs = null;
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytes.bytesStore();
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return this.bytes.readRemaining();
    }

    @Override
    public T get() {
        return this.cs;
    }
}

