/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.SizePrefixedBlob;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles;
import net.openhft.chronicle.hash.impl.util.FileIOUtils;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.impl.util.math.PoissonDistribution;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilderPrivateAPI;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.OldDeletedEntriesCleanup;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.wire.TextWire;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChronicleMapBuilder<K, V>
implements ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    private static final int UNDEFINED_ALIGNMENT_CONFIG = -1;
    private static final int NO_ALIGNMENT = 1;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final Logger LOG = LoggerFactory.getLogger((String)ChronicleMapBuilder.class.getName());
    private static final double UNDEFINED_DOUBLE_CONFIG = Double.NaN;
    private static int MAX_BOOTSTRAPPING_HEADER_SIZE = (int)MemoryUnit.KILOBYTES.toBytes(16L);
    private static final ConcurrentHashMap<File, Void> fileLockingControl = new ConcurrentHashMap(128);
    private ChronicleMapBuilderPrivateAPI<K, V> privateAPI = new ChronicleMapBuilderPrivateAPI(this);
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    private int minSegments = -1;
    private int actualSegments = -1;
    private long entriesPerSegment = -1L;
    private long actualChunksPerSegmentTier = -1L;
    private double averageKeySize = Double.NaN;
    K averageKey;
    private K sampleKey;
    private double averageValueSize = Double.NaN;
    V averageValue;
    private V sampleValue;
    private int actualChunkSize = 0;
    private int worstAlignment = -1;
    private int maxChunksPerEntry = -1;
    private int alignment = -1;
    private long entries = -1L;
    private double maxBloatFactor = 1.0;
    private boolean allowSegmentTiering = true;
    private double nonTieredSegmentsPercentile = 0.99999;
    private boolean aligned64BitMemoryOperationsAtomic = OS.is64Bit();
    private ChecksumEntries checksumEntries = ChecksumEntries.IF_PERSISTED;
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    long cleanupTimeout = 1L;
    TimeUnit cleanupTimeoutUnit = TimeUnit.MINUTES;
    boolean cleanupRemovedEntries = true;
    DefaultValueProvider<K, V> defaultValueProvider = DefaultSpi.defaultValueProvider();
    byte replicationIdentifier = (byte)-1;
    MapMethods<K, V, ?> methods = DefaultSpi.mapMethods();
    MapEntryOperations<K, V, ?> entryOperations = DefaultSpi.mapEntryOperations();
    MapRemoteOperations<K, V, ?> remoteOperations = DefaultSpi.mapRemoteOperations();
    private boolean replicated;
    private boolean persisted;

    private static boolean isDefined(double config) {
        return !Double.isNaN(config);
    }

    private static long toLong(double v) {
        long l = Math.round(v);
        if ((double)l != v) {
            throw new IllegalArgumentException("Integer argument expected, given " + v);
        }
        return l;
    }

    private static long roundUp(double v) {
        return Math.round(Math.ceil(v));
    }

    private static long roundDown(double v) {
        return (long)v;
    }

    private static void fileLockedIO(File file, FileChannel fileChannel, FileIOAction fileIOAction) throws IOException {
        fileLockingControl.compute(file, (k, v) -> {
            try {
                try (FileLock ignored = fileChannel.lock();){
                    fileIOAction.fileIOAction();
                }
                return null;
            }
            catch (IOException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
    }

    ChronicleMapBuilder(Class<K> keyClass, Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass);
        this.valueBuilder = new SerializationBuilder<V>(valueClass);
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    private static void checkSegments(long segments) {
        if (segments <= 0L) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000L) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            result.privateAPI = new ChronicleMapBuilderPrivateAPI(result);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Deprecated
    public Object privateAPI() {
        return this.privateAPI;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKeySize(double averageKeySize) {
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.keyBuilder, "Key");
        ChronicleMapBuilder.checkAverageSize(averageKeySize, "key");
        this.averageKeySize = averageKeySize;
        this.averageKey = null;
        this.sampleKey = null;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKey(K averageKey) {
        java.util.Objects.requireNonNull(averageKey);
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.keyBuilder, "Key");
        this.averageKey = averageKey;
        this.sampleKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(K sampleKey) {
        this.sampleKey = sampleKey;
        this.averageKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    private double averageKeySize() {
        if (!ChronicleMapBuilder.isDefined(this.averageKeySize)) {
            throw new AssertionError();
        }
        return this.averageKeySize;
    }

    public ChronicleMapBuilder<K, V> averageValueSize(double averageValueSize) {
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.valueBuilder, "Value");
        ChronicleMapBuilder.checkAverageSize(averageValueSize, "value");
        this.averageValueSize = averageValueSize;
        this.averageValue = null;
        this.sampleValue = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> averageValue(V averageValue) {
        java.util.Objects.requireNonNull(averageValue);
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.valueBuilder, "Value");
        this.averageValue = averageValue;
        this.sampleValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    private static void checkSizeIsStaticallyKnown(SerializationBuilder builder, String role) {
        if (builder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Size of " + builder.tClass + " instances is constant and statically known, shouldn't be specified via " + "average" + role + "Size() or average" + role + "() methods");
        }
    }

    private static void checkAverageSize(double averageSize, String role) {
        if (averageSize <= 0.0 || Double.isNaN(averageSize) || Double.isInfinite(averageSize)) {
            throw new IllegalArgumentException("Average " + role + " size must be a positive, " + "finite number");
        }
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(V sampleValue) {
        this.sampleValue = sampleValue;
        this.averageValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    double averageValueSize() {
        if (!ChronicleMapBuilder.isDefined(this.averageValueSize)) {
            throw new AssertionError();
        }
        return this.averageValueSize;
    }

    private <E> double averageKeyOrValueSize(double configuredSize, SerializationBuilder<E> builder, E average) {
        if (ChronicleMapBuilder.isDefined(configuredSize)) {
            return configuredSize;
        }
        if (builder.constantSizeMarshaller()) {
            return builder.constantSize();
        }
        if (average != null) {
            return builder.serializationSize(average);
        }
        return Double.NaN;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunkSize(int actualChunkSize) {
        if (this.constantlySizedEntries()) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.tClass + " and " + "value type: " + this.valueBuilder.tClass + " are both constant, " + "so chunk size shouldn't be specified manually");
        }
        if (actualChunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        this.actualChunkSize = actualChunkSize;
        return this;
    }

    SerializationBuilder<K> keyBuilder() {
        return this.keyBuilder;
    }

    private EntrySizeInfo entrySizeInfo() {
        int worstAlignment;
        double size = 0.0;
        double keySize = this.averageKeySize();
        size += ChronicleMapBuilder.averageSizeStoringLength(this.keyBuilder, keySize);
        size += keySize;
        if (this.replicated) {
            size += 10.0;
        }
        if (this.checksumEntries()) {
            size += 4.0;
        }
        double valueSize = this.averageValueSize();
        size += ChronicleMapBuilder.averageSizeStoringLength(this.valueBuilder, valueSize);
        int alignment = this.valueAlignment();
        if (this.worstAlignmentComputationRequiresValueSize(alignment)) {
            long constantSizeBeforeAlignment = ChronicleMapBuilder.toLong(size);
            if (this.constantlySizedValues()) {
                long totalDataSize = constantSizeBeforeAlignment + this.constantValueSize();
                worstAlignment = (int)(VanillaChronicleMap.alignAddr(totalDataSize, alignment) - totalDataSize);
            } else if (this.actualChunkSize > 0) {
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, this.actualChunkSize);
            } else {
                int chunkSize = 8;
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                if (!(size + (double)worstAlignment + valueSize >= (double)(ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated) * chunkSize))) {
                    chunkSize = 4;
                    worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                }
            }
        } else {
            worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
        }
        size += (double)worstAlignment;
        return new EntrySizeInfo(size += valueSize, worstAlignment);
    }

    private boolean worstAlignmentComputationRequiresValueSize(int alignment) {
        return alignment != 1 && this.constantlySizedKeys() && this.valueBuilder.constantStoringLengthSizeMarshaller();
    }

    private int worstAlignmentWithoutValueSize(int alignment) {
        return alignment - 1;
    }

    int segmentEntrySpaceInnerOffset() {
        if (!this.constantlySizedEntries()) {
            return 0;
        }
        return (int)(this.constantValueSize() % (long)this.valueAlignment());
    }

    private long constantValueSize() {
        return this.valueBuilder.constantSize();
    }

    boolean constantlySizedKeys() {
        return this.keyBuilder.constantSizeMarshaller() || this.sampleKey != null;
    }

    private static double averageSizeStoringLength(SerializationBuilder builder, double averageSize) {
        int upperStoringLength;
        SizeMarshaller sizeMarshaller = builder.sizeMarshaller();
        if (averageSize == (double)Math.round(averageSize)) {
            return sizeMarshaller.storingLength(Math.round(averageSize));
        }
        long lower = ChronicleMapBuilder.roundDown(averageSize);
        long upper = lower + 1L;
        int lowerStoringLength = sizeMarshaller.storingLength(lower);
        if (lowerStoringLength == (upperStoringLength = sizeMarshaller.storingLength(upper))) {
            return lowerStoringLength;
        }
        return (double)lower * ((double)upper - averageSize) + (double)upper * (averageSize - (double)lower);
    }

    private int worstAlignmentAssumingChunkSize(long constantSizeBeforeAlignment, int chunkSize) {
        int alignment = this.valueAlignment();
        long firstAlignment = VanillaChronicleMap.alignAddr(constantSizeBeforeAlignment, alignment) - constantSizeBeforeAlignment;
        int gcdOfAlignmentAndChunkSize = ChronicleMapBuilder.greatestCommonDivisor(alignment, chunkSize);
        if (gcdOfAlignmentAndChunkSize == alignment) {
            return (int)firstAlignment;
        }
        long worstAlignment = firstAlignment;
        while (worstAlignment + (long)gcdOfAlignmentAndChunkSize < (long)alignment) {
            worstAlignment += (long)gcdOfAlignmentAndChunkSize;
        }
        return (int)worstAlignment;
    }

    int worstAlignment() {
        if (this.worstAlignment >= 0) {
            return this.worstAlignment;
        }
        int alignment = this.valueAlignment();
        if (!this.worstAlignmentComputationRequiresValueSize(alignment)) {
            this.worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
            return this.worstAlignment;
        }
        this.worstAlignment = this.entrySizeInfo().worstAlignment;
        return this.worstAlignment;
    }

    void worstAlignment(int worstAlignment) {
        assert (worstAlignment >= 0);
        this.worstAlignment = worstAlignment;
    }

    static int greatestCommonDivisor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ChronicleMapBuilder.greatestCommonDivisor(b, a % b);
    }

    long chunkSize() {
        if (this.actualChunkSize > 0) {
            return this.actualChunkSize;
        }
        double averageEntrySize = this.entrySizeInfo().averageEntrySize;
        if (this.constantlySizedEntries()) {
            return ChronicleMapBuilder.toLong(averageEntrySize);
        }
        int maxChunkSize = 0x40000000;
        for (long chunkSize = 4L; chunkSize <= (long)maxChunkSize; chunkSize *= 2L) {
            if (!((double)((long)ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated) * chunkSize) > averageEntrySize)) continue;
            return chunkSize;
        }
        return maxChunkSize;
    }

    boolean constantlySizedEntries() {
        return this.constantlySizedKeys() && this.constantlySizedValues();
    }

    double averageChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1.0;
        }
        long chunkSize = this.chunkSize();
        return (this.entrySizeInfo().averageEntrySize + (double)chunkSize - 1.0) / (double)chunkSize;
    }

    private static int maxDefaultChunksPerAverageEntry(boolean replicated) {
        return replicated ? 4 : 8;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxChunksPerEntry(int maxChunksPerEntry) {
        if (maxChunksPerEntry < 1) {
            throw new IllegalArgumentException("maxChunksPerEntry should be >= 1, " + maxChunksPerEntry + " given");
        }
        this.maxChunksPerEntry = maxChunksPerEntry;
        return this;
    }

    int maxChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1;
        }
        long actualChunksPerSegmentTier = this.actualChunksPerSegmentTier();
        int result = (int)Math.min(actualChunksPerSegmentTier, Integer.MAX_VALUE);
        if (this.maxChunksPerEntry > 0) {
            result = Math.min(this.maxChunksPerEntry, result);
        }
        return result;
    }

    boolean constantlySizedValues() {
        return this.valueBuilder.constantSizeMarshaller() || this.sampleValue != null;
    }

    public ChronicleMapBuilder<K, V> entryAndValueOffsetAlignment(int alignment) {
        if (alignment <= 0) {
            throw new IllegalArgumentException("Alignment should be positive integer, " + alignment + " given");
        }
        if (!Maths.isPowerOf2((long)alignment)) {
            throw new IllegalArgumentException("Alignment should be a power of 2, " + alignment + " given");
        }
        this.alignment = alignment;
        return this;
    }

    int valueAlignment() {
        if (this.alignment != -1) {
            return this.alignment;
        }
        try {
            return ValueModel.acquire(this.valueBuilder.tClass).recommendedOffsetAlignment();
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this;
    }

    long entries() {
        if (this.entries < 0L) {
            throw new IllegalStateException("If in-memory Chronicle Map is created or persisted\nto a file for the first time (i. e. not accessing existing file),\nChronicleMapBuilder.entries() must be configured.\nSee Chronicle Map 3 tutorial and javadocs for more information");
        }
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> entriesPerSegment(long entriesPerSegment) {
        if (entriesPerSegment <= 0L) {
            throw new IllegalArgumentException("Entries per segment should be positive, " + entriesPerSegment + " given");
        }
        this.entriesPerSegment = entriesPerSegment;
        return this;
    }

    long entriesPerSegment() {
        double averageChunksPerEntry;
        boolean actualChunksDefined;
        long entriesPerSegment;
        if (this.entriesPerSegment > 0L) {
            entriesPerSegment = this.entriesPerSegment;
        } else {
            int actualSegments = this.actualSegments();
            double averageEntriesPerSegment = (double)this.entries() * 1.0 / (double)actualSegments;
            entriesPerSegment = actualSegments > 1 ? PoissonDistribution.inverseCumulativeProbability(averageEntriesPerSegment, this.nonTieredSegmentsPercentile) : ChronicleMapBuilder.roundUp(averageEntriesPerSegment);
        }
        boolean bl = actualChunksDefined = this.actualChunksPerSegmentTier > 0L;
        if (!actualChunksDefined && (double)entriesPerSegment * (averageChunksPerEntry = this.averageChunksPerEntry()) > 1.073741824E9) {
            throw new IllegalStateException("Max chunks per segment tier is 1073741824 configured entries() and actualSegments() so that there should be " + entriesPerSegment + " entries per segment tier, " + "while average chunks per entry is " + averageChunksPerEntry);
        }
        if (entriesPerSegment > 0x20000000L) {
            throw new IllegalStateException("shouldn't be more than 536870912 entries per segment");
        }
        return entriesPerSegment;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunksPerSegmentTier(long actualChunksPerSegmentTier) {
        if (actualChunksPerSegmentTier <= 0L || actualChunksPerSegmentTier > 0x40000000L) {
            throw new IllegalArgumentException("Actual chunks per segment tier should be in [1, 1073741824], range, " + actualChunksPerSegmentTier + " given");
        }
        this.actualChunksPerSegmentTier = actualChunksPerSegmentTier;
        return this;
    }

    private void checkActualChunksPerSegmentTierIsConfiguredOnlyIfOtherLowLevelConfigsAreManual() {
        if (this.actualChunksPerSegmentTier > 0L && (this.entriesPerSegment <= 0L || this.actualChunkSize <= 0 && !this.constantlySizedEntries() || this.actualSegments <= 0)) {
            throw new IllegalStateException("Actual chunks per segment tier could be configured only if other three low level configs are manual: entriesPerSegment(), actualSegments() and actualChunkSize(), unless both keys and value sizes are constant");
        }
    }

    private void checkActualChunksPerSegmentGreaterOrEqualToEntries() {
        if (this.actualChunksPerSegmentTier > 0L && this.entriesPerSegment > 0L && this.entriesPerSegment > this.actualChunksPerSegmentTier) {
            throw new IllegalStateException("Entries per segment couldn't be greater than actual chunks per segment tier. Entries: " + this.entriesPerSegment + ", " + "chunks: " + this.actualChunksPerSegmentTier + " is configured");
        }
    }

    long actualChunksPerSegmentTier() {
        if (this.actualChunksPerSegmentTier > 0L) {
            return this.actualChunksPerSegmentTier;
        }
        return this.chunksPerSegmentTier(this.entriesPerSegment());
    }

    private long chunksPerSegmentTier(long entriesPerSegment) {
        return ChronicleMapBuilder.roundUp((double)entriesPerSegment * this.averageChunksPerEntry());
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        ChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2((long)(this.entries() / 32L), (long)1L), (long)this.estimateSegmentsBasedOnSize());
    }

    private int estimateSegmentsBasedOnSize() {
        int segmentsForEntries = ChronicleMapBuilder.estimateSegmentsForEntries(this.entries());
        double averageValueSize = this.averageValueSize();
        return averageValueSize >= 1000000.0 ? segmentsForEntries * 16 : (averageValueSize >= 100000.0 ? segmentsForEntries * 8 : (averageValueSize >= 10000.0 ? segmentsForEntries * 4 : (averageValueSize >= 1000.0 ? segmentsForEntries * 2 : segmentsForEntries)));
    }

    private static int estimateSegmentsForEntries(long size) {
        if (size > 0xC800000L) {
            return 256;
        }
        if (size >= 0x100000L) {
            return 128;
        }
        if (size >= 131072L) {
            return 64;
        }
        if (size >= 16384L) {
            return 32;
        }
        if (size >= 4096L) {
            return 16;
        }
        if (size >= 1024L) {
            return 8;
        }
        return 1;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        ChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (this.entriesPerSegment > 0L) {
            return (int)this.segmentsGivenEntriesPerSegmentFixed(this.entriesPerSegment);
        }
        long segments = this.tryHashLookupSlotSize(4);
        if (segments > 0L) {
            return (int)segments;
        }
        int maxHashLookupEntrySize = this.aligned64BitMemoryOperationsAtomic() ? 8 : 4;
        long maxEntriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(maxHashLookupEntrySize);
        long maxSegments = this.trySegments(maxEntriesPerSegment, 0x40000000);
        if (maxSegments > 0L) {
            return (int)maxSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries (" + this.entries() + ") or average chunks per entry is too high (" + this.averageChunksPerEntry() + ") that builder automatically decided to use " + -maxSegments + " segments");
    }

    private long tryHashLookupSlotSize(int hashLookupSlotSize) {
        long entriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(hashLookupSlotSize);
        long entrySpaceSize = ChronicleMapBuilder.roundUp((double)entriesPerSegment * this.entrySizeInfo().averageEntrySize);
        if (entrySpaceSize < (long)OS.pageSize() * 5L) {
            return -1L;
        }
        return this.trySegments(entriesPerSegment, 0x40000000);
    }

    private long findMaxEntriesPerSegmentToFitHashLookupSlotSize(int targetHashLookupSlotSize) {
        long entriesPerSegment = 0x4000000000000000L;
        for (long step = entriesPerSegment / 2L; step > 0L; step /= 2L) {
            if (this.hashLookupSlotBytes(entriesPerSegment) <= targetHashLookupSlotSize) continue;
            entriesPerSegment -= step;
        }
        return entriesPerSegment - 1L;
    }

    private int hashLookupSlotBytes(long entriesPerSegment) {
        int valueBits = CompactOffHeapLinearHashTable.valueBits(this.chunksPerSegmentTier(entriesPerSegment));
        int keyBits = CompactOffHeapLinearHashTable.keyBits(entriesPerSegment, valueBits);
        return CompactOffHeapLinearHashTable.entrySize(keyBits, valueBits);
    }

    private long trySegments(long entriesPerSegment, int maxSegments) {
        long segments = this.segmentsGivenEntriesPerSegmentFixed(entriesPerSegment);
        return (segments = Maths.nextPower2((long)Math.max(segments, (long)this.minSegments()), (long)1L)) <= (long)maxSegments ? segments : -segments;
    }

    private long segmentsGivenEntriesPerSegmentFixed(long entriesPerSegment) {
        double precision = 1.0 / this.averageChunksPerEntry();
        long entriesPerSegmentShouldBe = ChronicleMapBuilder.roundDown(PoissonDistribution.meanByCumulativeProbabilityAndValue(this.nonTieredSegmentsPercentile, entriesPerSegment, precision));
        long segments = Maths.divideRoundUp((long)this.entries(), (long)entriesPerSegmentShouldBe);
        ChronicleMapBuilder.checkSegments(segments);
        if (this.minSegments > 0) {
            segments = Math.max((long)this.minSegments, segments);
        }
        return segments;
    }

    long tierHashLookupCapacity() {
        long entriesPerSegment = this.entriesPerSegment();
        long capacity = CompactOffHeapLinearHashTable.capacityFor(entriesPerSegment);
        if (this.actualSegments() > 1) {
            long maxEntriesPerTier = PoissonDistribution.inverseCumulativeProbability(entriesPerSegment, this.nonTieredSegmentsPercentile);
            while ((double)maxEntriesPerTier > 0.8 * (double)capacity) {
                capacity *= 2L;
            }
        }
        return capacity;
    }

    int segmentHeaderSize() {
        long pageSize;
        int segments = this.actualSegments();
        if ((long)(segments * 192) < 2L * (pageSize = (long)OS.pageSize())) {
            return 192;
        }
        if ((long)(segments * 128) < 3L * pageSize) {
            return 128;
        }
        return segments <= 16384 ? 64 : 32;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxBloatFactor(double maxBloatFactor) {
        if (Double.isNaN(maxBloatFactor) || maxBloatFactor < 1.0 || maxBloatFactor > 1000.0) {
            throw new IllegalArgumentException("maxBloatFactor should be in [1.0, 1_000.0] bounds, " + maxBloatFactor + " given");
        }
        this.maxBloatFactor = maxBloatFactor;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> allowSegmentTiering(boolean allowSegmentTiering) {
        this.allowSegmentTiering = allowSegmentTiering;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> nonTieredSegmentsPercentile(double nonTieredSegmentsPercentile) {
        if (Double.isNaN(nonTieredSegmentsPercentile) || 0.5 <= nonTieredSegmentsPercentile || nonTieredSegmentsPercentile >= 1.0) {
            throw new IllegalArgumentException("nonTieredSegmentsPercentile should be in (0.5, 1.0) range, " + nonTieredSegmentsPercentile + " is given");
        }
        this.nonTieredSegmentsPercentile = nonTieredSegmentsPercentile;
        return this;
    }

    long maxExtraTiers() {
        if (!this.allowSegmentTiering) {
            return 0L;
        }
        int actualSegments = this.actualSegments();
        return Math.round((this.maxBloatFactor - 1.0) * (double)actualSegments) + (long)actualSegments;
    }

    public String toString() {
        return "ChronicleMapBuilder{, actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", entriesPerSegment=" + ChronicleMapBuilder.pretty(this.entriesPerSegment) + ", actualChunksPerSegmentTier=" + ChronicleMapBuilder.pretty(this.actualChunksPerSegmentTier) + ", averageKeySize=" + ChronicleMapBuilder.pretty(this.averageKeySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", averageValueSize=" + ChronicleMapBuilder.pretty(this.averageValueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", actualChunkSize=" + ChronicleMapBuilder.pretty(this.actualChunkSize) + ", valueAlignment=" + this.valueAlignment() + ", entries=" + this.entries() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    ChronicleMapBuilder<K, V> removedEntryCleanupTimeout(long removedEntryCleanupTimeout, TimeUnit unit) {
        if (unit.toMillis(removedEntryCleanupTimeout) < 1L) {
            throw new IllegalArgumentException("timeout should be >= 1 millisecond, " + removedEntryCleanupTimeout + " " + (Object)((Object)unit) + " is given");
        }
        this.cleanupTimeout = removedEntryCleanupTimeout;
        this.cleanupTimeoutUnit = unit;
        return this;
    }

    ChronicleMapBuilder<K, V> cleanupRemovedEntries(boolean cleanupRemovedEntries) {
        this.cleanupRemovedEntries = cleanupRemovedEntries;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyReaderAndDataAccess(SizedReader<K> keyReader, @NotNull DataAccess<K> keyDataAccess) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.dataAccess(keyDataAccess);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull SizedReader<K> keyReader, @NotNull SizedWriter<? super K> keyWriter) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.writer(keyWriter);
        return this;
    }

    @Override
    public <M extends SizedReader<K> & SizedWriter<? super K>> ChronicleMapBuilder<K, V> keyMarshaller(@NotNull M sizedMarshaller) {
        return this.keyMarshallers((SizedReader)sizedMarshaller, (SizedWriter)sizedMarshaller);
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull BytesReader<K> keyReader, @NotNull BytesWriter<? super K> keyWriter) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.writer(keyWriter);
        return this;
    }

    @Override
    public <M extends BytesReader<K> & BytesWriter<? super K>> ChronicleMapBuilder<K, V> keyMarshaller(@NotNull M marshaller) {
        return this.keyMarshallers((BytesReader)marshaller, (BytesWriter)marshaller);
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> aligned64BitMemoryOperationsAtomic(boolean aligned64BitMemoryOperationsAtomic) {
        this.aligned64BitMemoryOperationsAtomic = aligned64BitMemoryOperationsAtomic;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> checksumEntries(boolean checksumEntries) {
        this.checksumEntries = checksumEntries ? ChecksumEntries.YES : ChecksumEntries.NO;
        return this;
    }

    boolean checksumEntries() {
        switch (this.checksumEntries) {
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
            case IF_PERSISTED: {
                return this.persisted;
            }
        }
        throw new AssertionError();
    }

    boolean aligned64BitMemoryOperationsAtomic() {
        return this.aligned64BitMemoryOperationsAtomic;
    }

    public ChronicleMapBuilder<K, V> valueReaderAndDataAccess(SizedReader<V> valueReader, @NotNull DataAccess<V> valueDataAccess) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.dataAccess(valueDataAccess);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull SizedReader<V> valueReader, @NotNull SizedWriter<? super V> valueWriter) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.writer(valueWriter);
        return this;
    }

    public <M extends SizedReader<V> & SizedWriter<? super V>> ChronicleMapBuilder<K, V> valueMarshaller(@NotNull M sizedMarshaller) {
        return this.valueMarshallers(sizedMarshaller, sizedMarshaller);
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesReader<V> valueReader, @NotNull BytesWriter<? super V> valueWriter) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.writer(valueWriter);
        return this;
    }

    public <M extends BytesReader<V> & BytesWriter<? super V>> ChronicleMapBuilder<K, V> valueMarshaller(@NotNull M marshaller) {
        return this.valueMarshallers(marshaller, marshaller);
    }

    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.valueBuilder.sizeMarshaller(valueSizeMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        java.util.Objects.requireNonNull(defaultValueProvider);
        this.defaultValueProvider = defaultValueProvider;
        return this;
    }

    ChronicleMapBuilder<K, V> replication(byte identifier) {
        if (identifier <= 0) {
            throw new IllegalArgumentException("Identifier must be positive, " + identifier + " given");
        }
        this.replicationIdentifier = identifier;
        return this;
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(File file) throws IOException {
        return ((ChronicleMapBuilder)this.clone()).createWithFile(file, false, false);
    }

    @Override
    public ChronicleMap<K, V> createOrRecoverPersistedTo(File file) throws IOException {
        return file.exists() ? this.recoverPersistedTo(file, true) : this.createPersistedTo(file);
    }

    @Override
    public ChronicleMap<K, V> recoverPersistedTo(File file, boolean sameBuilderConfig) throws IOException {
        return ((ChronicleMapBuilder)this.clone()).createWithFile(file, true, sameBuilderConfig);
    }

    @Override
    public ChronicleMap<K, V> create() {
        return ((ChronicleMapBuilder)this.clone()).createWithoutFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChronicleMap<K, V> createWithFile(File file, boolean recover, boolean overrideBuilderConfig) throws IOException {
        if (overrideBuilderConfig && !recover) {
            throw new AssertionError((Object)"recover -> overrideBuilderConfig");
        }
        this.replicated = this.replicationIdentifier != -1;
        this.persisted = true;
        if (!file.exists()) {
            if (recover) {
                throw new FileNotFoundException("file " + file + " should exist for recovery");
            }
            file.createNewFile();
        }
        VanillaChronicleMap<K, V, ?> result = null;
        RandomAccessFile raf = CanonicalRandomAccessFiles.acquire(file);
        try {
            if (raf.length() > 0L) {
                VanillaChronicleMap<K, V, ?> vanillaChronicleMap = result = this.openWithExistingFile(file, raf, recover, overrideBuilderConfig);
                return vanillaChronicleMap;
            }
            VanillaChronicleMap[] map = new VanillaChronicleMap[1];
            ByteBuffer[] headerBuffer = new ByteBuffer[1];
            boolean[] newFile = new boolean[1];
            FileChannel fileChannel = raf.getChannel();
            ChronicleMapBuilder.fileLockedIO(file, fileChannel, () -> {
                if (raf.length() == 0L) {
                    map[0] = this.newMap();
                    headerBuffer[0] = ChronicleMapBuilder.writeHeader(fileChannel, map[0]);
                    newFile[0] = true;
                } else {
                    newFile[0] = false;
                }
            });
            if (newFile[0]) {
                int headerSize = headerBuffer[0].remaining();
                result = this.createWithNewFile(map[0], file, raf, headerBuffer[0], headerSize);
                VanillaChronicleMap<K, V, ?> vanillaChronicleMap = result;
                return vanillaChronicleMap;
            }
            result = this.openWithExistingFile(file, raf, recover, overrideBuilderConfig);
            VanillaChronicleMap<K, V, ?> vanillaChronicleMap = result;
            return vanillaChronicleMap;
        }
        finally {
            if (result != null) {
                result.registerRafReleaser();
            } else {
                CanonicalRandomAccessFiles.release(file);
            }
        }
    }

    private int waitUntilReady(RandomAccessFile raf, boolean recover) throws IOException {
        FileChannel fileChannel = raf.getChannel();
        ByteBuffer sizeWordBuffer = ByteBuffer.allocate(4);
        sizeWordBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int attempts = 600;
        int lastReadHeaderSize = -1;
        for (int attempt = 0; attempt < attempts; ++attempt) {
            if (raf.length() >= 12L) {
                sizeWordBuffer.clear();
                FileIOUtils.readFully(fileChannel, 8L, sizeWordBuffer);
                if (sizeWordBuffer.remaining() == 0) {
                    int sizeWord = sizeWordBuffer.getInt(0);
                    lastReadHeaderSize = SizePrefixedBlob.extractSize(sizeWord);
                    if (SizePrefixedBlob.isReady(sizeWord)) {
                        return lastReadHeaderSize;
                    }
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                if (recover) break;
                throw new IOException(e);
            }
        }
        if (recover) {
            if (lastReadHeaderSize == -1) {
                throw new ChronicleHashRecoveryFailedException("File header is not recoverable");
            }
            return lastReadHeaderSize;
        }
        throw new IOException("Unable to wait until the file is ready, likely the process which created the file crashed or hung for more than 1 minute");
    }

    private ByteBuffer checkSumSelfBootstrappingHeader(RandomAccessFile raf, int headerSize, boolean recover) throws IOException {
        if (raf.length() < (long)(headerSize + 12)) {
            throw VanillaChronicleHash.throwRecoveryOrReturnIOException("The file is shorter than the header size: " + headerSize + ", file size: " + raf.length(), recover);
        }
        FileChannel fileChannel = raf.getChannel();
        ByteBuffer headerBuffer = ByteBuffer.allocate(12 + headerSize);
        headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FileIOUtils.readFully(fileChannel, 0L, headerBuffer);
        if (headerBuffer.remaining() > 0) {
            throw VanillaChronicleHash.throwRecoveryOrReturnIOException("Unable to read the header fully, " + headerBuffer.remaining() + " is remaining to read, likely the file was " + "truncated", recover);
        }
        int sizeWord = headerBuffer.getInt(8);
        if (!SizePrefixedBlob.isReady(sizeWord)) {
            if (recover) {
                LOG.error("size-prefixed blob readiness bit is set to NOT_READY");
            } else {
                throw new IOException("sizeWord is not ready: " + sizeWord);
            }
        }
        long checkSum = ChronicleMapBuilder.headerChecksum(headerBuffer, headerSize);
        long storedChecksum = headerBuffer.getLong(0);
        if (storedChecksum != checkSum) {
            throw VanillaChronicleHash.throwRecoveryOrReturnIOException("Self Bootstrapping Header checksum doesn't match the stored checksum: " + storedChecksum + ", computed: " + checkSum, recover);
        }
        headerBuffer.position(12);
        return headerBuffer;
    }

    private static long headerChecksum(ByteBuffer headerBuffer, int headerSize) {
        return LongHashFunction.xx_r39().hashBytes(headerBuffer, 8, headerSize + 4);
    }

    private VanillaChronicleMap<K, V, ?> createWithNewFile(VanillaChronicleMap<K, V, ?> map, File file, RandomAccessFile raf, ByteBuffer headerBuffer, int headerSize) throws IOException {
        map.initBeforeMapping(file, raf, headerBuffer.limit(), false);
        map.createMappedStoreAndSegments();
        ChronicleMapBuilder.commitChronicleMapReady(map, raf, headerBuffer, headerSize);
        this.establishReplication(map);
        return map;
    }

    private VanillaChronicleMap<K, V, ?> openWithExistingFile(File file, RandomAccessFile raf, boolean recover, boolean overrideBuilderConfig) throws IOException {
        try {
            ByteBuffer headerBuffer;
            int headerSize = this.waitUntilReady(raf, recover);
            FileChannel fileChannel = raf.getChannel();
            if (overrideBuilderConfig) {
                VanillaChronicleMap<K, V, ?> mapObjectForHeaderOverwrite = this.newMap();
                headerBuffer = ChronicleMapBuilder.writeHeader(fileChannel, mapObjectForHeaderOverwrite);
                headerSize = headerBuffer.remaining();
            } else {
                headerBuffer = this.checkSumSelfBootstrappingHeader(raf, headerSize, recover);
                assert (headerSize == headerBuffer.remaining());
            }
            Bytes headerBytes = Bytes.wrapForRead((ByteBuffer)headerBuffer);
            headerBytes.readPosition((long)headerBuffer.position());
            headerBytes.readLimit((long)headerBuffer.limit());
            TextWire wire = new TextWire(headerBytes);
            VanillaChronicleMap map = (VanillaChronicleMap)wire.getValueIn().typedMarshallable();
            assert (map != null);
            map.initBeforeMapping(file, raf, headerBuffer.limit(), recover);
            long dataStoreSize = map.globalMutableState().getDataStoreSize();
            if (!recover && dataStoreSize > file.length()) {
                throw new IOException("The file " + file + " the map is serialized from " + "has unexpected length " + file.length() + ", probably corrupted. " + "Data store size is " + dataStoreSize);
            }
            map.initTransientsFromBuilder(this);
            if (!recover) {
                map.createMappedStoreAndSegments();
            } else {
                if (!overrideBuilderConfig) {
                    ChronicleMapBuilder.writeNotReady(fileChannel, headerBuffer, headerSize);
                }
                map.recover();
                ChronicleMapBuilder.commitChronicleMapReady(map, raf, headerBuffer, headerSize);
            }
            this.establishReplication(map);
            return map;
        }
        catch (Exception e) {
            if (recover && !(e instanceof IOException) && !(e instanceof ChronicleHashRecoveryFailedException)) {
                throw new ChronicleHashRecoveryFailedException(e);
            }
            throw e;
        }
    }

    private static void writeNotReady(FileChannel fileChannel, ByteBuffer headerBuffer, int headerSize) throws IOException {
        headerBuffer.putInt(8, Integer.MIN_VALUE | headerSize);
        headerBuffer.clear().position(8).limit(12);
        FileIOUtils.writeFully(fileChannel, 8L, headerBuffer);
    }

    private static <K, V> ByteBuffer writeHeader(FileChannel fileChannel, VanillaChronicleMap<K, V, ?> map) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(12 + MAX_BOOTSTRAPPING_HEADER_SIZE);
        headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Bytes headerBytes = Bytes.wrapForWrite((ByteBuffer)headerBuffer);
        headerBytes.writePosition(12L);
        TextWire wire = new TextWire(headerBytes);
        wire.getValueOut().typedMarshallable(map);
        int headerLimit = (int)headerBytes.writePosition();
        int headerSize = headerLimit - 12;
        headerBuffer.putInt(8, 0 | headerSize);
        long checksum = ChronicleMapBuilder.headerChecksum(headerBuffer, headerSize);
        headerBuffer.putLong(0, checksum);
        headerBuffer.putInt(8, Integer.MIN_VALUE | headerSize);
        headerBuffer.position(0).limit(headerLimit);
        FileIOUtils.writeFully(fileChannel, 0L, headerBuffer);
        headerBuffer.position(12);
        return headerBuffer;
    }

    private static void commitChronicleMapReady(VanillaChronicleHash map, RandomAccessFile raf, ByteBuffer headerBuffer, int headerSize) throws IOException {
        FileChannel fileChannel = raf.getChannel();
        map.msync();
        headerBuffer.putInt(8, 0 | headerSize);
        headerBuffer.clear().position(8).limit(12);
        FileIOUtils.writeFully(fileChannel, 8L, headerBuffer);
    }

    ChronicleMap<K, V> createWithoutFile() {
        this.replicated = this.replicationIdentifier != -1;
        this.persisted = false;
        try {
            VanillaChronicleMap<K, V, ?> map = this.newMap();
            NativeBytesStore bytesStore = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)map.sizeInBytesWithoutTiers());
            map.createMappedStoreAndSegments((BytesStore)bytesStore);
            this.establishReplication(map);
            return map;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private VanillaChronicleMap<K, V, ?> newMap() throws IOException {
        this.preMapConstruction();
        if (this.replicated) {
            return new ReplicatedChronicleMap(this);
        }
        return new VanillaChronicleMap(this);
    }

    void preMapConstruction() {
        this.averageKeySize = this.preMapConstruction(this.keyBuilder, this.averageKeySize, this.averageKey, this.sampleKey, "Key");
        this.averageValueSize = this.preMapConstruction(this.valueBuilder, this.averageValueSize, this.averageValue, this.sampleValue, "Value");
        this.stateChecks();
    }

    private <E> double preMapConstruction(SerializationBuilder<E> builder, double configuredAverageSize, E average, E sample, String dim) {
        if (sample != null) {
            return builder.constantSizeBySample(sample);
        }
        double result = this.averageKeyOrValueSize(configuredAverageSize, builder, average);
        if (!Double.isNaN(result) || this.allLowLevelConfigurationsAreManual()) {
            return result;
        }
        throw new IllegalStateException(dim + " size in serialized form must " + "be configured in ChronicleMap, at least approximately.\nUse builder" + ".average" + dim + "()/.constant" + dim + "SizeBySample()/" + ".average" + dim + "Size() methods to configure the size");
    }

    private void stateChecks() {
        this.checkActualChunksPerSegmentTierIsConfiguredOnlyIfOtherLowLevelConfigsAreManual();
        this.checkActualChunksPerSegmentGreaterOrEqualToEntries();
    }

    private boolean allLowLevelConfigurationsAreManual() {
        return this.actualSegments > 0 && this.entriesPerSegment > 0L && this.actualChunksPerSegmentTier > 0L && this.actualChunkSize > 0;
    }

    private void establishReplication(VanillaChronicleMap<K, V, ?> map) throws IOException {
        if (map instanceof ReplicatedChronicleMap) {
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            if (this.cleanupRemovedEntries) {
                this.establishCleanupThread(result);
            }
        }
    }

    private void establishCleanupThread(ReplicatedChronicleMap map) {
        OldDeletedEntriesCleanup cleanup = new OldDeletedEntriesCleanup(map);
        NamedThreadFactory threadFactory = new NamedThreadFactory("cleanup thread for map persisted at " + map.file());
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        executor.submit(cleanup);
        map.addCloseable((Closeable)((Object)cleanup));
        map.addCloseable(() -> {
            executor.shutdown();
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("", (Throwable)e);
            }
        });
    }

    public ChronicleMapBuilder<K, V> entryOperations(MapEntryOperations<K, V, ?> entryOperations) {
        java.util.Objects.requireNonNull(entryOperations);
        this.entryOperations = entryOperations;
        return this;
    }

    public ChronicleMapBuilder<K, V> mapMethods(MapMethods<K, V, ?> mapMethods) {
        java.util.Objects.requireNonNull(mapMethods);
        this.methods = mapMethods;
        return this;
    }

    ChronicleMapBuilder<K, V> remoteOperations(MapRemoteOperations<K, V, ?> remoteOperations) {
        java.util.Objects.requireNonNull(remoteOperations);
        this.remoteOperations = remoteOperations;
        return this;
    }

    static class EntrySizeInfo {
        final double averageEntrySize;
        final int worstAlignment;

        public EntrySizeInfo(double averageEntrySize, int worstAlignment) {
            this.averageEntrySize = averageEntrySize;
            this.worstAlignment = worstAlignment;
        }
    }

    static enum ChecksumEntries {
        YES,
        NO,
        IF_PERSISTED;

    }

    static interface FileIOAction {
        public void fileIOAction() throws IOException;
    }
}

