/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.replication.ReplicationChannel;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;

final class MapInstanceBuilder<K, V>
implements ChronicleHashInstanceBuilder<ChronicleMap<K, V>>,
Serializable {
    final ChronicleMapBuilder<K, V> mapBuilder;
    transient SingleChronicleHashReplication singleHashReplication;
    transient ReplicationChannel channel;
    transient File file;
    String name;
    volatile boolean used = false;

    MapInstanceBuilder(ChronicleMapBuilder<K, V> mapBuilder, SingleChronicleHashReplication singleHashReplication) {
        this.mapBuilder = mapBuilder;
        this.singleHashReplication = singleHashReplication;
    }

    public MapInstanceBuilder<K, V> replicated(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        return this.replicated(((SingleChronicleHashReplication.Builder)SingleChronicleHashReplication.builder().tcpTransportAndNetwork(tcpTransportAndNetwork)).createWithId(identifier));
    }

    public MapInstanceBuilder<K, V> replicated(SingleChronicleHashReplication replication) {
        this.singleHashReplication = replication;
        this.channel = null;
        return this;
    }

    public MapInstanceBuilder<K, V> replicatedViaChannel(ReplicationChannel channel) {
        this.singleHashReplication = null;
        this.channel = channel;
        return this;
    }

    public MapInstanceBuilder<K, V> persistedTo(File file) {
        this.file = file;
        return this;
    }

    public MapInstanceBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public synchronized ChronicleMap<K, V> create() throws IOException {
        if (!this.used) {
            ChronicleMap<K, V> map = this.mapBuilder.create(this, false, false);
            this.used = true;
            return map;
        }
        throw MapInstanceBuilder.alreadyCreated();
    }

    @Override
    public synchronized ChronicleMap<K, V> recover(boolean sameBuilderConfig) throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("persistedTo(file) must be configured for ChronicleHashInstanceBuilder, for recover()");
        }
        if (!this.used) {
            ChronicleMap<K, V> map = this.mapBuilder.create(this, true, sameBuilderConfig);
            this.used = true;
            return map;
        }
        throw MapInstanceBuilder.alreadyCreated();
    }

    private static IllegalStateException alreadyCreated() {
        return new IllegalStateException("A ChronicleHash has already been created using this ChronicleHashInstanceBuilder. Create a new instance builder (chronicleHashBuilder.instance()) to create another Chronicle Hash");
    }
}

