/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.io.Serializable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class InstanceCreatingMarshaller<T>
implements Serializable,
Marshallable {
    private Class<T> tClass;

    protected InstanceCreatingMarshaller(Class<T> tClass) {
        this.tClass = tClass;
    }

    protected Class<T> tClass() {
        return this.tClass;
    }

    protected T createInstance() {
        try {
            return this.tClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Some of default marshallers, chosen for the type\n" + this.tClass + " by default, delegates to \n" + this.getClass().getName() + " which assumes the type has a public no-arg\n" + "constructor. If this is not true, you should either extend the marshaller,\n" + "overriding createInstance() and copy() (if defined), and the extending\n" + "class shouldn't be inner, because such classes couldn't be Serializable\n" + "that is a requirement for marshaller classes, or write and configure your\n" + "own marshaller for " + this.tClass + " type from scratch, and configure for the\n" + "Chronicle Map via keyMarshaller[s]() or valueMarshaller[s]() methods", e);
        }
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.tClass = wireIn.read(() -> "tClass").typeLiteral();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "tClass").typeLiteral(this.tClass);
    }
}

