/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.LogHolder;
import net.openhft.chronicle.hash.impl.stage.iter.IterationKeyHashCode;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.slf4j.Logger;

@Staged
public class TierRecovery {
    @StageRef
    LogHolder lh;
    @StageRef
    VanillaChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    SegmentStages s;
    @StageRef
    MapEntryStages<?, ?> e;
    @StageRef
    IterationKeyHashCode khc;

    public int recoverTier(int segmentIndex) {
        this.s.freeList.clearAll();
        Logger log = LogHolder.LOG;
        VanillaChronicleHash<?, ?, ?, ?> h = this.mh.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.s.tierBaseAddr;
        long hlPos = 0L;
        block0: do {
            long startInsertPos;
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            hl.clearEntry(hlAddr, hlPos);
            long searchKey = hl.key(hlEntry);
            long entryPos = hl.value(hlEntry);
            int si = this.checkEntry(searchKey, entryPos, segmentIndex);
            if (si < 0) continue;
            segmentIndex = si;
            long insertPos = startInsertPos = hl.hlPos(searchKey);
            do {
                long hlInsertEntry;
                if (hl.empty(hlInsertEntry = hl.readEntry(hlAddr, insertPos))) {
                    hl.writeEntry(hlAddr, insertPos, hl.entry(searchKey, entryPos));
                    continue block0;
                }
                if (insertPos == hlPos) {
                    throw new ChronicleHashRecoveryFailedException("Concurrent modification of ChronicleMap at " + h.file() + " while recovery procedure is in progress");
                }
                if (hl.key(hlInsertEntry) != searchKey) continue;
                long anotherEntryPos = hl.value(hlInsertEntry);
                if (anotherEntryPos == entryPos) continue block0;
                long currentKeyOffset = this.e.keyOffset;
                long currentKeySize = this.e.keySize;
                int currentEntrySizeInChunks = this.e.entrySizeInChunks;
                if (this.checkEntry(searchKey, anotherEntryPos, segmentIndex) <= 0 || this.e.keySize != currentKeySize || !BytesUtil.bytesEqual((RandomDataInput)this.s.segmentBS, (long)currentKeyOffset, (RandomDataInput)this.s.segmentBS, (long)this.e.keyOffset, (long)currentKeySize)) continue;
                log.error("Entries with duplicate keys within a tier: at pos {} and {} with key {}, first value is {}", new Object[]{entryPos, anotherEntryPos, this.e.key(), this.e.value()});
                this.s.freeList.clearRange(entryPos, entryPos + (long)currentEntrySizeInChunks);
                continue block0;
            } while ((insertPos = hl.step(insertPos)) != startInsertPos);
            throw new ChronicleHashRecoveryFailedException("HashLookup overflow should never occur. It might also be concurrent access to ChronicleMap at " + h.file() + " while recovery procedure is in progress");
        } while ((hlPos = hl.step(hlPos)) != 0L);
        return segmentIndex;
    }

    public void removeDuplicatesInSegment() {
        long startHlPos = 0L;
        VanillaChronicleMap<?, ?, ?> m = this.mh.m();
        CompactOffHeapLinearHashTable hashLookup = m.hashLookup;
        long currentTierBaseAddr = this.s.tierBaseAddr;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startHlPos))) {
            startHlPos = hashLookup.step(startHlPos);
        }
        long hlPos = startHlPos;
        int steps = 0;
        long entries = 0L;
        do {
            hlPos = hashLookup.step(hlPos);
            ++steps;
            long entry = hashLookup.readEntry(currentTierBaseAddr, hlPos);
            if (hashLookup.empty(entry)) continue;
            this.e.readExistingEntry(hashLookup.value(entry));
            Data key = this.e.key();
            try (ExternalHashQueryContext c = m.queryContext(key);){
                HashEntry entry2 = c.entry();
                Data key2 = ((MapEntry)((Object)c)).key();
                if (key2.bytes().address(key2.offset()) != key.bytes().address(key.offset())) {
                    LogHolder.LOG.error("entries with duplicate key {} in segment {}: with values {} and {}, removing the latter", new Object[]{key, c.segmentIndex(), entry2 != null ? ((MapEntry)((Object)c)).value() : "<deleted>", !this.e.entryDeleted() ? this.e.value() : "<deleted>"});
                    if (hashLookup.remove(currentTierBaseAddr, hlPos) == hlPos) continue;
                    hlPos = hashLookup.stepBack(hlPos);
                    --steps;
                    continue;
                }
            }
            ++entries;
        } while (hlPos != startHlPos || steps == 0);
        this.recoverTierEntriesCounter(entries);
        this.recoverLowestPossibleFreeChunkTiered();
    }

    private void recoverTierEntriesCounter(long entries) {
        if (this.s.tierEntries() != entries) {
            LogHolder.LOG.error("Wrong number of entries counter for tier with index {}, stored: {}, should be: {}", new Object[]{this.s.tierIndex, this.s.tierEntries(), entries});
            this.s.tierEntries(entries);
        }
    }

    private void recoverLowestPossibleFreeChunkTiered() {
        long lowestFreeChunk = this.s.freeList.nextClearBit(0L);
        if (lowestFreeChunk == -1L) {
            lowestFreeChunk = this.mh.m().actualChunksPerSegmentTier;
        }
        if (this.s.lowestPossiblyFreeChunk() != lowestFreeChunk) {
            LogHolder.LOG.error("wrong lowest free chunk for tier with index {}, stored: {}, should be: {}", new Object[]{this.s.tierIndex, this.s.lowestPossiblyFreeChunk(), lowestFreeChunk});
            this.s.lowestPossiblyFreeChunk(lowestFreeChunk);
        }
    }

    private int checkEntry(long searchKey, long entryPos, int segmentIndex) {
        Logger log = LogHolder.LOG;
        VanillaChronicleHash<?, ?, ?, ?> h = this.mh.h();
        if (entryPos < 0L || entryPos >= h.actualChunksPerSegmentTier) {
            log.error("Entry pos is out of range: {}, should be 0-{}", (Object)entryPos, (Object)(h.actualChunksPerSegmentTier - 1L));
        }
        try {
            this.e.readExistingEntry(entryPos);
        }
        catch (Exception e) {
            log.error("Exception while reading entry key size: {}", (Throwable)e);
            return -1;
        }
        if (this.e.keyEnd() > this.s.segmentBytes.capacity()) {
            log.error("Wrong key size: {}", (Object)this.e.keySize);
            return -1;
        }
        long keyHashCode = this.khc.keyHashCode();
        int segmentIndexFromKey = h.hashSplitting.segmentIndex(keyHashCode);
        if (segmentIndexFromKey < 0 || segmentIndexFromKey >= h.actualSegments) {
            log.error("Segment index from the entry key hash code is out of range: {}, should be 0-{}, entry key: {}", new Object[]{segmentIndexFromKey, h.actualSegments - 1, this.e.key()});
            return -1;
        }
        long segmentHashFromKey = h.hashSplitting.segmentHash(keyHashCode);
        long searchKeyFromKey = h.hashLookup.maskUnsetKey(segmentHashFromKey);
        if (searchKey != searchKeyFromKey) {
            log.error("HashLookup searchKey: {}, HashLookup searchKey from the entry key hash code: {}, entry key: {}", new Object[]{searchKey, searchKeyFromKey, this.e.key()});
            return -1;
        }
        try {
            long entryAndChecksumEnd = this.e.entryEnd() + this.e.checksumStrategy.extraEntryBytes();
            if (entryAndChecksumEnd > this.s.segmentBytes.capacity()) {
                log.error("Wrong value size: {}, key: {}", (Object)this.e.valueSize, this.e.key());
                return -1;
            }
        }
        catch (Exception ex) {
            log.error("Exception while reading entry value size: {}, key: {}", (Object)ex, this.e.key());
            return -1;
        }
        int storedChecksum = this.e.checksumStrategy.storedChecksum();
        int checksumFromEntry = this.e.checksumStrategy.computeChecksum();
        if (storedChecksum != checksumFromEntry) {
            log.error("Checksum doesn't match, stored: {}, should be from the entry bytes: {}, key: {}, value: {}", new Object[]{storedChecksum, checksumFromEntry, this.e.key(), this.e.value()});
            return -1;
        }
        if (!this.s.freeList.isRangeClear(entryPos, entryPos + (long)this.e.entrySizeInChunks)) {
            log.error("Overlapping entry: positions {}-{}, key: {}, value: {}", new Object[]{entryPos, entryPos + (long)this.e.entrySizeInChunks - 1L, this.e.key(), this.e.value()});
        }
        this.s.freeList.setRange(entryPos, entryPos + (long)this.e.entrySizeInChunks);
        if (segmentIndex < 0) {
            return segmentIndexFromKey;
        }
        if (segmentIndex != segmentIndexFromKey) {
            log.error("Expected segment index: {}, segment index from the entry key: {}, key: {}, value: {}", new Object[]{segmentIndex, searchKeyFromKey, this.e.key(), this.e.value()});
            return -1;
        }
        return segmentIndex;
    }
}

