/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.stage.replication.ReplicableEntryDelegating;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.ReplicatedIterationContext;
import net.openhft.chronicle.map.impl.stage.data.ZeroBytesStore;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValueData;
import net.openhft.chronicle.set.SetAbsentEntry;
import net.openhft.chronicle.set.SetContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledReplicatedMapIterationContext<K, V, R>
extends ChainingInterface
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
HashSegmentContext<K, MapEntry<K, V>>,
ReplicatedHashSegmentContext<K, MapEntry<K, V>>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
RemoteOperationContext<K>,
ReplicableEntry,
MapAbsentEntry<K, V>,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContext<K, V, R>,
ReplicatedChronicleMapHolder<K, V, R>,
ReplicatedIterationContext<K, V, R>,
MapReplicableEntry<K, V>,
SetAbsentEntry<K>,
SetContext<K, R> {
    final Thread owner;
    public final int indexInContextChain;
    public final ReadLock innerReadLock;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledReplicatedMapIterationContext.class);
    public final WriteLock innerWriteLock;
    public final SizedReader<K> keyReader;
    public final UpdateLock innerUpdateLock;
    public final SizedReader<V> valueReader;
    public final ChainingInterface rootContextInThisThread;
    final EntryKeyBytesData entryKey;
    final DummyValueZeroData dummyValue;
    final WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder;
    final HashEntryChecksumStrategy hashEntryChecksumStrategy;
    public final List<ChainingInterface> contextChain;
    public final EntryValueBytesData entryValue;
    final ReplicatedMapEntryDelegating entryDelegating;
    private final ReplicatedChronicleMap<K, V, R> m;
    private final ReusableBitSet freeList;
    public final PointerBytesStore segmentBS;
    final ReplicatedMapAbsentDelegatingForIteration absentEntryDelegating;
    public final ChecksumStrategy checksumStrategy;
    public final Bytes segmentBytes;
    long searchKey = 0L;
    public long searchStartPos;
    public long keySize = -1L;
    public long hashLookupEntry = 0L;
    public int segmentIndex = -1;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    public int tier = -1;
    public long tierIndex;
    public long tierBaseAddr;
    long entrySpaceOffset = 0L;
    boolean used;
    EntriesToTest entriesToTest = null;
    public boolean entryRemovedOnThisIteration = false;
    public Data<K> inputKey = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean nestedContextsLockedOnSameSegment;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextLockedOnThisSegment = null;
    public long hashLookupPos = -1L;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public long keyOffset = -1L;
    public long valueSizeOffset = -1L;
    public long valueSize = -1L;
    public long valueOffset;
    long replicationBytesOffset = -1L;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;
    long keyHash = 0L;
    public boolean delayedUpdateChecksum = false;
    public int allocatedChunks = 0;
    public long innerRemoteTimestamp;
    public byte innerRemoteIdentifier = 0;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean reallocGuarded(long fromPos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.realloc(fromPos, oldChunks, newChunks);
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks();
    }

    public long allocReturnCodeGuarded(int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.allocReturnCode(chunks);
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForWrite();
    }

    @Override
    public void close() {
        this.closeLocks();
        this.closeSegment();
        this.entryValue.closeCachedEntryValue();
        this.closeEntryOffset();
        this.closeKeySearch();
        this.entryKey.closeCachedEntryKey();
        this.closeKeyHash();
        this.closeReplicationUpdate();
        this.wrappedValueInstanceValueHolder.closeWrappedData();
        this.closeValueSize();
        this.closeSegmentTier();
        this.closeHashLookupPos();
        this.closeAllocatedChunks();
        this.closeKeyOffset();
        this.closePos();
        this.wrappedValueInstanceValueHolder.closeNext();
        this.closeEntrySizeInChunks();
        this.closeInputKey();
        this.closeDelayedUpdateChecksum();
        this.closeEntryRemovedOnThisIteration();
        this.closeSearchKey();
        this.closeEntriesToTest();
        this.closeSegmentHeader();
        this.closeReplicationState();
        this.closeUsed();
        this.closeSegmentIndex();
        this.closeHashLookupEntry();
        this.closeKeySize();
        this.wrappedValueInstanceValueHolder.closeValue();
        this.closeValueSizeOffset();
        this.closeHashLookupSearchFoundDependants();
        this.closeHashLookupSearchHlDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants();
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeReplicatedChronicleMapHolderImplMDependants();
        this.closeHashLookupSearchAddrDependants();
        this.closeReplicatedMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.closeHashLookupSearchNextPosDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants();
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
    }

    public void freeExtraGuarded(long pos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.freeExtra(pos, oldChunks, newChunks);
    }

    public void freeGuarded(long fromPos, int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.free(fromPos, chunks);
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    private long _MapEntryStages_countValueSizeOffset() {
        return this.keyEnd();
    }

    private long _MapEntryStages_sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)((ReplicatedChronicleMap)this.m()).keySizeMarshaller.storingLength(keySize) + keySize + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.storingLength(valueSize);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledReplicatedMapIterationContext(ChainingInterface c, ReplicatedChronicleMap<K, V, R> m) {
        this.contextChain = c.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = c;
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.dummyValue = new DummyValueZeroData();
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.entryKey = new EntryKeyBytesData();
        this.innerReadLock = new ReadLock();
        this.valueReader = StatefulCopyable.copyIfNeeded(((ReplicatedChronicleMap)this.m()).valueReader);
        this.absentEntryDelegating = new ReplicatedMapAbsentDelegatingForIteration();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.entryDelegating = new ReplicatedMapEntryDelegating();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    public CompiledReplicatedMapIterationContext(ReplicatedChronicleMap<K, V, R> m) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.dummyValue = new DummyValueZeroData();
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.entryKey = new EntryKeyBytesData();
        this.innerReadLock = new ReadLock();
        this.valueReader = StatefulCopyable.copyIfNeeded(((ReplicatedChronicleMap)this.m()).valueReader);
        this.absentEntryDelegating = new ReplicatedMapAbsentDelegatingForIteration();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.entryDelegating = new ReplicatedMapEntryDelegating();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long lowestPossiblyFreeChunk = this.lowestPossiblyFreeChunk();
        if (lowestPossiblyFreeChunk + (long)chunks > h.actualChunksPerSegmentTier) {
            return -1L;
        }
        if (this.tierEntries() >= h.maxEntriesPerHashLookup) {
            return -1L;
        }
        assert (lowestPossiblyFreeChunk < h.actualChunksPerSegmentTier);
        long ret = this.freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegmentTier) {
            if (ret + (long)chunks > h.actualChunksPerSegmentTier) {
                assert (ret != -1L);
                this.freeList.clearRange(ret, ret + (long)chunks);
            }
            return -1L;
        }
        this.tierEntries(this.tierEntries() + 1L);
        if (chunks == 1 || this.freeList.isSet(lowestPossiblyFreeChunk)) {
            this.lowestPossiblyFreeChunk(ret + (long)chunks);
        }
        return ret;
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!this.h().isOpen()) {
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        }
    }

    private void _MapSegmentIteration_doRemove() {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    private void _MapSegmentIteration_doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    private void _SegmentStages_checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((CompiledReplicatedMapIterationContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    private void _SegmentStages_nextTier() {
        VanillaChronicleHash h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex(), this.tier() + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex();
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
        }
    }

    public void free(long fromPos, int chunks) {
        this.tierEntries(this.tierEntries() - 1L);
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(fromPos);
        }
    }

    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + (long)newChunks;
        this.freeList.clearRange(from, pos + (long)oldChunks);
        if (from < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(from);
        }
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = this.decrementRead();
                if (newTotalReadLockCount == 0) {
                    if (this.updateZero() && this.writeZero()) {
                        this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    }
                } else assert (newTotalReadLockCount > 0) : "read underflow";
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (this.writeZero()) {
                        if (this.readZero()) {
                            this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        } else {
                            this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                        }
                    }
                } else assert (newTotalUpdateLockCount > 0) : "update underflow";
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.updateZero()) {
                        this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                        break;
                    }
                    if (!this.readZero()) {
                        this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBytes.capacity());
        return this.segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L);
        return this.segmentBytes;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while (true) {
            assert (prevContext.nextNode() != null);
            if (prevContext.nextNode() == this) break;
            prevContext = prevContext.nextNode();
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    private Object _MapSegmentIteration_entryForIteration() {
        return this;
    }

    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    private boolean _MapSegmentIteration_forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    private boolean _MapSegmentIteration_shouldTestEntry() {
        return true;
    }

    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (fromPos + (long)newChunks < this.h().actualChunksPerSegmentTier && this.freeList.isRangeClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
            this.freeList.setRange(fromPos + (long)oldChunks, fromPos + (long)newChunks);
            return true;
        }
        return false;
    }

    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    private void _MapEntryStages_relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset(), this.pos(), this.entrySizeInChunks());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), this.pos());
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return LOG;
    }

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public DummyValueZeroData dummyValue() {
        return this.dummyValue;
    }

    public WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder() {
        return this.wrappedValueInstanceValueHolder;
    }

    public HashEntryChecksumStrategy hashEntryChecksumStrategy() {
        return this.hashEntryChecksumStrategy;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public ReplicatedMapEntryDelegating entryDelegating() {
        return this.entryDelegating;
    }

    public ReusableBitSet freeList() {
        return this.freeList;
    }

    public ReplicatedMapAbsentDelegatingForIteration absentEntryDelegating() {
        return this.absentEntryDelegating;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public Bytes segmentBytes() {
        return this.segmentBytes;
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    public void closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeReplicatedChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }

    @Override
    @NotNull
    public CompiledReplicatedMapIterationContext<K, V, R> context() {
        return this;
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException("Update or Write locking is forbidden in the contextof locked iteration context");
        }
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException("Entry was already removed on this iteration");
        }
    }

    public void closeReplicatedMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        }
        return this.delayedUpdateChecksumInit() || this.checksumStrategy.innerCheckSum();
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceValueHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        }
        this.initDelayedUpdateChecksum(true);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.dummyValue;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public ReplicatedChronicleMap<K, V, R> m() {
        return this.m;
    }

    public void closeReplicatedChronicleMapHolderImplMDependants() {
        this.closeValueSize();
        this.wrappedValueInstanceValueHolder.closeValue();
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        long sizeWithoutChecksum = ((ReplicatedChronicleMap)this.m()).constantlySizedEntry ? VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue + valueSize, ((ReplicatedChronicleMap)this.m()).alignment) : (((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation ? sizeOfEverythingBeforeValue + (long)((ReplicatedChronicleMap)this.m()).worstAlignment + valueSize : VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, ((ReplicatedChronicleMap)this.m()).alignment) + valueSize);
        return sizeWithoutChecksum + this.checksumStrategy.extraEntryBytes();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.replaceValue(entry, newValue);
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return this._MapEntryStages_sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.remove(entry);
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return ((ReplicatedChronicleMap)this.m()).entryOperations.insert(absentEntry, value);
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    @Override
    public ChronicleSet<K> set() {
        return this.m.chronicleSet;
    }

    @Override
    public ChronicleHash<K, ?, ?, ?> hash() {
        return this.set() != null ? this.set() : this.map();
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    public void closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchKey;
    }

    public long searchStartPos() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public boolean hashLookupEntryInit() {
        return this.hashLookupEntry != 0L;
    }

    public void initHashLookupEntry(long entry) {
        this.hashLookupEntry = entry;
    }

    public long hashLookupEntry() {
        assert (this.hashLookupEntryInit()) : "HashLookupEntry should be init";
        return this.hashLookupEntry;
    }

    void closeHashLookupEntry() {
        if (!this.hashLookupEntryInit()) {
            return;
        }
        this.hashLookupEntry = 0L;
    }

    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    @Override
    public int segmentIndex() {
        assert (this.segmentIndexInit()) : "SegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public boolean segmentTierInit() {
        return this.tier >= 0;
    }

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex() + 1;
        this.tierBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.tier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier_WithBaseAddr(int tier, long tierBaseAddr, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int tier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeKeyHash();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeHashLookupPos();
        this.closeHashLookupSearchAddrDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeSegment();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr() + this.h().tierHashLookupOuterSize;
    }

    public void closeIterationSegmentStagesTierCountersAreaAddrDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTier() {
        if (this.tier() == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier() - 1, this.prevTierIndex());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public void goToFirstTier() {
        while (this.tier() != 0) {
            this.prevTier();
        }
    }

    public long tierEntries() {
        if (this.tier() == 0) {
            return this.segmentHeader().entries(this.segmentHeaderAddress());
        }
        return TierCountersArea.entries(this.tierCountersAreaAddr());
    }

    public void tierEntries(long tierEntries) {
        if (this.tier() == 0) {
            this.segmentHeader().entries(this.segmentHeaderAddress(), tierEntries);
        } else {
            TierCountersArea.entries(this.tierCountersAreaAddr(), tierEntries);
        }
    }

    public void closeIterationSegmentStagesTierEntriesDependants() {
        this.closeSegment();
    }

    public long tierDeleted() {
        if (this.tier() == 0) {
            return this.segmentHeader().deleted(this.segmentHeaderAddress());
        }
        return TierCountersArea.deleted(this.tierCountersAreaAddr());
    }

    public void tierDeleted(long tierDeleted) {
        if (this.tier() == 0) {
            this.segmentHeader().deleted(this.segmentHeaderAddress(), tierDeleted);
        } else {
            TierCountersArea.deleted(this.tierCountersAreaAddr(), tierDeleted);
        }
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeHashLookupSearchAddrDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    long lowestPossiblyFreeChunk() {
        if (this.tier() == 0) {
            return this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress());
        }
        return TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr());
    }

    public void closeIterationSegmentStagesLowestPossiblyFreeChunkDependants() {
        this.closeSegment();
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if (this.tier() == 0) {
            this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress(), lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.tierFreeListOuterSize + (long)h.tierEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeEntryOffset();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public void nextTier() {
        this._SegmentStages_nextTier();
        if (this.hashLookupEntryInit()) {
            this.initSearchKey(this.h().hashLookup.key(this.hashLookupEntry()));
        }
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    @Override
    public long size() {
        this.goToFirstTier();
        long size = this.tierEntries() - this.tierDeleted();
        while (this.hasNextTier()) {
            this.nextTier();
            size += this.tierEntries() - this.tierDeleted();
        }
        return size;
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCodeGuarded(chunks);
        if (prevPos >= 0L) {
            this.freeGuarded(prevPos, prevChunks);
        }
        if (ret >= 0L) {
            return ret;
        }
        do {
            this.nextTier();
        } while ((ret = this.allocReturnCodeGuarded(chunks)) < 0L);
        return ret;
    }

    public void verifyTierCountersAreaData() {
        block2: {
            long currentTierIndex;
            this.goToFirstTier();
            do {
                int tierSegmentIndex;
                if ((tierSegmentIndex = TierCountersArea.segmentIndex(this.tierCountersAreaAddr())) != this.segmentIndex()) {
                    throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports it belongs to segmentIndex " + tierSegmentIndex));
                }
                if (!this.hasNextTier()) break block2;
                currentTierIndex = this.tierIndex();
                this.nextTier();
            } while (this.prevTierIndex() == currentTierIndex);
            throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports the previous tierIndex is " + this.prevTierIndex() + " while actually it is " + currentTierIndex));
        }
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    public boolean entriesToTestInit() {
        return this.entriesToTest != null;
    }

    void initEntriesToTest(EntriesToTest entriesToTest) {
        this.entriesToTest = entriesToTest;
    }

    public EntriesToTest entriesToTest() {
        assert (this.entriesToTestInit()) : "EntriesToTest should be init";
        return this.entriesToTest;
    }

    public void closeEntriesToTest() {
        if (!this.entriesToTestInit()) {
            return;
        }
        this.entriesToTest = null;
    }

    private long _MapSegmentIteration_tierEntriesForIteration() {
        return this.tierEntries();
    }

    public long tierEntriesForIteration() {
        return this.entriesToTest() == EntriesToTest.ALL ? this.tierEntries() : this.tierEntries() - this.tierDeleted();
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!this.entryRemovedOnThisIterationInit()) {
            return;
        }
        this.entryRemovedOnThisIteration = false;
    }

    boolean inputKeyInit() {
        return this.inputKey != null;
    }

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
    }

    public void closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextLockedOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nestedContextsLockedOnSameSegment;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextLockedOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeDelayedUpdateChecksum();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        if (this.tier() < 0) {
            throw new AssertionError();
        }
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos()) break block2;
            } while (this.hl().key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.tierBaseAddr(), this.hashLookupPos(), newValue);
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment().totalWriteLockCount();
        return s;
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    @Override
    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public void dropChange() {
        ((ReplicatedChronicleMap)this.m()).dropChange(this.tierIndex(), this.pos());
    }

    @Override
    public void dropChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.dropChange();
    }

    public boolean changed() {
        return ((ReplicatedChronicleMap)this.m()).isChanged(this.tierIndex(), this.pos());
    }

    @Override
    public boolean isChanged() {
        this.checkOnEachPublicOperation();
        this.innerReadLock.lock();
        return this.changed();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.closeReplicatedMapEntryStagesReadExistingEntryDependants();
        this.closeDelayedUpdateChecksum();
    }

    @Override
    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void closeReplicatedMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeReplicatedMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeReplicatedMapEntryStagesKeyEndDependants() {
        this.closeReplicatedMapEntryStagesCountValueSizeOffsetDependants();
        this.closeReplicationState();
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long countValueSizeOffset() {
        return this._MapEntryStages_countValueSizeOffset() + 10L;
    }

    public void closeReplicatedMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(segmentBytes);
        long currentPosition = segmentBytes.readPosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, ((ReplicatedChronicleMap)this.m()).alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.readSkip(skip);
        }
        this.valueOffset = segmentBytes.readPosition();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.valueSizeOffset());
        ((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, ((ReplicatedChronicleMap)this.m()).alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeReplicatedMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public void writeValue(Data<?> value) {
        this.initDelayedUpdateChecksum(true);
        RandomDataInput valueBytes = value.bytes();
        if (valueBytes instanceof NativeBytesStore && valueBytes.address(value.offset()) == this.segmentBS().address(this.valueOffset())) {
            return;
        }
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)((ReplicatedChronicleMap)this.m()).valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset();
    }

    public boolean replicationStateInit() {
        return this.replicationBytesOffset != -1L;
    }

    void initReplicationState() {
        this.replicationBytesOffset = this.keyEnd();
    }

    public long replicationBytesOffset() {
        if (!this.replicationStateInit()) {
            this.initReplicationState();
        }
        return this.replicationBytesOffset;
    }

    public void closeReplicationState() {
        if (!this.replicationStateInit()) {
            return;
        }
        this.replicationBytesOffset = -1L;
    }

    void updateReplicationState(long timestamp, byte identifier) {
        this.initDelayedUpdateChecksum(true);
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.replicationBytesOffset());
        segmentBytes.writeLong(timestamp);
        segmentBytes.writeByte(identifier);
    }

    public void updatedReplicationStateOnAbsentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            this.updateReplicationState(((ReplicatedChronicleMap)this.m()).timeProvider.currentTime(), ((ReplicatedChronicleMap)this.m()).identifier());
        }
    }

    @Override
    public void updateOrigin(byte newIdentifier, long newTimestamp) {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        this.updateReplicationState(newTimestamp, newIdentifier);
    }

    private long entryDeletedOffset() {
        return this.replicationBytesOffset() + 9L;
    }

    public void writeEntryDeleted() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), true);
    }

    public void writeEntryPresent() {
        this.segmentBS().writeBoolean(this.entryDeletedOffset(), false);
    }

    public boolean entryDeleted() {
        return this.segmentBS().readBoolean(this.entryDeletedOffset());
    }

    public Object entryForIteration() {
        return !this.entryDeleted() ? this.entryDelegating : this.absentEntryDelegating;
    }

    public boolean shouldTestEntry() {
        return this.entriesToTest() == EntriesToTest.ALL || !this.entryDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean forEachTierEntryWhile(Predicate<? super T> predicate, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        long leftEntries = this.tierEntriesForIteration();
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.initHashLookupPos(startPos);
        int steps = 0;
        do {
            currentHashLookupPos = hashLookup.step(this.hashLookupPos());
            ++steps;
            this.setHashLookupPosGuarded(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            if (!this.shouldTestEntry()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!predicate.test(this.entryForIteration())) {
                    interrupted = true;
                    break;
                }
                if (--leftEntries != 0L) continue;
                break;
            }
            finally {
                if (this.tier() != currentTier) {
                    this.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    --steps;
                    this.initHashLookupPos(currentHashLookupPos);
                }
                this.closeKeyOffset();
            }
        } while (currentHashLookupPos != startPos || steps == 0);
        if (!interrupted && leftEntries > 0L) {
            throw new IllegalStateException("We a tier without interruption, but according to tier counters there should be " + leftEntries + " more entries. Size diverged?");
        }
        return interrupted;
    }

    public <T> boolean innerForEachSegmentEntryWhile(Predicate<? super T> predicate) {
        try {
            this.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                boolean interrupted;
                if (interrupted = this.forEachTierEntryWhile(predicate, currentTier = this.tier(), currentTierBaseAddr = this.tierBaseAddr(), currentTierIndex = this.tierIndex())) {
                    boolean bl = false;
                    return bl;
                }
                if (currentTier == 0) {
                    boolean bl = true;
                    return bl;
                }
                this.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.PRESENT);
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super MapEntry<K, V>> action) {
        this.forEachSegmentEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)e -> {
            action.accept((Object)e);
            return true;
        }));
    }

    @Override
    public boolean forEachSegmentReplicableEntryWhile(Predicate<? super ReplicableEntry> predicate) {
        this.checkOnEachPublicOperation();
        this.initEntriesToTest(EntriesToTest.ALL);
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentReplicableEntry(Consumer<? super ReplicableEntry> action) {
        this.forEachSegmentReplicableEntryWhile(e -> {
            action.accept((ReplicableEntry)e);
            return true;
        });
    }

    @Override
    public void doRemoveCompletely() {
        boolean wasDeleted = this.entryDeleted();
        this._MapSegmentIteration_doRemove();
        if (wasDeleted) {
            this.tierDeleted(this.tierDeleted() - 1L);
        }
    }

    public long timestamp() {
        return this.segmentBS().readLong(this.replicationBytesOffset());
    }

    public void raiseChange() {
        ((ReplicatedChronicleMap)this.m()).raiseChange(this.tierIndex(), this.pos(), this.timestamp());
    }

    public void updateChange() {
        if (!this.replicationUpdateInit()) {
            this.raiseChange();
        }
    }

    @Override
    public void raiseChanged() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        this.raiseChange();
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation();
        return this.timestamp();
    }

    public void moveChange(long oldTierIndex, long oldPos, long newPos) {
        ((ReplicatedChronicleMap)this.m()).moveChange(oldTierIndex, oldPos, this.tierIndex(), newPos, this.timestamp());
    }

    private long timestampOffset() {
        return this.replicationBytesOffset();
    }

    private long identifierOffset() {
        return this.replicationBytesOffset() + 8L;
    }

    byte identifier() {
        return this.segmentBS().readByte(this.identifierOffset());
    }

    public void updatedReplicationStateOnPresentEntry() {
        if (!this.replicationUpdateInit()) {
            this.innerWriteLock.lock();
            long timestamp = this.identifier() != ((ReplicatedChronicleMap)this.m()).identifier() ? Math.max(this.timestamp() + 1L, ((ReplicatedChronicleMap)this.m()).timeProvider.currentTime()) : ((ReplicatedChronicleMap)this.m()).timeProvider.currentTime();
            this.updateReplicationState(timestamp, ((ReplicatedChronicleMap)this.m()).identifier());
        }
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation();
        return this.identifier();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeReplicatedMapEntryStagesEntryEndDependants() {
        this.closeReplicatedMapEntryStagesEntrySizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeReplicatedMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.freeGuarded(this.pos(), this.entrySizeInChunks());
        this.incrementModCountGuarded();
    }

    public void iterationRemove() {
        if (this.h().hashLookup.remove(this.tierBaseAddr(), this.hashLookupPos()) != this.hashLookupPos()) {
            this.setHashLookupPosGuarded(this.h().hashLookup.stepBack(this.hashLookupPos()));
        }
        this.innerRemoveEntryExceptHashLookupUpdate();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize());
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.searchState = null;
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.nestedContextsLockedOnSameSegment() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    public void putNewVolatile(long value) {
        if (this.searchStatePresent()) {
            throw new AssertionError();
        }
        this.hl().checkValueForPut(value);
        long currentEntry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        long addr = this.tierBaseAddr() + this.keyOffset();
        long len = this.keySize();
        this.keyHash = LongHashFunction.xx_r39().hashMemory(addr, len);
        this.closeKeyHashDependants();
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.closeKeyHashDependants();
        this.keyHash = 0L;
    }

    public void closeKeyHashDependants() {
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public void closeIterationKeyHashCodeKeyHashCodeDependants() {
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    boolean delayedUpdateChecksumInit() {
        return this.delayedUpdateChecksum;
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (this.entryOffsetInit() && this.keySizeOffset() >= 0L);
        assert (this.locksInit() && this.localLockState() != LocalLockState.UNLOCKED);
        assert (delayedUpdateChecksum);
        this.delayedUpdateChecksum = true;
    }

    public void closeDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!((ReplicatedChronicleMap)this.m()).constantlySizedEntry && ((ReplicatedChronicleMap)this.m()).couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.freeExtraGuarded(this.pos(), this.allocatedChunks(), this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.pos());
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.tier() != tierBeforeAllocation;
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long oldPos = this.pos();
        long oldTierIndex = this.tierIndex();
        this._MapEntryStages_relocation(newValue, newSizeOfEverythingBeforeValue);
        this.moveChange(oldTierIndex, oldPos, this.pos());
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, ((ReplicatedChronicleMap)this.m()).alignment)));
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.reallocGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeExtraGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks);
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
    }

    @Override
    public void doInsert(Data<V> value) {
        this.checkOnEachPublicOperation();
        if (this.entryDeleted()) {
            try {
                this.innerDefaultReplaceValue(value);
                this.tierDeleted(this.tierDeleted() - 1L);
                this.incrementModCountGuarded();
                this.writeEntryPresent();
                this.updateChange();
                this.updatedReplicationStateOnPresentEntry();
            }
            finally {
                this.innerWriteLock.unlock();
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
    }

    @Override
    public void doInsert() {
        if (this.set() == null) {
            throw new IllegalStateException("Called SetAbsentEntry.doInsert() from Map context");
        }
        this.doInsert(DummyValueData.INSTANCE);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
            this.updateChange();
            this.updatedReplicationStateOnPresentEntry();
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        try {
            if (this.valueSize() > this.dummyValue.size()) {
                this.innerDefaultReplaceValue(this.dummyValue);
            }
            this.updatedReplicationStateOnPresentEntry();
            this.writeEntryDeleted();
            this.updateChange();
            this.tierDeleted(this.tierDeleted() + 1L);
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    public boolean replicationUpdateInit() {
        return this.innerRemoteIdentifier != 0;
    }

    public void initReplicationUpdate(long timestamp, byte identifier) {
        this.innerRemoteTimestamp = timestamp;
        if (identifier == 0) {
            throw new IllegalStateException("identifier can't be 0");
        }
        this.innerRemoteIdentifier = identifier;
    }

    public byte innerRemoteIdentifier() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteIdentifier;
    }

    public long innerRemoteTimestamp() {
        assert (this.replicationUpdateInit()) : "ReplicationUpdate should be init";
        return this.innerRemoteTimestamp;
    }

    public void closeReplicationUpdate() {
        if (!this.replicationUpdateInit()) {
            return;
        }
        this.innerRemoteIdentifier = 0;
    }

    @Override
    public long remoteTimestamp() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteTimestamp();
    }

    @Override
    public byte remoteIdentifier() {
        this.checkOnEachPublicOperation();
        return this.innerRemoteIdentifier();
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public class ReplicatedMapEntryDelegating
    implements ReplicableEntryDelegating,
    MapEntry<K, V> {
        @Override
        @NotNull
        public MapContext<K, V, ?> context() {
            return CompiledReplicatedMapIterationContext.this.context();
        }

        @Override
        @NotNull
        public Data<V> value() {
            return CompiledReplicatedMapIterationContext.this.value();
        }

        @Override
        @NotNull
        public Data<K> key() {
            return CompiledReplicatedMapIterationContext.this.key();
        }

        @Override
        public ReplicableEntry d() {
            return CompiledReplicatedMapIterationContext.this;
        }

        @Override
        public void doReplaceValue(Data<V> newValue) {
            CompiledReplicatedMapIterationContext.this.doReplaceValue(newValue);
        }

        @Override
        public void doRemove() {
            CompiledReplicatedMapIterationContext.this.doRemove();
        }
    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledReplicatedMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledReplicatedMapIterationContext.this.segmentHeader().writeLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded());
                        CompiledReplicatedMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.incrementWriteGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().write;
        }
    }

    public class WrappedValueInstanceDataHolder {
        private final DataAccess<V> wrappedValueDataAccess;
        private WrappedValueInstanceDataHolder next;
        private V value;
        public Data<V> wrappedData = null;

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = (DataAccess)((ReplicatedChronicleMap)CompiledReplicatedMapIterationContext.this.m()).valueDataAccess.copy();
        }

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceDataHolder();
            }
            return this.next.getUnusedWrappedValueHolder();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueInstanceDataHolder next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledReplicatedMapIterationContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next() != null) {
                this.next().closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public boolean wrappedDataInit() {
            return this.wrappedData != null;
        }

        private void initWrappedData() {
            this.wrappedData = this.wrappedValueDataAccess.getData(this.value());
        }

        public Data<V> wrappedData() {
            if (!this.wrappedDataInit()) {
                this.initWrappedData();
            }
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        CompiledReplicatedMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    int newTotalUpdateLockCount = CompiledReplicatedMapIterationContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (!CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) break;
                        CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalUpdateLockCount > 0) : "update underflow";
                    break;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledReplicatedMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!CompiledReplicatedMapIterationContext.this.updateZeroGuarded()) {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                            break;
                        }
                        CompiledReplicatedMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledReplicatedMapIterationContext.this.segmentHeader().updateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (RuntimeException e) {
                            LOG.error(CompiledReplicatedMapIterationContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock() {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledReplicatedMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledReplicatedMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledReplicatedMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledReplicatedMapIterationContext.this.incrementUpdateGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }

    public class ReplicatedMapAbsentDelegatingForIteration
    implements ReplicableEntryDelegating,
    MapAbsentEntry<K, V>,
    SetAbsentEntry<K> {
        @Override
        @NotNull
        public CompiledReplicatedMapIterationContext<K, V, R> context() {
            return CompiledReplicatedMapIterationContext.this.context();
        }

        @Override
        @NotNull
        public Data<V> defaultValue() {
            return CompiledReplicatedMapIterationContext.this.defaultValue();
        }

        @Override
        public ReplicableEntry d() {
            return CompiledReplicatedMapIterationContext.this;
        }

        @Override
        @NotNull
        public Data<K> absentKey() {
            return CompiledReplicatedMapIterationContext.this.absentKey();
        }

        @Override
        public void doInsert() {
            CompiledReplicatedMapIterationContext.this.doInsert();
        }

        @Override
        public void doInsert(Data<V> value) {
            CompiledReplicatedMapIterationContext.this.doInsert(value);
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.readZeroGuarded() && CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledReplicatedMapIterationContext.this.readZeroGuarded() && CompiledReplicatedMapIterationContext.this.updateZeroGuarded() && CompiledReplicatedMapIterationContext.this.writeZeroGuarded()) {
                    CompiledReplicatedMapIterationContext.this.segmentHeader().readLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress());
                }
                CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledReplicatedMapIterationContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledReplicatedMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            CompiledReplicatedMapIterationContext.this.closeHashLookupPos();
            CompiledReplicatedMapIterationContext.this.closePos();
            CompiledReplicatedMapIterationContext.this.closeKeyOffset();
            CompiledReplicatedMapIterationContext.this.readUnlockAndDecrementCountGuarded();
            CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded() || !CompiledReplicatedMapIterationContext.this.updateZeroGuarded() || !CompiledReplicatedMapIterationContext.this.writeZeroGuarded() || CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            if (CompiledReplicatedMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledReplicatedMapIterationContext.this.readZeroGuarded() || !CompiledReplicatedMapIterationContext.this.updateZeroGuarded() || !CompiledReplicatedMapIterationContext.this.writeZeroGuarded() || CompiledReplicatedMapIterationContext.this.segmentHeader().tryReadLock(CompiledReplicatedMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledReplicatedMapIterationContext.this.incrementReadGuarded();
                    CompiledReplicatedMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class HashEntryChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        private int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledReplicatedMapIterationContext.this.keyHashCode();
            long keyEnd = CompiledReplicatedMapIterationContext.this.keyEnd();
            long len = CompiledReplicatedMapIterationContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledReplicatedMapIterationContext.this.tierBaseAddr() + keyEnd;
                long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapIterationContext.this.keySize(), keyHashCode, payloadChecksum);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledReplicatedMapIterationContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        public void closeHashEntryChecksumStrategyComputeChecksumDependants() {
            this.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        }

        @Override
        public boolean innerCheckSum() {
            int checksum;
            int oldChecksum = CompiledReplicatedMapIterationContext.this.segmentBS().readInt(CompiledReplicatedMapIterationContext.this.entryEnd());
            return oldChecksum == (checksum = this.computeChecksum());
        }

        @Override
        public void computeAndStoreChecksum() {
            int checksum = this.computeChecksum();
            CompiledReplicatedMapIterationContext.this.segmentBS().writeInt(CompiledReplicatedMapIterationContext.this.entryEnd(), checksum);
        }

        public void closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants() {
            CompiledReplicatedMapIterationContext.this.closeDelayedUpdateChecksum();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead;

        public EntryValueBytesData() {
            this.cachedEntryValue = CompiledReplicatedMapIterationContext.this.m().valueClass() == CharSequence.class ? new StringBuilder() : null;
            this.cachedEntryValueRead = false;
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.segmentBS();
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledReplicatedMapIterationContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledReplicatedMapIterationContext.this.valueOffset());
            return CompiledReplicatedMapIterationContext.this.valueReader.read(segmentBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.segmentBS();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledReplicatedMapIterationContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledReplicatedMapIterationContext.this.keyOffset());
            return CompiledReplicatedMapIterationContext.this.keyReader.read(bytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledReplicatedMapIterationContext.this.keyOffset();
        }
    }

    public class DummyValueZeroData
    extends AbstractData<V> {
        private final Bytes zeroBytes = ZeroBytesStore.INSTANCE.bytesForRead();

        public Bytes zeroBytes() {
            return this.zeroBytes;
        }

        @Override
        public RandomDataInput bytes() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return ZeroBytesStore.INSTANCE;
        }

        @Override
        public long offset() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return 0L;
        }

        private IllegalStateException zeroReadException(Exception cause) {
            return new IllegalStateException("Most probable cause of this exception - zero bytes of\nthe minimum positive encoding length, supported by the specified or default\nvalueSizeMarshaller() is not correct serialized form of any value. You should\nconfigure defaultValueProvider() in ChronicleMapBuilder");
        }

        @Override
        public long size() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            return Math.max(0L, ((ReplicatedChronicleMap)CompiledReplicatedMapIterationContext.this.m()).valueSizeMarshaller.minStorableSize());
        }

        @Override
        public V getUsing(V using) {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            this.zeroBytes.readPosition(0L);
            try {
                return CompiledReplicatedMapIterationContext.this.valueReader.read(this.zeroBytes, this.size(), using);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }

        @Override
        public V get() {
            CompiledReplicatedMapIterationContext.this.checkOnEachPublicOperation();
            try {
                return this.getUsing((V)null);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }
    }

    static enum EntriesToTest {
        PRESENT,
        ALL;

    }
}

