/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.TcpReplicator;
import net.openhft.chronicle.map.UdpReplicator;

interface Replicator {
    public static final String ONLY_UDP_WARN_MESSAGE = "MISSING TCP REPLICATION : The UdpReplicator only attempts to read data (it does not enforce or guarantee delivery), you should usethe UdpReplicator if you have a large number of nodes, and you wishto receive the data before it becomes available on TCP/IP. Since datadelivery is not guaranteed, it is recommended that you only usethe UDP Replicator in conjunction with a TCP Replicator";

    public static Replicator tcp(AbstractReplication replication) {
        return (builder, replica, entryExternalizable, replicatedMap) -> new TcpReplicator(replica, entryExternalizable, replication.tcpTransportAndNetwork(), replication.remoteNodeValidator(), replication.name(), replication.connectionListener());
    }

    public static Replicator udp(UdpTransportConfig replicationConfig) {
        return (builder, map, entryExternalizable, replicatedMap) -> new UdpReplicator(map, entryExternalizable, replicationConfig);
    }

    public Closeable applyTo(ChronicleMapBuilder var1, Replica var2, Replica.EntryExternalizable var3, ReplicatedChronicleMap var4) throws IOException;
}

