/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.ObjectStreamException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.replication.TimeProvider;

final class MicrosecondPrecisionSystemTimeProvider
extends TimeProvider {
    private static final long serialVersionUID = 0L;
    private static final MicrosecondPrecisionSystemTimeProvider INSTANCE = new MicrosecondPrecisionSystemTimeProvider();

    public static MicrosecondPrecisionSystemTimeProvider instance() {
        return INSTANCE;
    }

    private MicrosecondPrecisionSystemTimeProvider() {
    }

    @Override
    public long currentTime() {
        return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    @Override
    public long systemTimeIntervalBetween(long earlierTimeMicros, long laterTimeMicros, TimeUnit systemTimeIntervalUnit) {
        long intervalMicros = laterTimeMicros - earlierTimeMicros;
        return systemTimeIntervalUnit.convert(intervalMicros, TimeUnit.MICROSECONDS);
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

