/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.SetContext;
import org.jetbrains.annotations.NotNull;

public class CompiledMapIterationContext<K, V, R>
extends ChainingInterface
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
HashSegmentContext<K, MapEntry<K, V>>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
MapContext<K, V, R>,
MapEntry<K, V>,
IterationContext<K, V, R>,
VanillaChronicleMapHolder<K, V, R>,
SetContext<K, R> {
    final Thread owner;
    public final ReadLock innerReadLock;
    public final int indexInContextChain;
    public final WriteLock innerWriteLock;
    public final UpdateLock innerUpdateLock;
    final WrappedValueBytesData wrappedValueBytesData;
    final HashEntryChecksumStrategy hashEntryChecksumStrategy;
    public final SizedReader<K> keyReader;
    public final ReusableBitSet freeList;
    public final EntryKeyBytesData entryKey;
    public final SizedReader<V> valueReader;
    public final EntryValueBytesData entryValue;
    public final ChainingInterface rootContextInThisThread;
    public final PointerBytesStore segmentBS;
    final WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder;
    public final List<ChainingInterface> contextChain;
    public final Bytes segmentBytes;
    public final ChecksumStrategy checksumStrategy;
    public long keySize = -1L;
    public long hashLookupEntry = 0L;
    public int segmentIndex = -1;
    public boolean entryRemovedOnThisIteration = false;
    public Data<K> inputKey = null;
    public long pos = -1L;
    public long keyOffset = -1L;
    public long valueSizeOffset = -1L;
    public int allocatedChunks = 0;
    private VanillaChronicleMap<K, V, R> m = null;
    long searchKey = 0L;
    public long searchStartPos;
    public long segmentHeaderAddress;
    public SegmentHeader segmentHeader = null;
    public int tier = -1;
    public long tierIndex;
    public long tierBaseAddr;
    long keyHash = 0L;
    public long entrySpaceOffset = 0L;
    public long valueSize = -1L;
    public long valueOffset;
    public long keySizeOffset = -1L;
    public int entrySizeInChunks = 0;
    public boolean used;
    private boolean firstContextLockedInThisThread;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean nestedContextsLockedOnSameSegment;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextLockedOnThisSegment = null;
    public long hashLookupPos = -1L;
    protected SearchState searchState = null;
    public boolean delayedUpdateChecksum = false;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean reallocGuarded(long fromPos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.realloc(fromPos, oldChunks, newChunks);
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public RuntimeException debugContextsAndLocksGuarded(InterProcessDeadLockException e) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks(e);
    }

    public long allocReturnCodeGuarded(int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.allocReturnCode(chunks);
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForWrite();
    }

    @Override
    public void close() {
        this.doCloseDelayedUpdateChecksum();
        this.doCloseKeySearch();
        this.doCloseHashLookupPos();
        this.doCloseLocks();
        this.doCloseUsed();
        this.entryKey.doCloseCachedEntryKey();
        this.entryValue.doCloseCachedEntryValue();
        this.doCloseEntrySizeInChunks();
        this.doCloseEntryOffset();
        this.doCloseValueSize();
        this.doCloseSegment();
        this.doCloseKeyHash();
        this.doCloseSegmentTier();
        this.doCloseSegmentHeader();
        this.doCloseSearchKey();
        this.wrappedValueInstanceDataHolder.doCloseWrappedData();
        this.wrappedValueInstanceDataHolder.doCloseValue();
        this.doCloseMap();
        this.doCloseAllocatedChunks();
        this.doCloseValueSizeOffset();
        this.doCloseKeyOffset();
        this.wrappedValueInstanceDataHolder.doCloseNext();
        this.doClosePos();
        this.wrappedValueBytesData.doCloseCachedWrappedValue();
        this.wrappedValueBytesData.doCloseWrappedValueBytes();
        this.wrappedValueBytesData.doCloseWrappedValueBytesStore();
        this.wrappedValueBytesData.doCloseNext();
        this.doCloseInputKey();
        this.doCloseEntryRemovedOnThisIteration();
        this.doCloseSegmentIndex();
        this.doCloseHashLookupEntry();
        this.doCloseKeySize();
    }

    public void doCloseAllocatedChunks() {
        this.allocatedChunks = 0;
    }

    public void doCloseDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    public void doCloseEntryOffset() {
        this.keySizeOffset = -1L;
    }

    public void doCloseEntryRemovedOnThisIteration() {
        this.entryRemovedOnThisIteration = false;
    }

    public void doCloseEntrySizeInChunks() {
        this.entrySizeInChunks = 0;
    }

    public void doCloseHashLookupEntry() {
        this.hashLookupEntry = 0L;
    }

    public void doCloseHashLookupPos() {
        this.hashLookupPos = -1L;
    }

    public void doCloseInputKey() {
        this.inputKey = null;
    }

    public void doCloseKeyHash() {
        this.keyHash = 0L;
    }

    public void doCloseKeyOffset() {
        this.keyOffset = -1L;
    }

    public void doCloseKeySearch() {
        this.searchState = null;
    }

    public void doCloseKeySize() {
        this.keySize = -1L;
    }

    public void doCloseLocks() {
        if (!this.locksInit()) {
            return;
        }
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void doCloseMap() {
        this.m = null;
    }

    public void doClosePos() {
        this.pos = -1L;
    }

    public void doCloseSearchKey() {
        this.searchKey = 0L;
    }

    public void doCloseSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.entrySpaceOffset = 0L;
    }

    public void doCloseSegmentHeader() {
        this.segmentHeader = null;
    }

    public void doCloseSegmentIndex() {
        this.segmentIndex = -1;
    }

    public void doCloseSegmentTier() {
        this.tier = -1;
    }

    public void doCloseUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    public void doCloseValueSize() {
        this.valueSize = -1L;
    }

    public void doCloseValueSizeOffset() {
        this.valueSizeOffset = -1L;
    }

    public void freeExtraGuarded(long pos, int oldChunks, int newChunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.freeExtra(pos, oldChunks, newChunks);
    }

    public void freeGuarded(long fromPos, int chunks) {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        this.free(fromPos, chunks);
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public CompiledMapIterationContext(ChainingInterface rootContextInThisThread, VanillaChronicleMap map) {
        this.contextChain = rootContextInThisThread.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = rootContextInThisThread;
        this.initMap(map);
        this.entryValue = new EntryValueBytesData();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.entryKey = new EntryKeyBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = CompiledMapIterationContext.unmonitoredVanillaBytes(this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    public CompiledMapIterationContext(VanillaChronicleMap map) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.initMap(map);
        this.entryValue = new EntryValueBytesData();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.wrappedValueInstanceDataHolder = new WrappedValueInstanceDataHolder();
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueBytesData = new WrappedValueBytesData();
        this.entryKey = new EntryKeyBytesData();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = CompiledMapIterationContext.unmonitoredVanillaBytes(this.segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        assert (this.totalReadLockCount + change >= 0) : "read underflow";
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        assert (this.totalUpdateLockCount + change >= 0) : "update underflow";
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        assert (this.totalWriteLockCount + change >= 0) : "write underflow";
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException(this.h().toIdentityString() + ": Entry is too large: requires " + chunks + " chunks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long lowestPossiblyFreeChunk = this.lowestPossiblyFreeChunk();
        if (lowestPossiblyFreeChunk + (long)chunks > h.actualChunksPerSegmentTier) {
            return -1L;
        }
        if (this.tierEntries() >= h.maxEntriesPerHashLookup) {
            return -1L;
        }
        assert (lowestPossiblyFreeChunk < h.actualChunksPerSegmentTier);
        long ret = this.freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegmentTier) {
            if (ret + (long)chunks > h.actualChunksPerSegmentTier) {
                assert (ret != -1L);
                this.freeList.clearRange(ret, ret + (long)chunks);
            }
            return -1L;
        }
        this.tierEntries(this.tierEntries() + 1L);
        if (chunks == 1 || this.freeList.isSet(lowestPossiblyFreeChunk)) {
            this.lowestPossiblyFreeChunk(ret + (long)chunks);
        }
        return ret;
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkOnEachLockOperation();
    }

    private void _HashSegmentIteration_hookAfterEachIteration() {
        this.throwExceptionIfClosed();
    }

    private void _SegmentStages_checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && java.util.Objects.equals(key = ((CompiledMapIterationContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Nested same-thread contexts cannot access the same key " + key);
        }
    }

    private void _SegmentStages_nextTier() {
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            Jvm.debug().on(this.getClass(), "Allocate tier for segment #  " + this.segmentIndex() + " tier " + (this.tier() + 1));
            nextTierIndex = h.allocateTier();
            this.nextTierIndex(nextTierIndex);
            long prevTierIndex = this.tierIndex();
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
            TierCountersArea.segmentIndex(this.tierCountersAreaAddr(), this.segmentIndex());
            TierCountersArea.tier(this.tierCountersAreaAddr(), this.tier());
            this.nextTierIndex(0L);
            this.prevTierIndex(prevTierIndex);
        } else {
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
        }
    }

    public void free(long fromPos, int chunks) {
        this.tierEntries(this.tierEntries() - 1L);
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(fromPos);
        }
    }

    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + (long)newChunks;
        this.freeList.clearRange(from, pos + (long)oldChunks);
        if (from < this.lowestPossiblyFreeChunk()) {
            this.lowestPossiblyFreeChunk(from);
        }
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                if (this.decrementRead() == 0 && this.updateZero() && this.writeZero()) {
                    this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                }
                return;
            }
            case UPDATE_LOCKED: {
                if (this.decrementUpdate() == 0 && this.writeZero()) {
                    if (this.readZero()) {
                        this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                    } else {
                        this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                    }
                }
                return;
            }
            case WRITE_LOCKED: {
                if (this.decrementWrite() != 0) break;
                if (!this.updateZero()) {
                    this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                    break;
                }
                if (!this.readZero()) {
                    this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                    break;
                }
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    @Override
    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBS.capacity());
        return this.segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L).readLimit(this.segmentBS.capacity());
        return this.segmentBytes;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface nextNode;
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while ((nextNode = prevContext.nextNode()) != this && nextNode != null) {
            prevContext = nextNode;
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Attempt to close contexts not structurally");
        }
    }

    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (fromPos + (long)newChunks < this.h().actualChunksPerSegmentTier && this.freeList.isRangeClear(fromPos + (long)oldChunks, fromPos + (long)newChunks)) {
            this.freeList.setRange(fromPos + (long)oldChunks, fromPos + (long)newChunks);
            return true;
        }
        return false;
    }

    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public RuntimeException debugContextsAndLocks(InterProcessDeadLockException e) {
        String message = this.h().toIdentityString() + ":\n";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        throw new InterProcessDeadLockException(message, e);
    }

    public WrappedValueBytesData wrappedValueBytesData() {
        return this.wrappedValueBytesData;
    }

    public HashEntryChecksumStrategy hashEntryChecksumStrategy() {
        return this.hashEntryChecksumStrategy;
    }

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    @NotNull
    private static VanillaBytes unmonitoredVanillaBytes(PointerBytesStore segmentBS) {
        VanillaBytes bytes = new VanillaBytes((BytesStore)segmentBS);
        IOTools.unmonitor((Object)bytes);
        return bytes;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public WrappedValueInstanceDataHolder wrappedValueInstanceDataHolder() {
        return this.wrappedValueInstanceDataHolder;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    private static <T extends ChainingInterface> T initUsedAndReturn(VanillaChronicleMap map, ChainingInterface context) {
        try {
            context.initUsed(true, map);
            return (T)context;
        }
        catch (Throwable throwable) {
            try {
                ((AutoCloseable)((Object)context)).close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public void readFoundEntry(long pos, long keySizeOffset, long keySize, long keyOffset) {
        this.initPos(pos);
        this.initEntryOffset(keySizeOffset);
        this.initKeySize(keySize);
        this.initKeyOffset(keyOffset);
    }

    public void closeMapEntryStagesReadFoundEntryDependants() {
        this.closeKeySearch();
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    public void closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public void hookAfterEachIteration() {
        this.throwExceptionIfClosed();
        this.wrappedValueInstanceDataHolder.closeValue();
    }

    public Object entryForIteration() {
        return this;
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, BiFunction<ChainingInterface, VanillaChronicleMap, T> createChaining, VanillaChronicleMap map) {
        ChainingInterface context;
        for (int i = 0; i < this.contextChain.size(); ++i) {
            context = this.contextChain.get(i);
            if (context.getClass() != contextClass || context.usedInit()) continue;
            return CompiledMapIterationContext.initUsedAndReturn(map, context);
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException(map.toIdentityString() + ": More than " + maxNestedContexts + " nested ChronicleHash contexts\n" + "are not supported. Very probable that you simply forgot to close context\n" + "somewhere (recommended to use try-with-resources statement).\n" + "Otherwise this is a bug, please report with this\n" + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context = (ChainingInterface)createChaining.apply(this, map);
        return CompiledMapIterationContext.initUsedAndReturn(map, context);
    }

    @Override
    @NotNull
    public CompiledMapIterationContext<K, V, R> context() {
        return this;
    }

    public boolean entryDeleted() {
        return false;
    }

    public void closeEntry() {
        this.closePos();
        this.closeEntryOffset();
        this.closeKeySize();
        this.closeKeyOffset();
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    public void closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public boolean shouldTestEntry() {
        return true;
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        boolean wasKeySizeInit = this.keySizeInit();
        this.keySize = keySize;
        if (wasKeySizeInit) {
            this.closeKeySizeDependants();
        }
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeKeyHash();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public boolean hashLookupEntryInit() {
        return this.hashLookupEntry != 0L;
    }

    public void initHashLookupEntry(long entry) {
        this.throwExceptionIfClosed();
        this.hashLookupEntry = entry;
    }

    public long hashLookupEntry() {
        assert (this.hashLookupEntryInit()) : "HashLookupEntry should be init";
        return this.hashLookupEntry;
    }

    void closeHashLookupEntry() {
        this.hashLookupEntry = 0L;
    }

    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        boolean wasSegmentIndexInit = this.segmentIndexInit();
        this.segmentIndex = segmentIndex;
        if (wasSegmentIndexInit) {
            this.closeSegmentIndexDependants();
        }
    }

    @Override
    public int segmentIndex() {
        assert (this.segmentIndexInit()) : "SegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentHeader();
        this.closeSegmentTier();
    }

    boolean entryRemovedOnThisIterationInit() {
        return this.entryRemovedOnThisIteration;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        this.entryRemovedOnThisIteration = false;
    }

    public boolean inputKeyInit() {
        return this.inputKey != null;
    }

    public void initInputKey(Data<K> inputKey) {
        boolean wasInputKeyInit = this.inputKeyInit();
        this.inputKey = inputKey;
        if (wasInputKeyInit) {
            this.closeInputKeyDependants();
        }
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        boolean wasPosInit = this.posInit();
        this.pos = pos;
        if (wasPosInit) {
            this.closePosDependants();
        }
    }

    @Override
    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        boolean wasKeyOffsetInit = this.keyOffsetInit();
        this.keyOffset = keyOffset;
        if (wasKeyOffsetInit) {
            this.closeKeyOffsetDependants();
        }
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeKeyHash();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        boolean wasValueSizeOffsetInit = this.valueSizeOffsetInit();
        this.valueSizeOffset = this.countValueSizeOffset();
        if (wasValueSizeOffsetInit) {
            this.closeValueSizeOffsetDependants();
        }
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        this.allocatedChunks = 0;
    }

    public boolean mapInit() {
        return this.m != null;
    }

    public void initMap(VanillaChronicleMap map) {
        boolean wasMapInit = this.mapInit();
        this.m = map;
        if (wasMapInit) {
            this.closeMapDependants();
        }
    }

    @Override
    public VanillaChronicleMap<K, V, R> m() {
        assert (this.mapInit()) : "Map should be init";
        return this.m;
    }

    public void closeMap() {
        if (!this.mapInit()) {
            return;
        }
        this.closeMapDependants();
        this.m = null;
    }

    public void closeMapDependants() {
        this.closeVanillaChronicleMapHolderImplMDependants();
        this.closeVanillaChronicleMapHolderImplHDependants();
    }

    public void closeVanillaChronicleMapHolderImplMDependants() {
        this.closeValueSize();
        this.wrappedValueInstanceDataHolder.closeValue();
        this.closeKeySearch();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)this.m().keySizeMarshaller.storingLength(keySize) + keySize + this.checksumStrategy.extraEntryBytes() + (long)this.m().valueSizeMarshaller.storingLength(valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation) {
            sizeOfEverythingBeforeValue += (long)this.m().worstAlignment;
        }
        int alignment = this.m().alignment;
        return VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, alignment) + VanillaChronicleMap.alignAddr(valueSize, alignment);
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public ChronicleSet<K> set() {
        return this.m().chronicleSet;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    public ChronicleHash<K, ?, ?, ?> hash() {
        return this.set() != null ? this.set() : this.map();
    }

    @Override
    public VanillaChronicleHash<K, ?, ?, ?> h() {
        return this.m();
    }

    public void closeVanillaChronicleMapHolderImplHDependants() {
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeHashLookupSearchHlDependants();
        this.closeSegmentHeader();
        this.closeLocks();
        this.closeSegmentTier();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeSegment();
        this.closeEntryOffset();
        this.closeEntrySizeInChunks();
        this.closeDelayedUpdateChecksum();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeHashLookupSearchNextPosDependants();
        this.closeKeySearch();
        this.closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
    }

    public void closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Update or Write " + "locking is forbidden in the context of locked iteration context");
        }
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    public void initSearchKey(long searchKey) {
        boolean wasSearchKeyInit = this.searchKeyInit();
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        if (wasSearchKeyInit) {
            this.closeSearchKeyDependants();
        }
    }

    public long searchKey() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchKey;
    }

    public long searchStartPos() {
        assert (this.searchKeyInit()) : "SearchKey should be init";
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        boolean wasSegmentHeaderInit = this.segmentHeaderInit();
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        if (wasSegmentHeaderInit) {
            this.closeSegmentHeaderDependants();
        }
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    private void resetSegmentLock(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long lockState = this.segmentHeader().getLockState(this.segmentHeaderAddress());
        if (lockState != this.segmentHeader().resetLockState()) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("lock of segment {} is not clear: {}", this.segmentIndex(), this.segmentHeader().lockStateToString(lockState)));
            this.segmentHeader().resetLock(this.segmentHeaderAddress());
        }
    }

    public boolean segmentTierInit() {
        return this.tier >= 0;
    }

    public void initSegmentTier() {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tierIndex = (long)this.segmentIndex() + 1L;
        this.tierBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.tier = 0;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public void initSegmentTier_WithBaseAddr(int tier, long tierBaseAddr, long tierIndex) {
        boolean wasSegmentTierInit = this.segmentTierInit();
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        if (wasSegmentTierInit) {
            this.closeSegmentTierDependants();
        }
    }

    public int tier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeKeyHash();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeHashLookupPos();
        this.closeHashLookupSearchAddrDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeSegment();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    private void shiftHashLookupEntries() {
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.tierBaseAddr();
        long hlPos = 0L;
        long steps = 0L;
        block0: do {
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            long searchKey = hl.key(hlEntry);
            long hlHolePos = hl.hlPos(searchKey);
            while (hlHolePos != hlPos) {
                long hlHoleEntry = hl.readEntry(hlAddr, hlHolePos);
                if (hl.empty(hlHoleEntry)) {
                    hl.writeEntry(hlAddr, hlHolePos, hlEntry);
                    if (hl.remove(hlAddr, hlPos) == hlPos) continue block0;
                    hlPos = hl.stepBack(hlPos);
                    --steps;
                    continue block0;
                }
                hlHolePos = hl.step(hlHolePos);
            }
        } while ((hlPos = hl.step(hlPos)) != 0L || ++steps == 0L);
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        boolean wasKeyHashInit = this.keyHashInit();
        long addr = this.tierBaseAddr() + this.keyOffset();
        long len = this.keySize();
        this.keyHash = LongHashFunction.xx_r39().hashMemory(addr, len);
        if (wasKeyHashInit) {
            this.closeKeyHashDependants();
        }
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.closeKeyHashDependants();
        this.keyHash = 0L;
    }

    public void closeKeyHashDependants() {
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public void closeIterationKeyHashCodeKeyHashCodeDependants() {
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr() + this.h().tierHashLookupOuterSize;
    }

    public void closeIterationSegmentStagesTierCountersAreaAddrDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTier() {
        if (this.tier() == 0) {
            throw new IllegalStateException(this.h().toIdentityString() + ": first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier() - 1, this.prevTierIndex());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void goToFirstTier() {
        while (this.tier() != 0) {
            this.prevTier();
        }
    }

    public long nextTierIndex() {
        if (this.tier() == 0) {
            return this.segmentHeader().nextTierIndex(this.segmentHeaderAddress());
        }
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void nextTierIndex(long nextTierIndex) {
        if (this.tier() == 0) {
            this.segmentHeader().nextTierIndex(this.segmentHeaderAddress(), nextTierIndex);
        } else {
            TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
        }
    }

    private void zeroOutFirstSegmentTierCountersArea(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long tierCountersAreaAddr;
        this.nextTierIndex(0L);
        if (this.prevTierIndex() != 0L) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("stored prev tier index in first tier of segment {}: {}, should be 0", this.segmentIndex(), this.prevTierIndex()));
            this.prevTierIndex(0L);
        }
        if (TierCountersArea.segmentIndex(tierCountersAreaAddr = this.tierCountersAreaAddr()) != 0) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("stored segment index in first tier of segment {}: {}, should be 0", this.segmentIndex(), TierCountersArea.segmentIndex(tierCountersAreaAddr)));
            TierCountersArea.segmentIndex(tierCountersAreaAddr, 0);
        }
        if (TierCountersArea.tier(tierCountersAreaAddr) != 0) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("stored tier in first tier of segment {}: {}, should be 0", this.segmentIndex(), TierCountersArea.tier(tierCountersAreaAddr)));
            TierCountersArea.tier(tierCountersAreaAddr, 0);
        }
    }

    public long tierEntries() {
        if (this.tier() == 0) {
            return this.segmentHeader().entries(this.segmentHeaderAddress());
        }
        return TierCountersArea.entries(this.tierCountersAreaAddr());
    }

    public long tierEntriesForIteration() {
        this.throwExceptionIfClosed();
        return this.tierEntries();
    }

    public void tierEntries(long tierEntries) {
        if (this.tier() == 0) {
            this.segmentHeader().entries(this.segmentHeaderAddress(), tierEntries);
        } else {
            TierCountersArea.entries(this.tierCountersAreaAddr(), tierEntries);
        }
    }

    public void closeIterationSegmentStagesTierEntriesDependants() {
        this.closeSegment();
    }

    public long tierDeleted() {
        if (this.tier() == 0) {
            return this.segmentHeader().deleted(this.segmentHeaderAddress());
        }
        return TierCountersArea.deleted(this.tierCountersAreaAddr());
    }

    public void tierDeleted(long tierDeleted) {
        if (this.tier() == 0) {
            this.segmentHeader().deleted(this.segmentHeaderAddress(), tierDeleted);
        } else {
            TierCountersArea.deleted(this.tierCountersAreaAddr(), tierDeleted);
        }
    }

    private void recoverTierEntriesCounter(long entries, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        if (this.tierEntries() != entries) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("Wrong number of entries counter for tier with index {}, stored: {}, should be: " + this.tierIndex(), this.tierEntries(), entries));
            this.tierEntries(entries);
        }
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeHashLookupSearchAddrDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long lowestPossiblyFreeChunk() {
        if (this.tier() == 0) {
            return this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress());
        }
        return TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr());
    }

    public void closeIterationSegmentStagesLowestPossiblyFreeChunkDependants() {
        this.closeSegment();
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if (this.tier() == 0) {
            this.segmentHeader().lowestPossiblyFreeChunk(this.segmentHeaderAddress(), lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(this.tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        boolean wasSegmentInit = this.segmentInit();
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.tierFreeListOuterSize + (long)h.tierEntrySpaceInnerOffset;
        if (wasSegmentInit) {
            this.closeSegmentDependants();
        }
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    public Bytes segmentBytes() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytes;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeySearch();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeEntryOffset();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        boolean wasValueSizeInit = this.valueSizeInit();
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(segmentBytes);
        this.valueOffset = segmentBytes.readPosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    void initValueSize(long valueSize) {
        boolean wasValueSizeInit = this.valueSizeInit();
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.addressForRead(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
        if (wasValueSizeInit) {
            this.closeValueSizeDependants();
        }
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    public long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
    }

    public void writeValue(Data<?> value) {
        this.initDelayedUpdateChecksum(true);
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    boolean keyEquals(long keySize, long keyOffset) {
        return this.inputKey().size() == keySize && this.inputKey().equivalent((RandomDataInput)this.segmentBS(), keyOffset);
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        boolean wasEntryOffsetInit = this.entryOffsetInit();
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        if (wasEntryOffsetInit) {
            this.closeEntryOffsetDependants();
        }
    }

    public void initEntryOffset(long keySizeOffset) {
        boolean wasEntryOffsetInit = this.entryOffsetInit();
        this.keySizeOffset = keySizeOffset;
        if (wasEntryOffsetInit) {
            this.closeEntryOffsetDependants();
        }
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeDelayedUpdateChecksum();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize());
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        this.entrySizeInChunks = 0;
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.freeExtraGuarded(this.pos(), this.allocatedChunks(), this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset();
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    private void recoverLowestPossibleFreeChunkTiered(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long lowestFreeChunk = this.freeList().nextClearBit(0L);
        if (lowestFreeChunk == -1L) {
            lowestFreeChunk = this.m().actualChunksPerSegmentTier;
        }
        if (this.lowestPossiblyFreeChunk() != lowestFreeChunk) {
            long finalLowestFreeChunk = lowestFreeChunk;
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> ChronicleHashCorruptionImpl.format("wrong lowest free chunk for tier with index {}, stored: {}, should be: {}", this.tierIndex(), this.lowestPossiblyFreeChunk(), finalLowestFreeChunk));
            this.lowestPossiblyFreeChunk(lowestFreeChunk);
        }
    }

    public void nextTier() {
        this._SegmentStages_nextTier();
        if (this.hashLookupEntryInit()) {
            this.initSearchKey(this.h().hashLookup.key(this.hashLookupEntry()));
        }
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    @Override
    public long size() {
        this.goToFirstTier();
        long size = this.tierEntries() - this.tierDeleted();
        while (this.hasNextTier()) {
            this.nextTier();
            size += this.tierEntries() - this.tierDeleted();
        }
        return size;
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCodeGuarded(chunks);
        if (prevPos >= 0L) {
            this.freeGuarded(prevPos, prevChunks);
        }
        if (ret >= 0L) {
            return ret;
        }
        do {
            this.nextTier();
        } while ((ret = this.allocReturnCodeGuarded(chunks)) < 0L);
        return ret;
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.tier() != tierBeforeAllocation;
    }

    public void verifyTierCountersAreaData() {
        block2: {
            long currentTierIndex;
            this.goToFirstTier();
            do {
                int tierSegmentIndex;
                if ((tierSegmentIndex = TierCountersArea.segmentIndex(this.tierCountersAreaAddr())) != this.segmentIndex()) {
                    throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports it belongs to segmentIndex " + tierSegmentIndex));
                }
                if (!this.hasNextTier()) break block2;
                currentTierIndex = this.tierIndex();
                this.nextTier();
            } while (this.prevTierIndex() == currentTierIndex);
            throw new AssertionError((Object)("segmentIndex: " + this.segmentIndex() + ", tier: " + this.tier() + ", tierIndex: " + this.tierIndex() + ", tierBaseAddr: " + this.tierBaseAddr() + " reports the previous tierIndex is " + this.prevTierIndex() + " while actually it is " + currentTierIndex));
        }
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException(this.h().toIdentityString() + ": Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachLockOperationDependants();
    }

    public void checkOnEachLockOperation() {
        this.checkAccessingFromOwnerThread();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachLockOperationDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkEntryNotRemovedOnThisIteration() {
        this.throwExceptionIfClosed();
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException(this.h().toIdentityString() + ": Entry was already removed on this iteration");
        }
    }

    public void closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceDataHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    public Data<V> wrapValueBytesAsData(BytesStore bytesStore, long offset, long size) {
        Objects.requireNonNull(bytesStore);
        this.checkOnEachPublicOperation();
        WrappedValueBytesData wrapped = this.wrappedValueBytesData;
        wrapped = wrapped.getUnusedWrappedValueBytesDataGuarded();
        wrapped.initWrappedValueBytesStore(bytesStore, offset, size);
        return wrapped;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    private int checkEntry(long searchKey, long entryPos, int segmentIndex, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        if (entryPos < 0L || entryPos >= h.actualChunksPerSegmentTier) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Entry pos is out of range: {}, should be 0-{}", entryPos, h.actualChunksPerSegmentTier - 1L));
            return -1;
        }
        try {
            this.readExistingEntry(entryPos);
        }
        catch (Exception e) {
            ChronicleHashCorruptionImpl.reportException(corruptionListener, corruption, segmentIndex, () -> "Exception while reading entry key size", e);
            return -1;
        }
        if (this.keyEnd() > this.segmentBytes().capacity()) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Wrong key size: " + this.keySize(), new Object[0]));
            return -1;
        }
        long keyHashCode = this.keyHashCode();
        int segmentIndexFromKey = h.hashSplitting.segmentIndex(keyHashCode);
        if (segmentIndexFromKey < 0 || segmentIndexFromKey >= h.actualSegments) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Segment index from the entry key hash code is out of range: {}, should be 0-{}, entry key: {}", segmentIndexFromKey, h.actualSegments - 1, this.key()));
            return -1;
        }
        long segmentHashFromKey = h.hashSplitting.segmentHash(keyHashCode);
        long searchKeyFromKey = h.hashLookup.maskUnsetKey(segmentHashFromKey);
        if (searchKey != searchKeyFromKey) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("HashLookup searchKey: {}, HashLookup searchKey from the entry key hash code: {}, entry key: {}, entry pos: {}", searchKey, searchKeyFromKey, this.key(), entryPos));
            return -1;
        }
        try {
            long entryAndChecksumEnd = this.entryEnd() + this.checksumStrategy.extraEntryBytes();
            if (entryAndChecksumEnd > this.segmentBytes().capacity()) {
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Wrong value size: {}, key: " + this.valueSize(), this.key()));
                return -1;
            }
        }
        catch (Exception ex) {
            ChronicleHashCorruptionImpl.reportException(corruptionListener, corruption, segmentIndex, () -> "Exception while reading entry value size, key: " + this.key(), ex);
            return -1;
        }
        int storedChecksum = this.checksumStrategy.storedChecksum();
        int checksumFromEntry = this.checksumStrategy.computeChecksum();
        if (storedChecksum != checksumFromEntry) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Checksum doesn't match, stored: {}, should be from the entry bytes: {}, key: {}, value: {}", storedChecksum, checksumFromEntry, this.key(), this.value()));
            return -1;
        }
        if (!this.freeList().isRangeClear(entryPos, entryPos + (long)this.entrySizeInChunks())) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Overlapping entry: positions {}-{}, key: {}, value: {}", entryPos, entryPos + (long)this.entrySizeInChunks() - 1L, this.key(), this.value()));
            return -1;
        }
        if (segmentIndex < 0) {
            return segmentIndexFromKey;
        }
        if (segmentIndex != segmentIndexFromKey) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Expected segment index: {}, segment index from the entry key: {}, key: {}, value: {}", segmentIndex, searchKeyFromKey, this.key(), this.value()));
            return -1;
        }
        return segmentIndex;
    }

    public void removeDuplicatesInSegment(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long startHlPos = 0L;
        VanillaChronicleMap<K, V, R> m = this.m();
        CompactOffHeapLinearHashTable hashLookup = m.hashLookup;
        long currentTierBaseAddr = this.tierBaseAddr();
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startHlPos))) {
            startHlPos = hashLookup.step(startHlPos);
        }
        long hlPos = startHlPos;
        int steps = 0;
        long entries = 0L;
        do {
            hlPos = hashLookup.step(hlPos);
            ++steps;
            long entry = hashLookup.readEntry(currentTierBaseAddr, hlPos);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            Data<K> key = this.key();
            try (ExternalHashQueryContext c = m.queryContext((Data)key);){
                HashEntry entry2 = c.entry();
                Data key2 = ((MapEntry)((Object)c)).key();
                long keyAddress = key.bytes().addressForRead(key.offset());
                long key2Address = key2.bytes().addressForRead(key2.offset());
                if (key2Address != keyAddress) {
                    ChronicleHashCorruptionImpl.report(corruptionListener, corruption, this.segmentIndex(), () -> this.lambda$removeDuplicatesInSegment$16(key, (ExternalMapQueryContext)c, (MapEntry)entry2));
                    if (hashLookup.remove(currentTierBaseAddr, hlPos) == hlPos) continue;
                    hlPos = hashLookup.stepBack(hlPos);
                    --steps;
                    continue;
                }
            }
            ++entries;
        } while (hlPos != startHlPos || steps == 0);
        this.recoverTierEntriesCounter(entries, corruptionListener, corruption);
        this.recoverLowestPossibleFreeChunkTiered(corruptionListener, corruption);
    }

    private void removeDuplicatesInSegments(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        block0: for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.initSegmentIndex(segmentIndex);
            this.initSegmentTier();
            this.goToLastTier();
            while (true) {
                this.removeDuplicatesInSegment(corruptionListener, corruption);
                if (this.tier() <= 0) continue block0;
                this.prevTier();
            }
        }
    }

    public int recoverTier(int segmentIndex, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        this.freeList().clearAll();
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        CompactOffHeapLinearHashTable hl = h.hashLookup;
        long hlAddr = this.tierBaseAddr();
        long validEntries = 0L;
        long hlPos = 0L;
        block0: do {
            long startInsertPos;
            long entryPos;
            long hlEntry;
            if (hl.empty(hlEntry = hl.readEntry(hlAddr, hlPos))) continue;
            hl.clearEntry(hlAddr, hlPos);
            if (validEntries >= h.maxEntriesPerHashLookup) {
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Too many entries in tier with index {}, max is {}", this.tierIndex(), h.maxEntriesPerHashLookup));
                continue;
            }
            long searchKey = hl.key(hlEntry);
            int si = this.checkEntry(searchKey, entryPos = hl.value(hlEntry), segmentIndex, corruptionListener, corruption);
            if (si < 0) continue;
            this.freeList().setRange(entryPos, entryPos + (long)this.entrySizeInChunks());
            segmentIndex = si;
            long insertPos = startInsertPos = hl.hlPos(searchKey);
            do {
                long hlInsertEntry;
                if (hl.empty(hlInsertEntry = hl.readEntry(hlAddr, insertPos))) {
                    hl.writeEntry(hlAddr, insertPos, hl.entry(searchKey, entryPos));
                    ++validEntries;
                    continue block0;
                }
                if (insertPos == hlPos) {
                    throw new ChronicleHashRecoveryFailedException("Concurrent modification of " + h.toIdentityString() + " while recovery procedure is in progress");
                }
                if (hl.key(hlInsertEntry) != searchKey) continue;
                long anotherEntryPos = hl.value(hlInsertEntry);
                if (anotherEntryPos == entryPos) {
                    ++validEntries;
                    continue block0;
                }
                long currentKeyOffset = this.keyOffset();
                long currentKeySize = this.keySize();
                int currentEntrySizeInChunks = this.entrySizeInChunks();
                if (insertPos >= 0L && insertPos < hlPos) {
                    this.readExistingEntry(anotherEntryPos);
                } else if (this.checkEntry(searchKey, anotherEntryPos, segmentIndex, corruptionListener, corruption) < 0) continue;
                if (this.keySize() != currentKeySize || !BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)currentKeyOffset, (RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (long)currentKeySize)) continue;
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("Entries with duplicate keys within a tier: at pos {} and {} with key {}, first value is {}", entryPos, anotherEntryPos, this.key(), this.value()));
                this.freeList().clearRange(entryPos, entryPos + (long)currentEntrySizeInChunks);
                continue block0;
            } while ((insertPos = hl.step(insertPos)) != startInsertPos);
            throw new ChronicleHashRecoveryFailedException("HashLookup overflow should never occur. It might also be concurrent access to " + h.toIdentityString() + " while recovery procedure is in progress");
        } while ((hlPos = hl.step(hlPos)) != 0L);
        this.shiftHashLookupEntries();
        return segmentIndex;
    }

    @Override
    public void recoverSegments(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long storedFirstFreeTierIndex;
        this.throwExceptionIfClosed();
        VanillaChronicleHash<K, ?, ?, ?> h = this.h();
        for (int segmentIndex = 0; segmentIndex < h.actualSegments; ++segmentIndex) {
            this.initSegmentIndex(segmentIndex);
            this.resetSegmentLock(corruptionListener, corruption);
            this.zeroOutFirstSegmentTierCountersArea(corruptionListener, corruption);
            this.recoverTier(segmentIndex, corruptionListener, corruption);
        }
        VanillaGlobalMutableState globalMutableState = h.globalMutableState();
        long storedExtraTiersInUse = globalMutableState.getExtraTiersInUse();
        long allocatedExtraTiers = (long)globalMutableState.getAllocatedExtraTierBulks() * h.tiersInBulk;
        long expectedExtraTiersInUse = Math.max(0L, Math.min(storedExtraTiersInUse, allocatedExtraTiers));
        long actualExtraTiersInUse = 0L;
        long firstFreeExtraTierIndex = -1L;
        for (long extraTierIndex = 0L; extraTierIndex < expectedExtraTiersInUse; ++extraTierIndex) {
            long tierCountersAreaAddr;
            long tierIndex = h.extraTierIndexToTierIndex(extraTierIndex);
            this.initSegmentTier(0, tierIndex);
            int segmentIndex = this.recoverTier(-1, corruptionListener, corruption);
            if (segmentIndex >= 0) {
                tierCountersAreaAddr = this.tierCountersAreaAddr();
                int storedSegmentIndex = TierCountersArea.segmentIndex(tierCountersAreaAddr);
                if (storedSegmentIndex != segmentIndex) {
                    ChronicleHashCorruptionImpl.report(corruptionListener, corruption, segmentIndex, () -> ChronicleHashCorruptionImpl.format("wrong segment index stored in tier counters area of tier with index {}: {}, should be, based on entries: {}", tierIndex, storedSegmentIndex, segmentIndex));
                    TierCountersArea.segmentIndex(tierCountersAreaAddr, segmentIndex);
                }
            } else {
                firstFreeExtraTierIndex = extraTierIndex;
                break;
            }
            TierCountersArea.nextTierIndex(tierCountersAreaAddr, 0L);
            this.initSegmentIndex(segmentIndex);
            this.goToLastTier();
            this.nextTierIndex(tierIndex);
            TierCountersArea.prevTierIndex(tierCountersAreaAddr, this.tierIndex());
            TierCountersArea.tier(tierCountersAreaAddr, this.tier() + 1);
            actualExtraTiersInUse = extraTierIndex + 1L;
        }
        if (storedExtraTiersInUse != actualExtraTiersInUse) {
            long finalActualExtraTiersInUse = actualExtraTiersInUse;
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("wrong number of actual tiers in use in global mutable state, stored: {}, should be: " + storedExtraTiersInUse, finalActualExtraTiersInUse));
            globalMutableState.setExtraTiersInUse(actualExtraTiersInUse);
        }
        long firstFreeTierIndex = firstFreeExtraTierIndex == -1L ? (allocatedExtraTiers > expectedExtraTiersInUse ? h.extraTierIndexToTierIndex(expectedExtraTiersInUse) : 0L) : h.extraTierIndexToTierIndex(firstFreeExtraTierIndex);
        if (firstFreeTierIndex > 0L) {
            long lastTierIndex = h.extraTierIndexToTierIndex(allocatedExtraTiers - 1L);
            h.linkAndZeroOutFreeTiers(firstFreeTierIndex, lastTierIndex);
        }
        if ((storedFirstFreeTierIndex = globalMutableState.getFirstFreeTierIndex()) != firstFreeTierIndex) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("wrong first free tier index in global mutable state, stored: {}, should be: " + storedFirstFreeTierIndex, firstFreeTierIndex));
            globalMutableState.setFirstFreeTierIndex(firstFreeTierIndex);
        }
        this.removeDuplicatesInSegments(corruptionListener, corruption);
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used, VanillaChronicleMap map) {
        boolean wasUsedInit = this.usedInit();
        assert (used);
        this.firstContextLockedInThisThread = this.rootContextInThisThread.lockContextLocally(map);
        this.initMap(map);
        this.used = true;
        if (wasUsedInit) {
            this.closeUsedDependants();
        }
    }

    public boolean used() {
        assert (this.usedInit()) : "Used should be init";
        return this.used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.closeUsedDependants();
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    public void closeUsedDependants() {
        this.closeLocks();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextLockedOnThisSegment != null;
    }

    void initLocks() {
        int i;
        boolean wasLocksInit = this.locksInit();
        assert (this.used());
        if (this.segmentHeader() == null) {
            throw new AssertionError();
        }
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        if (wasLocksInit) {
            this.closeLocksDependants();
        }
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextLockedOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeDelayedUpdateChecksum();
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        if (this.tier() < 0) {
            throw new AssertionError();
        }
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public void initHashLookupPos(long hashLookupPos) {
        boolean wasHashLookupPosInit = this.hashLookupPosInit();
        this.hashLookupPos = hashLookupPos;
        if (wasHashLookupPosInit) {
            this.closeHashLookupPosDependants();
        }
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            CompactOffHeapLinearHashTable hl = this.hl();
            do {
                if (hl.empty(entry = hl.readEntryVolatile(this.addr(), pos))) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                if ((pos = hl.step(pos)) == this.searchStartPos()) break block2;
            } while (hl.key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return hl.value(entry);
        }
        throw new IllegalStateException(this.h().toIdentityString() + ": HashLookup overflow should never occur");
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            long keySizeOffset = this.entrySpaceOffset() + pos * this.m().chunkSize;
            Bytes segmentBytes = this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(keySizeOffset);
            long keySize = this.h().keySizeMarshaller.readSize(segmentBytes);
            long keyOffset = segmentBytes.readPosition();
            if (!this.keyEquals(keySize, keyOffset)) continue;
            this.found();
            this.readFoundEntry(pos, keySizeOffset, keySize, keyOffset);
            this.searchState = SearchState.PRESENT;
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    public void closeKeySearch() {
        this.searchState = null;
    }

    public boolean searchStateAbsent() {
        return this.searchState() == SearchState.ABSENT;
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public void putNewVolatile(long entryPos) {
        boolean keySearchReInit;
        boolean bl = keySearchReInit = !this.keySearchInit();
        if (this.searchStatePresent()) {
            throw new AssertionError();
        }
        if (keySearchReInit) {
            this.readExistingEntry(entryPos);
        }
        this.hl().checkValueForPut(entryPos);
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), this.searchKey(), entryPos);
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment().totalWriteLockCount();
        return s;
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException(this.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.innerUpdateLock.lock();
        return this.delayedUpdateChecksumInit() || this.checksumStrategy.innerCheckSum();
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation();
        if (!this.h().checksumEntries) {
            throw new UnsupportedOperationException(this.h().toIdentityString() + ": Checksum is not stored in this Chronicle Hash");
        }
        this.innerUpdateLock.lock();
        this.initDelayedUpdateChecksum(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean forEachTierEntryWhile(Predicate<? super T> predicate, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        long leftEntries = this.tierEntriesForIteration();
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.initHashLookupPos(startPos);
        int steps = 0;
        do {
            currentHashLookupPos = hashLookup.step(this.hashLookupPos());
            ++steps;
            this.setHashLookupPosGuarded(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.readExistingEntry(hashLookup.value(entry));
            if (!this.shouldTestEntry()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!predicate.test(this.entryForIteration())) {
                    interrupted = true;
                    break;
                }
                if (--leftEntries != 0L) continue;
                break;
            }
            finally {
                this.hookAfterEachIteration();
                if (this.tier() != currentTier) {
                    this.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    --steps;
                    this.initHashLookupPos(currentHashLookupPos);
                }
                this.innerWriteLock.unlock();
                this.closeKeyOffset();
            }
        } while (currentHashLookupPos != startPos || steps == 0);
        if (!interrupted && leftEntries > 0L) {
            throw new IllegalStateException(this.h().toIdentityString() + ": We went through a tier without interruption, " + "but according to tier counters there should be " + leftEntries + " more entries. Size diverged?");
        }
        return interrupted;
    }

    public <T> boolean innerForEachSegmentEntryWhile(Predicate<? super T> predicate) {
        try {
            this.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                boolean interrupted;
                if (interrupted = this.forEachTierEntryWhile(predicate, currentTier = this.tier(), currentTierBaseAddr = this.tierBaseAddr(), currentTierIndex = this.tierIndex())) {
                    boolean bl = false;
                    return bl;
                }
                if (currentTier == 0) {
                    boolean bl = true;
                    return bl;
                }
                this.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.throwExceptionIfClosed();
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super MapEntry<K, V>> action) {
        this.throwExceptionIfClosed();
        this.forEachSegmentEntryWhile((Predicate<? super MapEntry<K, V>>)((Predicate<MapEntry>)e -> {
            action.accept((Object)e);
            return true;
        }));
    }

    protected void relocation(Data<V> newValue, long newEntrySize) {
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(newEntrySize, this.valueSizeOffset() - this.keySizeOffset(), this.pos(), this.entrySizeInChunks());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long hashLookupKey = hl.key(hl.readEntry(oldHashLookupAddr, oldHashLookupPos));
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), hashLookupKey, this.pos());
        this.innerWriteLock.lock();
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, V, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.m().alignment)));
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException(m.toIdentityString() + ": Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.reallocGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks)) {
                    this.relocation(newValue, newEntrySize);
                    return;
                }
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeExtraGuarded(this.pos(), this.entrySizeInChunks(), newSizeInChunks);
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.throwExceptionIfClosed();
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        }
        finally {
            this.innerWriteLock.unlock();
        }
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.freeGuarded(this.pos(), this.entrySizeInChunks());
        this.incrementModCountGuarded();
    }

    public void iterationRemove() {
        this.throwExceptionIfClosed();
        if (this.h().hashLookup.remove(this.tierBaseAddr(), this.hashLookupPos()) != this.hashLookupPos()) {
            this.setHashLookupPosGuarded(this.h().hashLookup.stepBack(this.hashLookupPos()));
        }
        this.innerRemoveEntryExceptHashLookupUpdate();
    }

    @Override
    public void doRemove() {
        this.throwExceptionIfClosed();
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    boolean delayedUpdateChecksumInit() {
        return this.delayedUpdateChecksum;
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (this.entryOffsetInit() && this.keySizeOffset() >= 0L);
        assert (this.locksInit() && this.localLockState() != LocalLockState.UNLOCKED);
        assert (delayedUpdateChecksum);
        this.delayedUpdateChecksum = true;
    }

    public void closeDelayedUpdateChecksum() {
        if (!this.delayedUpdateChecksumInit()) {
            return;
        }
        if (this.h().checksumEntries) {
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        }
        this.delayedUpdateChecksum = false;
    }

    private /* synthetic */ String lambda$removeDuplicatesInSegment$16(Data key, ExternalMapQueryContext c, MapEntry entry2) {
        return ChronicleHashCorruptionImpl.format("entries with duplicate key {} in segment {}: with values {} and {}, removing the latter", key, c.segmentIndex(), entry2 != null ? ((MapEntry)((Object)c)).value() : "<deleted>", !this.entryDeleted() ? this.value() : "<deleted>");
    }

    public static enum SearchState {
        PRESENT,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": Cannot acquire write lock, because outer context holds read lock. " + "In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapIterationContext.this.localLockState()));
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapIterationContext.this.localLockState()));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            try {
                                CompiledMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                            }
                            catch (InterProcessDeadLockException e) {
                                throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                            }
                        }
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        try {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapIterationContext.this.decrementWriteGuarded() == 0) {
                        CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                }
            }
        }

        @Override
        public void lock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            try {
                                CompiledMapIterationContext.this.segmentHeader().writeLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                            }
                            catch (InterProcessDeadLockException e) {
                                throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                            }
                        }
                    }
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapIterationContext.this.updateZeroGuarded());
                        try {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            return CompiledMapIterationContext.this.localLockState().write;
        }
    }

    public class WrappedValueInstanceDataHolder {
        private final DataAccess<V> wrappedValueDataAccess;
        private WrappedValueInstanceDataHolder next;
        private V value;
        public Data<V> wrappedData = null;

        public void doCloseValue() {
            if (!this.valueInit()) {
                return;
            }
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void doCloseNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public void doCloseWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = (DataAccess)CompiledMapIterationContext.this.m().valueDataAccess.copy();
        }

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceDataHolder();
            }
            return this.next.getUnusedWrappedValueHolder();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueInstanceDataHolder next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeValue();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            boolean wasValueInit = this.valueInit();
            CompiledMapIterationContext.this.m().checkValue(value);
            this.value = value;
            if (wasValueInit) {
                this.closeValueDependants();
            }
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next() != null) {
                this.next().closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public boolean wrappedDataInit() {
            return this.wrappedData != null;
        }

        private void initWrappedData() {
            this.wrappedData = this.wrappedValueDataAccess.getData(this.value());
        }

        public Data<V> wrappedData() {
            if (!this.wrappedDataInit()) {
                this.initWrappedData();
            }
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }
    }

    public class WrappedValueBytesData
    extends AbstractData<V> {
        private final VanillaBytes wrappedValueBytes = new VanillaBytes((BytesStore)NoBytesStore.NO_BYTES_STORE);
        private WrappedValueBytesData next;
        private long wrappedValueBytesOffset;
        private long wrappedValueBytesSize;
        private BytesStore wrappedValueBytesStore;
        private boolean wrappedValueBytesUsed = false;
        private V cachedWrappedValue;
        private boolean cachedWrappedValueRead = false;

        public void doCloseCachedWrappedValue() {
            this.cachedWrappedValueRead = false;
        }

        public void doCloseNext() {
            if (!this.nextInit()) {
                return;
            }
        }

        public void doCloseWrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                return;
            }
            this.wrappedValueBytes.bytesStore((BytesStore)NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.wrappedValueBytesUsed = false;
        }

        public void doCloseWrappedValueBytesStore() {
            if (!this.wrappedValueBytesStoreInit()) {
                return;
            }
            this.wrappedValueBytesStore = null;
            if (this.next != null) {
                this.next.closeWrappedValueBytesStore();
            }
        }

        public WrappedValueBytesData getUnusedWrappedValueBytesDataGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueBytesData();
        }

        public WrappedValueBytesData getUnusedWrappedValueBytesData() {
            if (!this.wrappedValueBytesStoreInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueBytesData();
            }
            return this.next.getUnusedWrappedValueBytesData();
        }

        boolean nextInit() {
            return true;
        }

        public WrappedValueBytesData next() {
            assert (this.nextInit()) : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeWrappedValueBytesStore();
        }

        boolean wrappedValueBytesStoreInit() {
            return this.wrappedValueBytesStore != null;
        }

        public void initWrappedValueBytesStore(BytesStore bytesStore, long offset, long size) {
            boolean wasWrappedValueBytesStoreInit = this.wrappedValueBytesStoreInit();
            this.wrappedValueBytesStore = bytesStore;
            this.wrappedValueBytesOffset = offset;
            this.wrappedValueBytesSize = size;
            if (wasWrappedValueBytesStoreInit) {
                this.closeWrappedValueBytesStoreDependants();
            }
        }

        public long wrappedValueBytesSize() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesSize;
        }

        public long wrappedValueBytesOffset() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesOffset;
        }

        public BytesStore wrappedValueBytesStore() {
            assert (this.wrappedValueBytesStoreInit()) : "WrappedValueBytesStore should be init";
            return this.wrappedValueBytesStore;
        }

        void closeWrappedValueBytesStore() {
            if (!this.wrappedValueBytesStoreInit()) {
                return;
            }
            this.closeWrappedValueBytesStoreDependants();
            this.wrappedValueBytesStore = null;
            if (this.next() != null) {
                this.next().closeWrappedValueBytesStore();
            }
        }

        public void closeWrappedValueBytesStoreDependants() {
            this.closeWrappedValueBytes();
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        boolean wrappedValueBytesInit() {
            return this.wrappedValueBytesUsed;
        }

        void initWrappedValueBytes() {
            boolean wasWrappedValueBytesInit = this.wrappedValueBytesInit();
            this.wrappedValueBytes.bytesStore(this.wrappedValueBytesStore(), this.wrappedValueBytesOffset(), this.wrappedValueBytesSize());
            this.wrappedValueBytesUsed = true;
            if (wasWrappedValueBytesInit) {
                this.closeWrappedValueBytesDependants();
            }
        }

        public VanillaBytes wrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                this.initWrappedValueBytes();
            }
            return this.wrappedValueBytes;
        }

        void closeWrappedValueBytes() {
            if (!this.wrappedValueBytesInit()) {
                return;
            }
            this.closeWrappedValueBytesDependants();
            this.wrappedValueBytes.bytesStore((BytesStore)NoBytesStore.NO_BYTES_STORE, 0L, 0L);
            this.wrappedValueBytesUsed = false;
        }

        public void closeWrappedValueBytesDependants() {
            this.closeWrappedValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            this.wrappedValueBytes().readPosition(this.wrappedValueBytesOffset());
            return CompiledMapIterationContext.this.valueReader.read((Bytes)this.wrappedValueBytes(), this.wrappedValueBytesSize(), usingValue);
        }

        public void closeWrappedValueBytesDataInnerGetUsingDependants() {
            this.closeCachedWrappedValue();
        }

        public boolean cachedWrappedValueInit() {
            return this.cachedWrappedValueRead;
        }

        private void initCachedWrappedValue() {
            this.cachedWrappedValue = this.innerGetUsing(this.cachedWrappedValue);
            this.cachedWrappedValueRead = true;
        }

        public V cachedWrappedValue() {
            if (!this.cachedWrappedValueInit()) {
                this.initCachedWrappedValue();
            }
            return this.cachedWrappedValue;
        }

        public void closeCachedWrappedValue() {
            this.cachedWrappedValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedWrappedValue();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesSize();
        }

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytesOffset();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.wrappedValueBytes().bytesStore();
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": Cannot acquire update lock, because outer context holds read lock. " + "In this case you should acquire update lock in the outer context up front");
        }

        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": Cannot upgrade from read to update lock");
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            return CompiledMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapIterationContext.this.decrementUpdateGuarded() != 0 || !CompiledMapIterationContext.this.writeZeroGuarded()) break;
                    CompiledMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    break;
                }
                case WRITE_LOCKED: {
                    CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
                    if (CompiledMapIterationContext.this.decrementWriteGuarded() != 0) break;
                    if (!CompiledMapIterationContext.this.updateZeroGuarded()) {
                        CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        break;
                    }
                    CompiledMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                }
            }
            CompiledMapIterationContext.this.incrementReadGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapIterationContext.this.segmentHeader().updateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                        catch (InterProcessDeadLockException e) {
                            throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                        }
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public boolean tryLock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapIterationContext.this.localLockState()));
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!CompiledMapIterationContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new IllegalStateException(CompiledMapIterationContext.this.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)CompiledMapIterationContext.this.localLockState()));
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.readZeroGuarded() && CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                    try {
                        CompiledMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    catch (InterProcessDeadLockException e) {
                        throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                    }
                }
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapIterationContext.this.readZeroGuarded() && CompiledMapIterationContext.this.updateZeroGuarded() && CompiledMapIterationContext.this.writeZeroGuarded()) {
                    try {
                        CompiledMapIterationContext.this.segmentHeader().readLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    }
                    catch (InterProcessDeadLockException e) {
                        throw CompiledMapIterationContext.this.debugContextsAndLocksGuarded(e);
                    }
                }
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapIterationContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            return CompiledMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledMapIterationContext.this.localLockState() != LocalLockState.UNLOCKED) {
                CompiledMapIterationContext.this.closeHashLookupPos();
                CompiledMapIterationContext.this.closeEntry();
            }
            CompiledMapIterationContext.this.readUnlockAndDecrementCountGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
        }

        @Override
        public boolean tryLock() {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapIterationContext.this.readZeroGuarded() || !CompiledMapIterationContext.this.updateZeroGuarded() || !CompiledMapIterationContext.this.writeZeroGuarded() || CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            CompiledMapIterationContext.this.checkOnEachLockOperation();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (CompiledMapIterationContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapIterationContext.this.readZeroGuarded() || !CompiledMapIterationContext.this.updateZeroGuarded() || !CompiledMapIterationContext.this.writeZeroGuarded() || CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class HashEntryChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        @Override
        public int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledMapIterationContext.this.keyHashCode();
            long keyEnd = CompiledMapIterationContext.this.keyEnd();
            long len = CompiledMapIterationContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledMapIterationContext.this.tierBaseAddr() + keyEnd;
                long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapIterationContext.this.keySize(), keyHashCode, payloadChecksum);
            } else {
                checksum = keyHashCode;
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        public void closeHashEntryChecksumStrategyComputeChecksumDependants() {
            this.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        }

        @Override
        public void computeAndStoreChecksum() {
            int checksum = this.computeChecksum();
            CompiledMapIterationContext.this.segmentBS().writeInt(CompiledMapIterationContext.this.entryEnd(), checksum);
        }

        public void closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants() {
            CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
        }

        @Override
        public int storedChecksum() {
            return CompiledMapIterationContext.this.segmentBS().readInt(CompiledMapIterationContext.this.entryEnd());
        }

        @Override
        public boolean innerCheckSum() {
            int checksum;
            int oldChecksum = this.storedChecksum();
            return oldChecksum == (checksum = this.computeChecksum());
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead;

        public EntryValueBytesData() {
            this.cachedEntryValue = CompiledMapIterationContext.this.m().valueType() == CharSequence.class ? new StringBuilder() : null;
            this.cachedEntryValueRead = false;
        }

        public void doCloseCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledMapIterationContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledMapIterationContext.this.valueOffset());
            return CompiledMapIterationContext.this.valueReader.read(segmentBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        public void doCloseCachedEntryKey() {
            this.cachedEntryKeyRead = false;
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }

        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keyOffset();
        }

        @Override
        public long hash(LongHashFunction f) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return super.hash(f);
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledMapIterationContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledMapIterationContext.this.keyOffset());
            return CompiledMapIterationContext.this.keyReader.read(bytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }
    }
}

