/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.algo.XxHash;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableDataAccess;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableReader;
import net.openhft.chronicle.hash.serialization.impl.StringSizedReader;
import net.openhft.chronicle.hash.serialization.impl.StringUtf8DataAccess;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.wire.TextWire;

public final class InternalMapFileAnalyzer {
    public static void main(String[] args) throws IOException {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{StringSizedReader.class, StringUtf8DataAccess.class, BytesMarshallableReader.class, BytesMarshallableDataAccess.class});
        if (args.length < 1) {
            System.out.println("Usage: MapFileAnalyzer filename");
            return;
        }
        Path path = Paths.get(args[0], new String[0]);
        System.out.println("Analyzing " + path.toAbsolutePath());
        System.out.println("Warning, this program is not capable of analyzing all map file types.");
        if (path.toFile().length() > 0x80000000L) {
            System.out.println("This program can only handle files that are smaller than 2^31 bytes)");
            return;
        }
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(path, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            int segment;
            MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            InternalMapFileAnalyzer.header("Self bootstrapping header");
            long hashCode = buffer.getLong();
            int len = buffer.getInt();
            byte[] headerData = new byte[len];
            buffer.get(headerData);
            String header = new String(headerData, StandardCharsets.UTF_8);
            VanillaBytes bytes = Bytes.allocateDirect((long)(4 + len));
            bytes.writeInt(len);
            bytes.write(headerData);
            long expectedHashCode = new XxHash(0L).applyAsLong(bytes.bytesStore());
            InternalMapFileAnalyzer.output(0L, "hashcode (" + (hashCode == expectedHashCode ? "CORRECT" : "INCORRECT!") + ")", hashCode);
            InternalMapFileAnalyzer.output(8L, "length", len);
            InternalMapFileAnalyzer.output(12L, len, "header", header);
            VanillaChronicleMap map = (VanillaChronicleMap)TextWire.from((String)header).objectInput().readObject();
            Map<String, Object> props = InternalMapFileAnalyzer.parseProperties(map);
            InternalMapFileAnalyzer.align(buffer, 64);
            buffer.position(buffer.position() + 16);
            InternalMapFileAnalyzer.header("Global Mutable State");
            InternalMapFileAnalyzer.output64(buffer, "lock");
            InternalMapFileAnalyzer.output24u(buffer, "allocatedExtraTierBulks");
            InternalMapFileAnalyzer.output40u(buffer, "firstFreeTierIndex");
            InternalMapFileAnalyzer.output40u(buffer, "extraTiersInUse");
            int segmentHeadersOffset = Math.toIntExact(InternalMapFileAnalyzer.output32u(buffer, "segmentHeadersOffset"));
            InternalMapFileAnalyzer.output64(buffer, "dataStoreSize");
            InternalMapFileAnalyzer.output64(buffer, "currentCleanupSegmentIndex(r)");
            InternalMapFileAnalyzer.output8(buffer, "modificationIteratorsCount(r)");
            InternalMapFileAnalyzer.align(buffer, 2);
            InternalMapFileAnalyzer.output64(buffer, "modificationIteratorInitAt(r)0");
            InternalMapFileAnalyzer.output64(buffer, "modificationIteratorInitAt(r)1");
            InternalMapFileAnalyzer.header("Segment Headers Area");
            segmentHeadersOffset = 6033408;
            buffer.position(segmentHeadersOffset);
            int actualSegments = (Integer)props.get("actualSegments");
            System.out.println("actualSegments = " + actualSegments);
            int segmentHeaderSize = (Integer)props.get("segmentHeaderSize");
            System.out.println("segmentHeaderSize = " + segmentHeaderSize);
            for (int segment2 = 0; segment2 < actualSegments; ++segment2) {
                buffer.position(segmentHeadersOffset + segment2 * segmentHeaderSize);
                if (segment2 != 0) {
                    System.out.println();
                }
                InternalMapFileAnalyzer.output64(buffer, "lock " + segment2);
                InternalMapFileAnalyzer.output32u(buffer, "entries");
                InternalMapFileAnalyzer.output32u(buffer, "smallestIndexPossiblyFree");
                InternalMapFileAnalyzer.output64(buffer, "nextSegmentTier");
                InternalMapFileAnalyzer.output64(buffer, "deletedOffset");
            }
            InternalMapFileAnalyzer.header("Main Segments Area");
            InternalMapFileAnalyzer.align(buffer, 256);
            int mainSegmentAreaStart = buffer.position();
            long tierSize = (Long)props.get("tierSize");
            System.out.println("tierSize = " + tierSize);
            long tierHashLookupCapacity = (Long)props.get("tierHashLookupCapacity");
            System.out.println("tierHashLookupCapacity = " + tierHashLookupCapacity);
            int tierHashLookupSlotSize = (Integer)props.get("tierHashLookupSlotSize");
            System.out.println("tierHashLookupSlotSize = " + tierHashLookupSlotSize);
            int tierHashLookupKeyBits = (Integer)props.get("tierHashLookupKeyBits");
            System.out.println("tierHashLookupKeyBits = " + tierHashLookupKeyBits);
            long tierHashLookupOuterSize = (Long)props.get("tierHashLookupOuterSize");
            System.out.println("tierHashLookupOuterSize = " + tierHashLookupOuterSize);
            int actualChunksPerSegmentTier = Math.toIntExact((Long)props.get("actualChunksPerSegmentTier"));
            System.out.println("actualChunksPerSegmentTier = " + actualChunksPerSegmentTier);
            int tierFreeListOuterSize = Math.toIntExact((Long)props.get("tierFreeListOuterSize"));
            System.out.println("tierFreeListOuterSize = " + tierFreeListOuterSize);
            int tierEntrySpaceInnerOffset = (Integer)props.get("tierEntrySpaceInnerOffset");
            System.out.println("tierEntrySpaceInnerOffset = " + tierEntrySpaceInnerOffset);
            int chunkSize = Math.toIntExact((Long)props.get("chunkSize"));
            System.out.println("chunkSize = " + chunkSize);
            ArrayList<Integer> cardinalities = new ArrayList<Integer>();
            long oldPos = buffer.position();
            for (segment = 0; segment < actualSegments; ++segment) {
                InternalMapFileAnalyzer.header("Segment Tier Structure " + segment);
                buffer.position((int)(oldPos + (long)segment * tierSize));
                InternalMapFileAnalyzer.header("Hash Lookup " + segment);
                int entrySpacePos = (int)(oldPos + (long)segment * tierSize + tierHashLookupOuterSize + 64L + (long)tierFreeListOuterSize + (long)tierEntrySpaceInnerOffset);
                int usedSlots = 0;
                int hl = 0;
                while ((long)hl < tierHashLookupCapacity) {
                    int pos = buffer.position();
                    long hlv = InternalMapFileAnalyzer.unsignedValue(buffer, tierHashLookupSlotSize);
                    if (hlv != 0L) {
                        ++usedSlots;
                        long hashLookupKey = hlv & (1L << tierHashLookupKeyBits) - 1L;
                        long hashLookupValue = hlv >> tierHashLookupKeyBits;
                        int chunkAddress = (int)((long)entrySpacePos + hashLookupValue * (long)chunkSize);
                        byte keySize = buffer.get(chunkAddress);
                        String keyText = keySize > 0 ? InternalMapFileAnalyzer.read8Bit(buffer, chunkAddress + 1, keySize) : "";
                        System.out.format("%08X - %08X  %010X %010X %010X -> %08X %s %n", pos, pos + tierHashLookupSlotSize - 1, hl, hashLookupKey, hashLookupValue, chunkAddress, keyText);
                    } else {
                        System.out.format("%08X - %08X  %010X%n", pos, pos + tierHashLookupSlotSize - 1, hl);
                    }
                    ++hl;
                }
                cardinalities.add(usedSlots);
                System.out.format("%d cardinality (%.2f%% used)) %n", usedSlots, 100.0 * (double)usedSlots / (double)actualChunksPerSegmentTier);
                InternalMapFileAnalyzer.header("Segment Tier Counters Area " + segment);
                buffer.position((int)(oldPos + (long)segment * tierSize + tierHashLookupOuterSize));
                InternalMapFileAnalyzer.output64(buffer, "nextTierIndex(x)");
                InternalMapFileAnalyzer.output64(buffer, "previousTierIndex(x)");
                InternalMapFileAnalyzer.output64(buffer, "lowestPossiblyFreeChunk(x)");
                InternalMapFileAnalyzer.output32u(buffer, "segmentIndex(x)");
                InternalMapFileAnalyzer.output32u(buffer, "tier(x)");
                InternalMapFileAnalyzer.output32u(buffer, "entries(x)");
                InternalMapFileAnalyzer.output32u(buffer, "deleted(x)");
                InternalMapFileAnalyzer.header("Free List " + segment);
                int freeListPos = (int)(oldPos + (long)segment * tierSize + tierHashLookupOuterSize + 64L);
                buffer.position(freeListPos);
                byte[] bits = new byte[actualChunksPerSegmentTier / 8];
                buffer.get(bits);
                int cardinality = InternalMapFileAnalyzer.cardinality(bits);
                System.out.format("%08X - %08X  BITMAP (%d bytes, %d bits, %d cardinality (%.2f%% used)) %n", freeListPos, freeListPos + bits.length - 1, bits.length, actualChunksPerSegmentTier, cardinality, 100.0 * (double)cardinality / (double)actualChunksPerSegmentTier);
                InternalMapFileAnalyzer.header("Entry Space " + segment);
                buffer.position(entrySpacePos);
                int chunksBytes = actualChunksPerSegmentTier * chunkSize;
                System.out.format("%08X - %08X  CHUNKS (%d bytes)%n", entrySpacePos, entrySpacePos + chunksBytes, chunksBytes);
            }
            InternalMapFileAnalyzer.header("Allocation overview");
            for (segment = 0; segment < cardinalities.size(); ++segment) {
                int cardinality = (Integer)cardinalities.get(segment);
                System.out.format("%3d %10d (%2.2f%%)%n", segment, cardinality, 100.0 * (double)cardinality / (double)actualChunksPerSegmentTier);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String read8Bit(ByteBuffer buffer, int address, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            byte b = buffer.get(address + i);
            if (b > 32 && b < 126) {
                sb.append((char)b);
                continue;
            }
            sb.append(".");
        }
        return sb.toString();
    }

    private static Map<String, Object> parseProperties(Object map) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        for (Field field : InternalMapFileAnalyzer.fields(map.getClass())) {
            try {
                Object value = field.get(map);
                if (value == null) continue;
                props.put(field.getName(), field.get(map));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return props;
    }

    private static boolean showType(Class<?> type) {
        return Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || type.isPrimitive();
    }

    private static Set<Field> fields(Class<?> type) {
        return InternalMapFileAnalyzer.fields0(new LinkedHashSet<Field>(), type);
    }

    private static Set<Field> fields0(Set<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (!type.getSuperclass().equals(Object.class)) {
            InternalMapFileAnalyzer.fields0(fields, type.getSuperclass());
        }
        return fields;
    }

    static void header(String tag) {
        System.out.format("%n*** %s ***%n", tag);
    }

    static int output8(ByteBuffer buffer, String tag) {
        long pos = buffer.position();
        byte val = buffer.get();
        InternalMapFileAnalyzer.output(pos, tag, val);
        return val;
    }

    static int output24u(ByteBuffer buffer, String tag) {
        long pos = buffer.position();
        long val = InternalMapFileAnalyzer.unsignedValue(buffer, 3);
        InternalMapFileAnalyzer.output24u(pos, tag, val);
        return (int)val;
    }

    static long output32u(ByteBuffer buffer, String tag) {
        long pos = buffer.position();
        long val = InternalMapFileAnalyzer.unsignedValue(buffer, 4);
        InternalMapFileAnalyzer.output32u(pos, tag, val);
        return val;
    }

    static long output40u(ByteBuffer buffer, String tag) {
        long pos = buffer.position();
        long val = InternalMapFileAnalyzer.unsignedValue(buffer, 5);
        InternalMapFileAnalyzer.output40u(pos, tag, val);
        return val;
    }

    static long output64(ByteBuffer buffer, String tag) {
        long pos = buffer.position();
        long val = buffer.getLong();
        InternalMapFileAnalyzer.output(pos, tag, val);
        return val;
    }

    static void output(long addr, String tag, long out) {
        System.out.format("%08X - %08X  %-30s: 0x%016X (%d)%n", addr, addr + 8L - 1L, tag, out, out);
    }

    static void output24u(long addr, String tag, long out) {
        System.out.format("%08X - %08X  %-30s: 0x%06X           (%d)%n", addr, addr + 3L - 1L, tag, out, out);
    }

    static void output32u(long addr, String tag, long out) {
        System.out.format("%08X - %08X  %-30s: 0x%08X         (%d)%n", addr, addr + 4L - 1L, tag, out, out);
    }

    static void output40u(long addr, String tag, long out) {
        System.out.format("%08X - %08X  %-30s: 0x%010X       (%d)%n", addr, addr + 5L - 1L, tag, out, out);
    }

    static void output(long addr, String tag, int out) {
        System.out.format("%08X - %08X  %-30s: 0x%08X         (%d)%n", addr, addr + 4L - 1L, tag, out, out);
    }

    static void output(long addr, String tag, byte out) {
        System.out.format("%08X - %08X  %-30s: 0x%02X               (%d)%n", addr, addr, tag, out, out);
    }

    static void output(long addr, int length, String tag, Object out) {
        System.out.format("%08X - %08X  %-30s: %s%n", addr, addr + (long)length - 1L, tag, out.toString());
    }

    static void align(ByteBuffer buffer, int boundary) {
        if (buffer.position() % boundary == 0) {
            return;
        }
        int alignmentLength = boundary - buffer.position() % boundary;
        byte[] alignment = new byte[alignmentLength];
        buffer.get(alignment);
        String text = Arrays.toString(alignment) + " (" + alignmentLength + " bytes)";
        InternalMapFileAnalyzer.output(buffer.position() - alignmentLength, alignmentLength, "[alignmentBytes]", text);
    }

    static long unsignedValue(ByteBuffer buffer, int bytes) {
        long val = 0L;
        int shifts = 0;
        for (int i = 0; i < bytes; ++i) {
            long b = Byte.toUnsignedLong(buffer.get());
            long term = b << shifts;
            val |= term;
            shifts += 8;
        }
        return val;
    }

    static int cardinality(byte[] bits) {
        int cnt = 0;
        for (int i = 0; i < bits.length; ++i) {
            cnt += Integer.bitCount(Byte.toUnsignedInt(bits[i]));
        }
        return cnt;
    }
}

