/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.iter;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.iter.IterationSegmentStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashSegmentIteration<K, E extends HashEntry<K>>
implements HashEntry<K>,
HashSegmentContext<K, E> {
    @StageRef
    public IterationSegmentStages s;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    public boolean entryRemovedOnThisIteration = false;
    public long hashLookupEntry = 0L;
    @StageRef
    protected HashLookupPos hlp;
    @StageRef
    HashEntryStages<K> e;
    @StageRef
    VanillaChronicleHashHolder<?> hh;

    public boolean shouldTestEntry() {
        return true;
    }

    public Object entryForIteration() {
        return this;
    }

    public long tierEntriesForIteration() {
        this.throwExceptionIfClosed();
        return this.s.tierEntries();
    }

    abstract boolean entryRemovedOnThisIterationInit();

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public abstract boolean hashLookupEntryInit();

    public void initHashLookupEntry(long entry) {
        this.throwExceptionIfClosed();
        this.hashLookupEntry = entry;
    }

    abstract void closeHashLookupEntry();

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super E> predicate) {
        this.throwExceptionIfClosed();
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerUpdateLock.lock();
        return this.innerForEachSegmentEntryWhile(predicate);
    }

    public <T> boolean innerForEachSegmentEntryWhile(Predicate<? super T> predicate) {
        try {
            this.s.goToLastTier();
            while (true) {
                long currentTierIndex;
                long currentTierBaseAddr;
                int currentTier;
                boolean interrupted;
                if (interrupted = this.forEachTierEntryWhile(predicate, currentTier = this.s.tier, currentTierBaseAddr = this.s.tierBaseAddr, currentTierIndex = this.s.tierIndex)) {
                    boolean bl = false;
                    return bl;
                }
                if (currentTier == 0) {
                    boolean bl = true;
                    return bl;
                }
                this.s.prevTier();
            }
        }
        finally {
            this.closeHashLookupEntry();
            this.s.innerReadLock.unlock();
            this.initEntryRemovedOnThisIteration(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean forEachTierEntryWhile(Predicate<? super T> predicate, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long currentHashLookupPos;
        long leftEntries = this.tierEntriesForIteration();
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.hh.h().hashLookup;
        while (!hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos))) {
            startPos = hashLookup.step(startPos);
        }
        this.hlp.initHashLookupPos(startPos);
        int steps = 0;
        do {
            currentHashLookupPos = hashLookup.step(this.hlp.hashLookupPos);
            ++steps;
            this.hlp.setHashLookupPos(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            this.initHashLookupEntry(entry);
            if (hashLookup.empty(entry)) continue;
            this.e.readExistingEntry(hashLookup.value(entry));
            if (!this.shouldTestEntry()) continue;
            this.initEntryRemovedOnThisIteration(false);
            try {
                if (!predicate.test(this.entryForIteration())) {
                    interrupted = true;
                    break;
                }
                if (--leftEntries != 0L) continue;
                break;
            }
            finally {
                this.hookAfterEachIteration();
                if (this.s.tier != currentTier) {
                    this.s.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                    currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                    --steps;
                    this.hlp.initHashLookupPos(currentHashLookupPos);
                }
                this.s.innerWriteLock.unlock();
                this.e.closeKeyOffset();
            }
        } while (currentHashLookupPos != startPos || steps == 0);
        if (!interrupted && leftEntries > 0L) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": We a tier without interruption, but according to tier counters there should be " + leftEntries + " more entries. Size diverged?");
        }
        return interrupted;
    }

    public void hookAfterEachIteration() {
        this.throwExceptionIfClosed();
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super E> action) {
        this.throwExceptionIfClosed();
        this.forEachSegmentEntryWhile(e -> {
            action.accept((Object)e);
            return true;
        });
    }

    public void checkEntryNotRemovedOnThisIteration() {
        this.throwExceptionIfClosed();
        if (this.entryRemovedOnThisIterationInit()) {
            throw new IllegalStateException(this.hh.h().toIdentityString() + ": Entry was already removed on this iteration");
        }
    }

    @Override
    public void doRemove() {
        this.throwExceptionIfClosed();
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerWriteLock.lock();
        try {
            this.iterationRemove();
        }
        finally {
            this.s.innerWriteLock.unlock();
        }
        this.initEntryRemovedOnThisIteration(true);
    }

    public void iterationRemove() {
        this.throwExceptionIfClosed();
        if (this.hh.h().hashLookup.remove(this.s.tierBaseAddr, this.hlp.hashLookupPos) != this.hlp.hashLookupPos) {
            this.hlp.setHashLookupPos(this.hh.h().hashLookup.stepBack(this.hlp.hashLookupPos));
        }
        this.e.innerRemoveEntryExceptHashLookupUpdate();
    }
}

