/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class ReadLock
implements InterProcessLock {
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages entry;
    @StageRef
    HashLookupPos hlp;

    @Override
    public boolean isHeldByCurrentThread() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        return this.s.localLockState.read;
    }

    @Override
    public void lock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (this.s.localLockState == LocalLockState.UNLOCKED) {
            if (this.s.readZero() && this.s.updateZero() && this.s.writeZero()) {
                try {
                    this.s.segmentHeader.readLock(this.s.segmentHeaderAddress);
                }
                catch (InterProcessDeadLockException e) {
                    throw this.s.debugContextsAndLocks(e);
                }
            }
            this.s.incrementRead();
            this.s.setLocalLockState(LocalLockState.READ_LOCKED);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.s.localLockState == LocalLockState.UNLOCKED) {
            if (this.s.readZero() && this.s.updateZero() && this.s.writeZero()) {
                try {
                    this.s.segmentHeader.readLockInterruptibly(this.s.segmentHeaderAddress);
                }
                catch (InterProcessDeadLockException e) {
                    throw this.s.debugContextsAndLocks(e);
                }
            }
            this.s.incrementRead();
            this.s.setLocalLockState(LocalLockState.READ_LOCKED);
        }
    }

    @Override
    public boolean tryLock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (this.s.localLockState == LocalLockState.UNLOCKED) {
            if (!this.s.readZero() || !this.s.updateZero() || !this.s.writeZero() || this.s.segmentHeader.tryReadLock(this.s.segmentHeaderAddress)) {
                this.s.incrementRead();
                this.s.setLocalLockState(LocalLockState.READ_LOCKED);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.s.localLockState == LocalLockState.UNLOCKED) {
            if (!this.s.readZero() || !this.s.updateZero() || !this.s.writeZero() || this.s.segmentHeader.tryReadLock(this.s.segmentHeaderAddress, time, unit)) {
                this.s.incrementRead();
                this.s.setLocalLockState(LocalLockState.READ_LOCKED);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (this.s.localLockState != LocalLockState.UNLOCKED) {
            this.hlp.closeHashLookupPos();
            this.entry.closeEntry();
        }
        this.s.readUnlockAndDecrementCount();
        this.s.setLocalLockState(LocalLockState.UNLOCKED);
    }
}

