/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public final class LongCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 8L;

    LongCompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        super(h);
    }

    @Override
    long indexToPos(long index) {
        return index * 8L;
    }

    @Override
    public long step(long pos) {
        return pos + 8L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 8L & this.capacityMask2;
    }

    @Override
    public long readEntry(long addr, long pos) {
        return OS.memory().readLong(addr + pos);
    }

    @Override
    public void writeEntryVolatile(long addr, long pos, long prevEntry, long key, long value) {
        OS.memory().writeVolatileLong(null, addr + pos, this.entry(key, value));
    }

    @Override
    void writeEntry(long addr, long pos, long prevEntry, long anotherEntry) {
        OS.memory().writeLong(addr + pos, anotherEntry);
    }

    @Override
    void clearEntry(long addr, long pos, long prevEntry) {
        OS.memory().writeLong(addr + pos, 0L);
    }
}

