/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;

public final class IntCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 4L;

    IntCompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        super(h);
    }

    @Override
    long indexToPos(long index) {
        return index * 4L;
    }

    @Override
    public long step(long pos) {
        return pos + 4L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 4L & this.capacityMask2;
    }

    @Override
    public long readEntry(long addr, long pos) {
        return OS.memory().readInt(addr + pos);
    }

    @Override
    public void writeEntryVolatile(long addr, long pos, long prevEntry, long key, long value) {
        OS.memory().writeVolatileInt(null, addr + pos, (int)this.entry(key, value));
    }

    @Override
    void writeEntry(long addr, long pos, long prevEntry, long anotherEntry) {
        OS.memory().writeInt(addr + pos, (int)anotherEntry);
    }

    @Override
    void clearEntry(long addr, long pos, long prevEntry) {
        OS.memory().writeInt(addr + pos, 0);
    }
}

