/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.map.WriteThroughEntry;

abstract class ChronicleMapIterator<K, V, E>
implements Iterator<E>,
Consumer<MapEntry<K, V>> {
    final AbstractChronicleMap<K, V> map;
    private final Thread ownerThread = Thread.currentThread();
    private final Queue<E> entryBuffer = new ArrayDeque();
    E returned;
    private int segmentIndex;

    ChronicleMapIterator(AbstractChronicleMap<K, V> map) {
        this.map = map;
        this.segmentIndex = map.segments() - 1;
    }

    private void checkSingleThreaded() {
        if (this.ownerThread != Thread.currentThread()) {
            throw new IllegalStateException(this.map.toIdentityString() + ": Iterator should be accessed only from a single thread");
        }
    }

    private void fillEntryBuffer() {
        if (!this.entryBuffer.isEmpty()) {
            return;
        }
        while (this.segmentIndex >= 0) {
            MapSegmentContext c = (MapSegmentContext)this.map.segmentContext(this.segmentIndex);
            Throwable throwable = null;
            try {
                --this.segmentIndex;
                if (c.size() == 0L) continue;
                c.forEachSegmentEntry(this);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (c == null) continue;
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                c.close();
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public void accept(MapEntry<K, V> e) {
        this.entryBuffer.add(this.read(e));
    }

    abstract E read(MapEntry<K, V> var1);

    @Override
    public boolean hasNext() {
        this.checkSingleThreaded();
        this.fillEntryBuffer();
        return !this.entryBuffer.isEmpty();
    }

    @Override
    public E next() {
        this.checkSingleThreaded();
        this.fillEntryBuffer();
        E e = this.entryBuffer.poll();
        if (e == null) {
            throw new NoSuchElementException(this.map.toIdentityString());
        }
        this.returned = e;
        return this.returned;
    }

    @Override
    public void remove() {
        this.checkSingleThreaded();
        if (this.returned == null) {
            throw new IllegalStateException(this.map.toIdentityString());
        }
        this.removeReturned();
        this.returned = null;
    }

    abstract void removeReturned();

    static class OfKeys<K, V>
    extends ChronicleMapIterator<K, V, K> {
        OfKeys(AbstractChronicleMap<K, V> map) {
            super(map);
        }

        @Override
        K read(MapEntry<K, V> entry) {
            return entry.key().getUsing(null);
        }

        @Override
        void removeReturned() {
            this.map.remove(this.returned);
        }
    }

    static class OfEntries<K, V>
    extends ChronicleMapIterator<K, V, Map.Entry<K, V>> {
        OfEntries(AbstractChronicleMap<K, V> map) {
            super(map);
        }

        @Override
        Map.Entry<K, V> read(MapEntry<K, V> entry) {
            Object key = entry.key().getUsing(null);
            Object value = entry.value().getUsing(null);
            return new WriteThroughEntry<Object, Object>(this.map, key, value);
        }

        @Override
        void removeReturned() {
            this.map.remove(((Map.Entry)this.returned).getKey(), ((Map.Entry)this.returned).getValue());
        }
    }
}

