/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.locks.AcquisitionStrategies;
import net.openhft.chronicle.algo.locks.AcquisitionStrategy;
import net.openhft.chronicle.algo.locks.LockingStrategy;
import net.openhft.chronicle.algo.locks.TryAcquireOperation;
import net.openhft.chronicle.algo.locks.TryAcquireOperations;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilderPrivateAPI;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.ChronicleHashCloseOnExitHook;
import net.openhft.chronicle.hash.impl.ChronicleHashResources;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.ContextHolder;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.IntCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LongCompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.util.BuildVersion;
import net.openhft.chronicle.hash.impl.util.Cleaner;
import net.openhft.chronicle.hash.impl.util.CleanerUtils;
import net.openhft.chronicle.hash.impl.util.jna.PosixFallocate;
import net.openhft.chronicle.hash.impl.util.jna.PosixMsync;
import net.openhft.chronicle.hash.impl.util.jna.WindowsMsync;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class VanillaChronicleHash<K, C extends HashEntry<K>, SC extends HashSegmentContext<K, ?>, ECQ extends ExternalHashQueryContext<K>>
implements ChronicleHash<K, C, SC, ECQ>,
Marshallable {
    public static final long TIER_COUNTERS_AREA_SIZE = 64L;
    public static final long RESERVED_GLOBAL_MUTABLE_STATE_BYTES = 1024L;
    static final LockingStrategy globalMutableStateLockingStrategy = VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    static final TryAcquireOperation<LockingStrategy> globalMutableStateLockTryAcquireOperation = TryAcquireOperations.lock();
    static final AcquisitionStrategy<LockingStrategy, RuntimeException> globalMutableStateLockAcquisitionStrategy = AcquisitionStrategies.spinLoopOrFail((long)2L, (TimeUnit)TimeUnit.SECONDS);
    private static final long GLOBAL_MUTABLE_STATE_LOCK_OFFSET = 0L;
    private static final long GLOBAL_MUTABLE_STATE_VALUE_OFFSET = 8L;
    public transient boolean createdOrInMemory = true;
    public Type keyClass;
    public SizeMarshaller keySizeMarshaller;
    public SizedReader<K> keyReader;
    public DataAccess<K> keyDataAccess;
    public boolean checksumEntries;
    public int actualSegments;
    public HashSplitting hashSplitting;
    public long chunkSize;
    public int maxChunksPerEntry;
    public long actualChunksPerSegmentTier;
    public int tierHashLookupValueBits;
    public int tierHashLookupKeyBits;
    public int tierHashLookupSlotSize;
    public long tierHashLookupCapacity;
    public long maxEntriesPerHashLookup;
    public long tierHashLookupOuterSize;
    public long tierFreeListInnerSize;
    public long tierFreeListOuterSize;
    public int tierEntrySpaceInnerOffset;
    public long tierSize;
    public long tiersInBulk;
    public transient List<TierBulkData> tierBulkOffsets;
    public transient long headerSize;
    public transient long segmentHeadersOffset;
    public transient CompactOffHeapLinearHashTable hashLookup;
    public transient Identity identity;
    protected int log2TiersInBulk;
    private Runnable preShutdownAction;
    private boolean skipCloseOnExitHook;
    protected transient BytesStore bs;
    int segmentHeaderSize;
    long tierHashLookupInnerSize;
    long tierEntrySpaceInnerSize;
    long tierEntrySpaceOuterSize;
    long maxExtraTiers;
    long tierBulkSizeInBytes;
    long tierBulkInnerOffsetToTiers;
    transient long segmentsOffset;
    private String dataFileVersion = BuildVersion.version();
    private transient File file;
    private transient RandomAccessFile raf;
    private transient ChronicleHashResources resources;
    private transient Cleaner cleaner;
    private transient VanillaGlobalMutableState globalMutableState;

    public VanillaChronicleHash(ChronicleMapBuilder<K, ?> builder) {
        ChronicleHashBuilderPrivateAPI privateAPI = (ChronicleHashBuilderPrivateAPI)builder.privateAPI();
        SerializationBuilder keyBuilder = privateAPI.keyBuilder();
        this.keyClass = keyBuilder.tClass;
        this.keySizeMarshaller = keyBuilder.sizeMarshaller();
        this.keyReader = keyBuilder.reader();
        this.keyDataAccess = keyBuilder.dataAccess();
        this.actualSegments = privateAPI.actualSegments();
        this.hashSplitting = HashSplitting.forSegments(this.actualSegments);
        this.chunkSize = privateAPI.chunkSize();
        this.maxChunksPerEntry = privateAPI.maxChunksPerEntry();
        this.actualChunksPerSegmentTier = privateAPI.actualChunksPerSegmentTier();
        this.segmentHeaderSize = privateAPI.segmentHeaderSize();
        this.tierHashLookupValueBits = CompactOffHeapLinearHashTable.valueBits(this.actualChunksPerSegmentTier);
        this.tierHashLookupKeyBits = CompactOffHeapLinearHashTable.keyBits(privateAPI.entriesPerSegment(), this.tierHashLookupValueBits);
        this.tierHashLookupSlotSize = CompactOffHeapLinearHashTable.entrySize(this.tierHashLookupKeyBits, this.tierHashLookupValueBits);
        if (!privateAPI.aligned64BitMemoryOperationsAtomic() && this.tierHashLookupSlotSize > 4) {
            throw new IllegalStateException("aligned64BitMemoryOperationsAtomic() == false, but hash lookup slot is " + this.tierHashLookupSlotSize);
        }
        this.tierHashLookupCapacity = privateAPI.tierHashLookupCapacity();
        this.maxEntriesPerHashLookup = (long)((double)this.tierHashLookupCapacity * 0.8);
        this.tierHashLookupInnerSize = this.tierHashLookupCapacity * (long)this.tierHashLookupSlotSize;
        this.tierHashLookupOuterSize = MemoryUnit.CACHE_LINES.align(this.tierHashLookupInnerSize, MemoryUnit.BYTES);
        this.tierFreeListInnerSize = MemoryUnit.LONGS.align(MemoryUnit.BYTES.alignAndConvert(this.actualChunksPerSegmentTier, MemoryUnit.BITS), MemoryUnit.BYTES);
        this.tierFreeListOuterSize = MemoryUnit.CACHE_LINES.align(this.tierFreeListInnerSize, MemoryUnit.BYTES);
        this.tierEntrySpaceInnerSize = this.chunkSize * this.actualChunksPerSegmentTier;
        this.tierEntrySpaceInnerOffset = privateAPI.segmentEntrySpaceInnerOffset();
        this.tierEntrySpaceOuterSize = MemoryUnit.CACHE_LINES.align((long)this.tierEntrySpaceInnerOffset + this.tierEntrySpaceInnerSize, MemoryUnit.BYTES);
        this.tierSize = this.tierSize();
        this.maxExtraTiers = privateAPI.maxExtraTiers();
        this.tiersInBulk = this.computeNumberOfTiersInBulk();
        this.log2TiersInBulk = Maths.intLog2((long)this.tiersInBulk);
        this.tierBulkInnerOffsetToTiers = this.computeTierBulkInnerOffsetToTiers(this.tiersInBulk);
        this.tierBulkSizeInBytes = this.computeTierBulkBytesSize(this.tiersInBulk);
        this.checksumEntries = privateAPI.checksumEntries();
        this.preShutdownAction = privateAPI.getPreShutdownAction();
        this.skipCloseOnExitHook = privateAPI.skipCloseOnExitHook();
    }

    public static IOException throwRecoveryOrReturnIOException(File file, String message, boolean recover) {
        message = "file=" + file + " " + message;
        if (recover) {
            throw new ChronicleHashRecoveryFailedException(message);
        }
        return new IOException(message);
    }

    private static long roundUpMapHeaderSize(long headerSize) {
        return MemoryUnit.CACHE_LINES.align(headerSize, MemoryUnit.BYTES);
    }

    public void readMarshallable(@NotNull WireIn wire) {
        this.readMarshallableFields(wire);
        this.initTransients();
    }

    public Runnable getPreShutdownAction() {
        this.throwExceptionIfClosed();
        return this.preShutdownAction;
    }

    protected void readMarshallableFields(@NotNull WireIn wireIn) {
        this.dataFileVersion = wireIn.read(() -> "dataFileVersion").text();
        this.createdOrInMemory = false;
        this.keyClass = wireIn.read(() -> "keyClass").lenientTypeLiteral();
        this.keySizeMarshaller = (SizeMarshaller)wireIn.read(() -> "keySizeMarshaller").object(SizeMarshaller.class);
        this.keyReader = (SizedReader)wireIn.read(() -> "keyReader").object(SizedReader.class);
        this.keyDataAccess = (DataAccess)wireIn.read(() -> "keyDataAccess").object(DataAccess.class);
        this.checksumEntries = wireIn.read(() -> "checksumEntries").bool();
        this.actualSegments = wireIn.read(() -> "actualSegments").int32();
        this.hashSplitting = (HashSplitting)wireIn.read(() -> "hashSplitting").typedMarshallable();
        this.chunkSize = wireIn.read(() -> "chunkSize").int64();
        this.maxChunksPerEntry = wireIn.read(() -> "maxChunksPerEntry").int32();
        this.actualChunksPerSegmentTier = wireIn.read(() -> "actualChunksPerSegmentTier").int64();
        this.segmentHeaderSize = wireIn.read(() -> "segmentHeaderSize").int32();
        this.tierHashLookupValueBits = wireIn.read(() -> "tierHashLookupValueBits").int32();
        this.tierHashLookupKeyBits = wireIn.read(() -> "tierHashLookupKeyBits").int32();
        this.tierHashLookupSlotSize = wireIn.read(() -> "tierHashLookupSlotSize").int32();
        this.tierHashLookupCapacity = wireIn.read(() -> "tierHashLookupCapacity").int64();
        this.maxEntriesPerHashLookup = wireIn.read(() -> "maxEntriesPerHashLookup").int64();
        this.tierHashLookupInnerSize = wireIn.read(() -> "tierHashLookupInnerSize").int64();
        this.tierHashLookupOuterSize = wireIn.read(() -> "tierHashLookupOuterSize").int64();
        this.tierFreeListInnerSize = wireIn.read(() -> "tierFreeListInnerSize").int64();
        this.tierFreeListOuterSize = wireIn.read(() -> "tierFreeListOuterSize").int64();
        this.tierEntrySpaceInnerSize = wireIn.read(() -> "tierEntrySpaceInnerSize").int64();
        this.tierEntrySpaceInnerOffset = wireIn.read(() -> "tierEntrySpaceInnerOffset").int32();
        this.tierEntrySpaceOuterSize = wireIn.read(() -> "tierEntrySpaceOuterSize").int64();
        this.tierSize = wireIn.read(() -> "tierSize").int64();
        this.maxExtraTiers = wireIn.read(() -> "maxExtraTiers").int64();
        this.tierBulkSizeInBytes = wireIn.read(() -> "tierBulkSizeInBytes").int64();
        this.tierBulkInnerOffsetToTiers = wireIn.read(() -> "tierBulkInnerOffsetToTiers").int64();
        this.tiersInBulk = wireIn.read(() -> "tiersInBulk").int64();
        this.log2TiersInBulk = wireIn.read(() -> "log2TiersInBulk").int32();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "dataFileVersion").text(this.dataFileVersion);
        wireOut.write(() -> "keyClass").typeLiteral(this.keyClass);
        wireOut.write(() -> "keySizeMarshaller").object((Object)this.keySizeMarshaller);
        wireOut.write(() -> "keyReader").object(this.keyReader);
        wireOut.write(() -> "keyDataAccess").object(this.keyDataAccess);
        wireOut.write(() -> "checksumEntries").bool(Boolean.valueOf(this.checksumEntries));
        wireOut.write(() -> "actualSegments").int32(this.actualSegments);
        wireOut.write(() -> "hashSplitting").object((Object)this.hashSplitting);
        wireOut.write(() -> "chunkSize").int64(this.chunkSize);
        wireOut.write(() -> "maxChunksPerEntry").int32(this.maxChunksPerEntry);
        wireOut.write(() -> "actualChunksPerSegmentTier").int64(this.actualChunksPerSegmentTier);
        wireOut.write(() -> "segmentHeaderSize").int32(this.segmentHeaderSize);
        wireOut.write(() -> "tierHashLookupValueBits").int32(this.tierHashLookupValueBits);
        wireOut.write(() -> "tierHashLookupKeyBits").int32(this.tierHashLookupKeyBits);
        wireOut.write(() -> "tierHashLookupSlotSize").int32(this.tierHashLookupSlotSize);
        wireOut.write(() -> "tierHashLookupCapacity").int64(this.tierHashLookupCapacity);
        wireOut.write(() -> "maxEntriesPerHashLookup").int64(this.maxEntriesPerHashLookup);
        wireOut.write(() -> "tierHashLookupInnerSize").int64(this.tierHashLookupInnerSize);
        wireOut.write(() -> "tierHashLookupOuterSize").int64(this.tierHashLookupOuterSize);
        wireOut.write(() -> "tierFreeListInnerSize").int64(this.tierFreeListInnerSize);
        wireOut.write(() -> "tierFreeListOuterSize").int64(this.tierFreeListOuterSize);
        wireOut.write(() -> "tierEntrySpaceInnerSize").int64(this.tierEntrySpaceInnerSize);
        wireOut.write(() -> "tierEntrySpaceInnerOffset").int32(this.tierEntrySpaceInnerOffset);
        wireOut.write(() -> "tierEntrySpaceOuterSize").int64(this.tierEntrySpaceOuterSize);
        wireOut.write(() -> "tierSize").int64(this.tierSize);
        wireOut.write(() -> "maxExtraTiers").int64(this.maxExtraTiers);
        wireOut.write(() -> "tierBulkSizeInBytes").int64(this.tierBulkSizeInBytes);
        wireOut.write(() -> "tierBulkInnerOffsetToTiers").int64(this.tierBulkInnerOffsetToTiers);
        wireOut.write(() -> "tiersInBulk").int64(this.tiersInBulk);
        wireOut.write(() -> "log2TiersInBulk").int32(this.log2TiersInBulk);
    }

    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)Values.newNativeReference(VanillaGlobalMutableState.class);
    }

    public VanillaGlobalMutableState globalMutableState() {
        this.throwExceptionIfClosed();
        return this.globalMutableState;
    }

    private long tierSize() {
        long segmentSize = this.tierHashLookupOuterSize + 64L + this.tierFreeListOuterSize + this.tierEntrySpaceOuterSize;
        if ((segmentSize & 0x3FL) != 0L) {
            throw new AssertionError();
        }
        return this.breakL1CacheAssociativityContention(segmentSize);
    }

    protected final long breakL1CacheAssociativityContention(long sizeInBytes) {
        int alignmentToBreak = 2048;
        int eachNthSegmentFallIntoTheSameSet = Math.max(1, alignmentToBreak >> Long.numberOfTrailingZeros(sizeInBytes));
        if (eachNthSegmentFallIntoTheSameSet < this.actualSegments) {
            sizeInBytes |= MemoryUnit.CACHE_LINES.toBytes(1L);
        }
        return sizeInBytes;
    }

    private long computeNumberOfTiersInBulk() {
        int tiersInBulk = this.actualSegments / 8;
        tiersInBulk = Maths.nextPower2((int)tiersInBulk, (int)1);
        while (this.computeTierBulkBytesSize(tiersInBulk) < (long)OS.pageSize()) {
            tiersInBulk *= 2;
        }
        return tiersInBulk;
    }

    private long computeTierBulkBytesSize(long tiersInBulk) {
        return this.computeTierBulkInnerOffsetToTiers(tiersInBulk) + tiersInBulk * this.tierSize;
    }

    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        return 0L;
    }

    public void initTransients() {
        this.throwExceptionIfClosed();
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.globalMutableState = this.createGlobalMutableState();
        this.tierBulkOffsets = new ArrayList<TierBulkData>();
        switch (this.tierHashLookupSlotSize) {
            case 4: {
                this.hashLookup = new IntCompactOffHeapLinearHashTable(this);
                break;
            }
            case 8: {
                this.hashLookup = new LongCompactOffHeapLinearHashTable(this);
                break;
            }
            default: {
                throw new AssertionError((Object)("hash lookup slot size could be 4 or 8, " + this.tierHashLookupSlotSize + " observed"));
            }
        }
        this.identity = new Identity();
    }

    public final void initBeforeMapping(File file, RandomAccessFile raf, long headerEnd, boolean recover) throws IOException {
        this.file = file;
        this.raf = raf;
        this.headerSize = VanillaChronicleHash.roundUpMapHeaderSize(headerEnd);
        if (!this.createdOrInMemory) {
            ByteBuffer globalMutableStateBuffer = ByteBuffer.allocate((int)this.globalMutableState.maxSize());
            FileChannel fileChannel = raf.getChannel();
            while (globalMutableStateBuffer.remaining() > 0) {
                if (fileChannel.read(globalMutableStateBuffer, this.headerSize + 8L + (long)globalMutableStateBuffer.position()) != -1) continue;
                throw VanillaChronicleHash.throwRecoveryOrReturnIOException(file, "truncated", recover);
            }
            globalMutableStateBuffer.flip();
            this.globalMutableState.bytesStore(BytesStore.wrap((ByteBuffer)globalMutableStateBuffer), 0L, this.globalMutableState.maxSize());
        }
    }

    public final void createInMemoryStoreAndSegments(ChronicleHashResources resources) {
        this.resources = resources;
        BytesStore bytesStore = this.nativeBytesStoreWithFixedCapacity(this.sizeInBytesWithoutTiers());
        this.createStoreAndSegments(bytesStore);
    }

    private void createStoreAndSegments(BytesStore bytesStore) {
        this.initBytesStoreAndHeadersViews(bytesStore);
        this.initOffsetsAndBulks();
    }

    private void initOffsetsAndBulks() {
        this.segmentHeadersOffset = this.segmentHeadersOffset();
        long segmentHeadersSize = this.actualSegments * this.segmentHeaderSize;
        this.segmentsOffset = this.segmentHeadersOffset + segmentHeadersSize;
        if (this.createdOrInMemory) {
            this.zeroOutNewlyMappedChronicleMapBytes();
            this.globalMutableState.setSegmentHeadersOffset(this.segmentHeadersOffset);
            this.globalMutableState.setDataStoreSize(this.sizeInBytesWithoutTiers());
        } else {
            this.initBulks();
        }
    }

    private void initBulks() {
        if (this.globalMutableState.getAllocatedExtraTierBulks() > 0) {
            this.appendBulkData(0, this.globalMutableState.getAllocatedExtraTierBulks() - 1, this.bs, this.sizeInBytesWithoutTiers());
        }
    }

    private void initBytesStoreAndHeadersViews(BytesStore bytesStore) {
        if (bytesStore.start() != 0L) {
            throw new AssertionError((Object)("bytes store " + bytesStore + " starts from " + bytesStore.start() + ", 0 expected"));
        }
        this.bs = bytesStore;
        this.globalMutableState.bytesStore(this.bs, this.headerSize + 8L, this.globalMutableState.maxSize());
        this.onHeaderCreated();
    }

    public void setResourcesName() {
        this.throwExceptionIfClosed();
        this.resources.setChronicleHashIdentityString(this.toIdentityString());
    }

    public void registerCleaner() {
        this.throwExceptionIfClosed();
        this.cleaner = CleanerUtils.createCleaner(this, this.resources);
    }

    public void addToOnExitHook() {
        this.throwExceptionIfClosed();
        if (!this.skipCloseOnExitHook) {
            ChronicleHashCloseOnExitHook.add(this);
        }
    }

    public final void createMappedStoreAndSegments(ChronicleHashResources resources) throws IOException {
        this.resources = resources;
        this.createStoreAndSegments((BytesStore)this.map(this.dataStoreSize(), 0L));
    }

    public final void basicRecover(ChronicleHashResources resources, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) throws IOException {
        this.resources = resources;
        long segmentHeadersOffset = this.globalMutableState().getSegmentHeadersOffset();
        if (segmentHeadersOffset <= 0L || segmentHeadersOffset % 4096L != 0L || segmentHeadersOffset > MemoryUnit.GIGABYTES.toBytes(1L)) {
            segmentHeadersOffset = this.computeSegmentHeadersOffset();
        }
        long sizeInBytesWithoutTiers = this.computeSizeInBytesWithoutTiers(segmentHeadersOffset);
        long dataStoreSize = this.globalMutableState().getDataStoreSize();
        int allocatedExtraTierBulks = this.globalMutableState().getAllocatedExtraTierBulks();
        if (dataStoreSize < sizeInBytesWithoutTiers || (dataStoreSize - sizeInBytesWithoutTiers) % this.tierBulkSizeInBytes != 0L) {
            dataStoreSize = sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes;
        } else {
            allocatedExtraTierBulks = (int)((dataStoreSize - sizeInBytesWithoutTiers) / this.tierBulkSizeInBytes);
        }
        this.initBytesStoreAndHeadersViews((BytesStore)this.map(dataStoreSize, 0L));
        this.resetGlobalMutableStateLock(corruptionListener, corruption);
        this.recoverAllocatedExtraTierBulks(allocatedExtraTierBulks, corruptionListener, corruption);
        this.recoverSegmentHeadersOffset(segmentHeadersOffset, corruptionListener, corruption);
        this.recoverDataStoreSize(dataStoreSize, corruptionListener, corruption);
        this.initOffsetsAndBulks();
    }

    private void resetGlobalMutableStateLock(ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        long lockAddr = this.globalMutableStateAddress() + 0L;
        LockingStrategy lockingStrategy = globalMutableStateLockingStrategy;
        long lockState = lockingStrategy.getState((ReadAccess)Access.nativeAccess(), null, lockAddr);
        if (lockState != lockingStrategy.resetState()) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("global mutable state lock of map at {} is not clear: {}", this.file, lockingStrategy.toString(lockState)));
            lockingStrategy.reset(Access.nativeAccess(), null, lockAddr);
        }
    }

    private void recoverAllocatedExtraTierBulks(int allocatedExtraTierBulks, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        if (this.globalMutableState.getAllocatedExtraTierBulks() != allocatedExtraTierBulks) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("allocated extra tier bulks counter corrupted, or the map file {} is truncated. stored: {}, should be: {}", this.file, this.globalMutableState.getAllocatedExtraTierBulks(), allocatedExtraTierBulks));
            this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks);
        }
    }

    private void recoverSegmentHeadersOffset(long segmentHeadersOffset, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        if (this.globalMutableState.getSegmentHeadersOffset() != segmentHeadersOffset) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("segment headers offset of map at {} corrupted. stored: {}, should be: {}", this.file, this.globalMutableState.getSegmentHeadersOffset(), segmentHeadersOffset));
            this.globalMutableState.setSegmentHeadersOffset(segmentHeadersOffset);
        }
    }

    private void recoverDataStoreSize(long dataStoreSize, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) {
        if (this.globalMutableState.getDataStoreSize() != dataStoreSize) {
            ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("data store size of map at {} corrupted. stored: {}, should be: {}", this.file, this.globalMutableState.getDataStoreSize(), dataStoreSize));
            this.globalMutableState.setDataStoreSize(dataStoreSize);
        }
    }

    private boolean persisted() {
        return this.file != null;
    }

    protected void zeroOutNewlyMappedChronicleMapBytes() {
        this.zeroOutGlobalMutableState();
        this.zeroOutSegmentHeaders();
        this.zeroOutFirstSegmentTiers();
    }

    private void zeroOutGlobalMutableState() {
        this.bs.zeroOut(this.headerSize, this.headerSize + this.globalMutableStateTotalUsedSize());
    }

    protected long globalMutableStateTotalUsedSize() {
        return 8L + this.globalMutableState().maxSize();
    }

    private void zeroOutSegmentHeaders() {
        this.bs.zeroOut(this.segmentHeadersOffset, this.segmentsOffset);
    }

    private void zeroOutFirstSegmentTiers() {
        for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
            long segmentOffset = this.segmentOffset(segmentIndex);
            this.zeroOutNewlyMappedTier(this.bs, segmentOffset);
        }
    }

    private void zeroOutNewlyMappedTier(BytesStore bytesStore, long tierOffset) {
        bytesStore.zeroOut(tierOffset, tierOffset + this.tierSize - this.tierEntrySpaceOuterSize);
    }

    public void onHeaderCreated() {
        this.throwExceptionIfClosed();
    }

    public String persistedDataVersion() {
        this.throwExceptionIfClosed();
        return this.dataFileVersion;
    }

    private long segmentHeadersOffset() {
        if (this.createdOrInMemory) {
            return this.computeSegmentHeadersOffset();
        }
        return this.globalMutableState.getSegmentHeadersOffset();
    }

    private long computeSegmentHeadersOffset() {
        long reserved = 1024L - this.globalMutableStateTotalUsedSize();
        return OS.pageAlign((long)(this.mapHeaderInnerSize() + reserved));
    }

    public long mapHeaderInnerSize() {
        this.throwExceptionIfClosed();
        return this.headerSize + this.globalMutableStateTotalUsedSize();
    }

    @Override
    public File file() {
        return this.file;
    }

    public final long sizeInBytesWithoutTiers() {
        return this.computeSizeInBytesWithoutTiers(this.segmentHeadersOffset());
    }

    private long computeSizeInBytesWithoutTiers(long segmentHeadersOffset) {
        return segmentHeadersOffset + (long)this.actualSegments * ((long)this.segmentHeaderSize + this.tierSize);
    }

    public final long dataStoreSize() {
        long sizeInBytesWithoutTiers = this.sizeInBytesWithoutTiers();
        int allocatedExtraTierBulks = !this.createdOrInMemory ? this.globalMutableState.getAllocatedExtraTierBulks() : 0;
        return sizeInBytesWithoutTiers + (long)allocatedExtraTierBulks * this.tierBulkSizeInBytes;
    }

    @Override
    public final void close() {
        if (this.resources.releaseManually()) {
            this.cleanupOnClose();
        }
    }

    protected void cleanupOnClose() {
        this.cleaner.clean();
        if (!this.skipCloseOnExitHook) {
            ChronicleHashCloseOnExitHook.remove(this);
        }
        this.keyReader = null;
        this.keyDataAccess = null;
    }

    @Override
    public boolean isOpen() {
        this.throwExceptionIfClosed();
        return !this.resources.closed();
    }

    public final void checkKey(Object key) {
        Class keyClass = this.keyClass();
        if (!keyClass.isInstance(key)) {
            if (key == null) {
                throw new NullPointerException("null key not supported");
            }
            throw new ClassCastException(this.toIdentityString() + ": Key must be a " + keyClass.getName() + " but was a " + key.getClass());
        }
    }

    public final long segmentHeaderAddress(int segmentIndex) {
        return this.bsAddress() + this.segmentHeadersOffset + (long)segmentIndex * (long)this.segmentHeaderSize;
    }

    public long bsAddress() {
        this.throwExceptionIfClosed();
        return this.bs.addressForRead(0L);
    }

    public final long segmentBaseAddr(int segmentIndex) {
        return this.bsAddress() + this.segmentOffset(segmentIndex);
    }

    private long segmentOffset(long segmentIndex) {
        return this.segmentsOffset + segmentIndex * this.tierSize;
    }

    public final int inChunks(long sizeInBytes) {
        if (sizeInBytes <= this.chunkSize) {
            return 1;
        }
        if (sizeInBytes <= Integer.MAX_VALUE) {
            return (int)(sizeInBytes + this.chunkSize - 1L) / (int)this.chunkSize;
        }
        return Math.toIntExact((sizeInBytes + this.chunkSize - 1L) / this.chunkSize);
    }

    public final int size() {
        long size = this.longSize();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public int segments() {
        this.throwExceptionIfClosed();
        return this.actualSegments;
    }

    private long globalMutableStateAddress() {
        return this.bsAddress() + this.headerSize;
    }

    public void globalMutableStateLock() {
        this.throwExceptionIfClosed();
        globalMutableStateLockAcquisitionStrategy.acquire(globalMutableStateLockTryAcquireOperation, globalMutableStateLockingStrategy, Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public void globalMutableStateUnlock() {
        this.throwExceptionIfClosed();
        globalMutableStateLockingStrategy.unlock(Access.nativeAccess(), null, this.globalMutableStateAddress() + 0L);
    }

    public boolean hasExtraTierBulks() {
        this.throwExceptionIfClosed();
        return this.globalMutableState.getAllocatedExtraTierBulks() > 0;
    }

    @Override
    public long offHeapMemoryUsed() {
        this.throwExceptionIfClosed();
        return this.resources.totalMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateTier() {
        this.throwExceptionIfClosed();
        this.globalMutableStateLock();
        try {
            long tiersInUse = this.globalMutableState.getExtraTiersInUse();
            if (tiersInUse >= this.maxExtraTiers) {
                throw new IllegalStateException(this.toIdentityString() + ": Attempt to allocate #" + (tiersInUse + 1L) + " extra segment tier, " + this.maxExtraTiers + " is maximum.\nPossible reasons include:\n - you have forgotten to configure (or configured wrong) builder.entries() number\n - same regarding other sizing Chronicle Hash configurations, most likely maxBloatFactor(), averageKeySize(), or averageValueSize()\n - keys, inserted into the ChronicleHash, are distributed suspiciously bad. This might be a DOS attack");
            }
            long firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex();
            if (firstFreeTierIndex < 0L) {
                throw new RuntimeException(this.toIdentityString() + ": unexpected firstFreeTierIndex value " + firstFreeTierIndex);
            }
            if (firstFreeTierIndex == 0L) {
                try {
                    this.allocateTierBulk();
                }
                catch (IOException e) {
                    throw new RuntimeException(this.toIdentityString(), e);
                }
                firstFreeTierIndex = this.globalMutableState.getFirstFreeTierIndex();
                if (firstFreeTierIndex <= 0L) {
                    throw new RuntimeException(this.toIdentityString() + ": unexpected firstFreeTierIndex value " + firstFreeTierIndex);
                }
            }
            this.globalMutableState.setExtraTiersInUse(tiersInUse + 1L);
            BytesStore allocatedTierBytes = this.tierBytesStore(firstFreeTierIndex);
            long allocatedTierOffset = this.tierBytesOffset(firstFreeTierIndex);
            long tierBaseAddr = allocatedTierBytes.addressForRead(0L) + allocatedTierOffset;
            long tierCountersAreaAddr = tierBaseAddr + this.tierHashLookupOuterSize;
            long nextFreeTierIndex = TierCountersArea.nextTierIndex(tierCountersAreaAddr);
            this.globalMutableState.setFirstFreeTierIndex(nextFreeTierIndex);
            long l = firstFreeTierIndex;
            return l;
        }
        finally {
            this.globalMutableStateUnlock();
        }
    }

    private void allocateTierBulk() throws IOException {
        int allocatedExtraTierBulks = this.globalMutableState.getAllocatedExtraTierBulks();
        this.mapTierBulks(allocatedExtraTierBulks);
        long firstTierIndex = this.extraTierIndexToTierIndex((long)allocatedExtraTierBulks * this.tiersInBulk);
        BytesStore tierBytesStore = this.tierBytesStore(firstTierIndex);
        long firstTierOffset = this.tierBytesOffset(firstTierIndex);
        if (this.tierBulkInnerOffsetToTiers > 0L) {
            tierBytesStore.zeroOut(firstTierOffset - this.tierBulkInnerOffsetToTiers, firstTierOffset);
        }
        long lastTierIndex = firstTierIndex + this.tiersInBulk - 1L;
        this.linkAndZeroOutFreeTiers(firstTierIndex, lastTierIndex);
        if (this.persisted()) {
            long address = tierBytesStore.addressForRead(firstTierOffset - this.tierBulkInnerOffsetToTiers);
            long endAddress = tierBytesStore.addressForRead(this.tierBytesOffset(lastTierIndex)) + this.tierSize;
            long length = endAddress - address;
            this.msync(address, length);
        }
        this.globalMutableState.setAllocatedExtraTierBulks(allocatedExtraTierBulks + 1);
        this.globalMutableState.setFirstFreeTierIndex(firstTierIndex);
        this.globalMutableState.addDataStoreSize(this.tierBulkSizeInBytes);
    }

    public void msync() throws IOException {
        this.throwExceptionIfClosed();
        if (this.persisted()) {
            this.msync(this.bsAddress(), this.bs.capacity());
        }
    }

    private void msync(long address, long length) throws IOException {
        if (OS.pageAlign((long)address) != address) {
            long oldAddress = address;
            address = OS.pageAlign((long)address) - (long)OS.pageSize();
            length += oldAddress - address;
        }
        if (OS.isWindows()) {
            WindowsMsync.msync(this.raf, address, length);
        } else {
            PosixMsync.msync(address, length);
        }
    }

    public void linkAndZeroOutFreeTiers(long firstTierIndex, long lastTierIndex) {
        this.throwExceptionIfClosed();
        for (long tierIndex = firstTierIndex; tierIndex <= lastTierIndex; ++tierIndex) {
            long tierOffset = this.tierBytesOffset(tierIndex);
            BytesStore tierBytesStore = this.tierBytesStore(tierIndex);
            this.zeroOutNewlyMappedTier(tierBytesStore, tierOffset);
            if (tierIndex >= lastTierIndex) continue;
            long tierCountersAreaOffset = tierOffset + this.tierHashLookupOuterSize;
            TierCountersArea.nextTierIndex(tierBytesStore.addressForRead(0L) + tierCountersAreaOffset, tierIndex + 1L);
        }
    }

    public long extraTierIndexToTierIndex(long extraTierIndex) {
        this.throwExceptionIfClosed();
        return (long)this.actualSegments + extraTierIndex + 1L;
    }

    public long tierIndexToBaseAddr(long tierIndex) {
        this.throwExceptionIfClosed();
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentBaseAddr((int)tierIndexMinusOne);
        }
        return this.extraTierIndexToBaseAddr(tierIndexMinusOne);
    }

    public BytesStore tierBytesStore(long tierIndex) {
        this.throwExceptionIfClosed();
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.bs;
        }
        return this.tierBulkData((long)tierIndexMinusOne).bytesStore;
    }

    public long tierBytesOffset(long tierIndex) {
        this.throwExceptionIfClosed();
        long tierIndexMinusOne = tierIndex - 1L;
        if (tierIndexMinusOne < (long)this.actualSegments) {
            return this.segmentOffset(tierIndexMinusOne);
        }
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get((int)bulkIndex).offset + this.tierBulkInnerOffsetToTiers + (extraTierIndex & this.tiersInBulk - 1L) * this.tierSize;
    }

    private TierBulkData tierBulkData(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        return this.tierBulkOffsets.get(bulkIndex);
    }

    private long extraTierIndexToBaseAddr(long tierIndexMinusOne) {
        long extraTierIndex = tierIndexMinusOne - (long)this.actualSegments;
        int bulkIndex = (int)(extraTierIndex >> this.log2TiersInBulk);
        if (bulkIndex >= this.tierBulkOffsets.size()) {
            this.mapTierBulks(bulkIndex);
        }
        TierBulkData tierBulkData = this.tierBulkOffsets.get(bulkIndex);
        long tierIndexOffsetWithinBulk = extraTierIndex & this.tiersInBulk - 1L;
        return this.tierAddr(tierBulkData, tierIndexOffsetWithinBulk);
    }

    protected long tierAddr(TierBulkData tierBulkData, long tierIndexOffsetWithinBulk) {
        return tierBulkData.bytesStore.addressForRead(0L) + tierBulkData.offset + this.tierBulkInnerOffsetToTiers + tierIndexOffsetWithinBulk * this.tierSize;
    }

    private void mapTierBulks(int upToBulkIndex) {
        if (this.persisted()) {
            try {
                this.mapTierBulksMapped(upToBulkIndex);
            }
            catch (IOException e) {
                throw new RuntimeException(this.toIdentityString(), e);
            }
        } else {
            this.allocateTierBulks(upToBulkIndex);
        }
    }

    private void mapTierBulksMapped(int upToBulkIndex) throws IOException {
        long firstBulkToMapOffsetWithinMapping;
        long mappingOffsetInFile;
        int firstBulkToMapIndex = this.tierBulkOffsets.size();
        int bulksToMap = upToBulkIndex + 1 - firstBulkToMapIndex;
        long mapSize = (long)bulksToMap * this.tierBulkSizeInBytes;
        long firstBulkToMapOffset = this.bulkOffset(firstBulkToMapIndex);
        if (OS.mapAlign((long)firstBulkToMapOffset) == firstBulkToMapOffset) {
            mappingOffsetInFile = firstBulkToMapOffset;
            firstBulkToMapOffsetWithinMapping = 0L;
        } else {
            mappingOffsetInFile = OS.mapAlign((long)firstBulkToMapOffset) - OS.mapAlignment();
            firstBulkToMapOffsetWithinMapping = firstBulkToMapOffset - mappingOffsetInFile;
            mapSize += firstBulkToMapOffsetWithinMapping;
        }
        NativeBytesStore extraStore = this.map(mapSize, mappingOffsetInFile);
        this.appendBulkData(firstBulkToMapIndex, upToBulkIndex, (BytesStore)extraStore, firstBulkToMapOffsetWithinMapping);
    }

    private NativeBytesStore map(long mapSize, long mappingOffsetInFile) throws IOException {
        mapSize = OS.pageAlign((long)mapSize);
        long minFileSize = mappingOffsetInFile + mapSize;
        FileChannel fileChannel = this.raf.getChannel();
        if (fileChannel.size() < minFileSize) {
            this.raf.setLength(minFileSize);
            if (OS.isLinux()) {
                PosixFallocate.fallocate(this.raf.getFD(), 0L, minFileSize);
            }
        }
        long address = OS.map((FileChannel)fileChannel, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)mappingOffsetInFile, (long)mapSize);
        this.resources.addMemoryResource(address, mapSize);
        return new NativeBytesStore(address, mapSize, null, false);
    }

    private long bulkOffset(int bulkIndex) {
        return this.sizeInBytesWithoutTiers() + (long)bulkIndex * this.tierBulkSizeInBytes;
    }

    private void allocateTierBulks(int upToBulkIndex) {
        int firstBulkToAllocateIndex = this.tierBulkOffsets.size();
        int bulksToAllocate = upToBulkIndex + 1 - firstBulkToAllocateIndex;
        long allocationSize = (long)bulksToAllocate * this.tierBulkSizeInBytes;
        BytesStore extraStore = this.nativeBytesStoreWithFixedCapacity(allocationSize);
        this.appendBulkData(firstBulkToAllocateIndex, upToBulkIndex, extraStore, 0L);
    }

    private BytesStore nativeBytesStoreWithFixedCapacity(long capacity) {
        long address = OS.memory().allocate(capacity);
        this.resources.addMemoryResource(address, capacity);
        return new NativeBytesStore(address, capacity, null, false);
    }

    private void appendBulkData(int firstBulkToMapIndex, int upToBulkIndex, BytesStore extraStore, long offsetWithinMapping) {
        TierBulkData firstMappedBulkData = new TierBulkData(extraStore, offsetWithinMapping);
        this.tierBulkOffsets.add(firstMappedBulkData);
        for (int bulkIndex = firstBulkToMapIndex + 1; bulkIndex <= upToBulkIndex; ++bulkIndex) {
            this.tierBulkOffsets.add(new TierBulkData(firstMappedBulkData, offsetWithinMapping += this.tierBulkSizeInBytes));
        }
    }

    protected void addContext(ContextHolder contextHolder) {
        this.resources.addContext(contextHolder);
    }

    public void addCloseable(Closeable closeable) {
        this.throwExceptionIfClosed();
        this.resources.addCloseable(closeable);
    }

    public List<WeakReference<ContextHolder>> allContexts() {
        this.throwExceptionIfClosed();
        return Collections.unmodifiableList(this.resources.contexts());
    }

    public class Identity {
        public VanillaChronicleHash hash() {
            VanillaChronicleHash.this.throwExceptionIfClosed();
            return VanillaChronicleHash.this;
        }
    }

    public static class TierBulkData {
        public final BytesStore bytesStore;
        public final long offset;

        public TierBulkData(BytesStore bytesStore, long offset) {
            this.bytesStore = bytesStore;
            this.offset = offset;
        }

        public TierBulkData(TierBulkData data, long offset) {
            this.bytesStore = data.bytesStore;
            this.offset = offset;
        }
    }
}

