/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.entry;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.stage.entry.AllocatedChunks;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.data.bytes.EntryValueBytesData;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class MapEntryStages<K, V>
extends HashEntryStages<K>
implements MapEntry<K, V> {
    @StageRef
    public VanillaChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    public AllocatedChunks allocatedChunks;
    public long valueSizeOffset = -1L;
    @Stage(value="ValueSize")
    public long valueSize = -1L;
    @Stage(value="ValueSize")
    public long valueOffset;
    @StageRef
    public EntryValueBytesData<V> entryValue;
    @StageRef
    KeySearch<K> ks;

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        Bytes segmentBytes = this.s.segmentBytesForWrite();
        segmentBytes.writePosition(this.valueSizeOffset);
        this.mh.m().valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.addressForRead(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, this.mh.m().alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
    }

    void initValueSize() {
        Bytes segmentBytes = this.s.segmentBytesForRead();
        segmentBytes.readPosition(this.valueSizeOffset);
        this.valueSize = this.mh.m().readValueSize(segmentBytes);
        this.valueOffset = segmentBytes.readPosition();
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public void writeValue(Data<?> value) {
        this.initDelayedUpdateChecksum(true);
        value.writeTo((RandomDataOutput)this.s.segmentBS, this.valueOffset);
    }

    @Override
    public long entryEnd() {
        return this.valueOffset + this.valueSize;
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entryValue;
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset + (long)this.mh.m().valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset;
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.s.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize;
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset;
            VanillaChronicleMap<?, ?, ?> m = this.mh.m();
            int newSizeInChunks = m.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.mh.m().alignment)));
            if (newSizeInChunks > this.entrySizeInChunks) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException(m.toIdentityString() + ": Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.s.realloc(this.pos, this.entrySizeInChunks, newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
            } else if (newSizeInChunks < this.entrySizeInChunks) {
                this.s.freeExtra(this.pos, this.entrySizeInChunks, newSizeInChunks);
            }
        }
        this.s.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
        } else {
            this.writeValue(newValue);
        }
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hlp.hashLookupPos;
        long oldHashLookupAddr = this.s.tierBaseAddr;
        boolean tierHasChanged = this.allocatedChunks.initEntryAndKeyCopying(entrySize, this.valueSizeOffset - this.keySizeOffset, this.pos, this.entrySizeInChunks);
        if (tierHasChanged && !this.ks.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.hh.h().hashLookup;
        long hashLookupKey = hl.key(hl.readEntry(oldHashLookupAddr, oldHashLookupPos));
        hl.checkValueForPut(this.pos);
        hl.writeEntryVolatile(this.s.tierBaseAddr, this.hlp.hashLookupPos, hashLookupKey, this.pos);
        this.s.innerWriteLock.lock();
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        if (!this.mh.m().constantlySizedEntry && this.mh.m().couldNotDetermineAlignmentBeforeAllocation) {
            sizeOfEverythingBeforeValue += (long)this.mh.m().worstAlignment;
        }
        int alignment = this.mh.m().alignment;
        return VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, alignment) + VanillaChronicleMap.alignAddr(valueSize, alignment);
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)this.mh.m().keySizeMarshaller.storingLength(keySize) + keySize + this.checksumStrategy.extraEntryBytes() + (long)this.mh.m().valueSizeMarshaller.storingLength(valueSize);
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.mh.m().constantlySizedEntry && this.mh.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks < this.allocatedChunks.allocatedChunks) {
            this.s.freeExtra(this.pos, this.allocatedChunks.allocatedChunks, this.entrySizeInChunks);
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks.allocatedChunks);
        }
    }

    public boolean entryDeleted() {
        return false;
    }
}

