/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PosixFallocate {
    private static final Logger LOG = LoggerFactory.getLogger((String)PosixFallocate.class.getName());

    private PosixFallocate() {
    }

    public static void fallocate(FileDescriptor descriptor, long offset, long length) {
        int ret;
        int fd = PosixFallocate.getNativeFileDescriptor(descriptor);
        if (fd != -1 && (ret = PosixFallocate.posix_fallocate(PosixFallocate.getNativeFileDescriptor(descriptor), offset, length)) != 0) {
            LOG.warn("posix_fallocate() returned {}", (Object)ret);
        }
    }

    private static native int posix_fallocate(int var0, long var1, long var3);

    private static int getNativeFileDescriptor(FileDescriptor descriptor) {
        try {
            Field field = descriptor.getClass().getDeclaredField("fd");
            field.setAccessible(true);
            return (Integer)field.get(descriptor);
        }
        catch (Exception e) {
            LOG.warn("unsupported FileDescriptor implementation: e={}", (Object)e.getLocalizedMessage());
            return -1;
        }
    }

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }
}

