/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.locks.VanillaReadWriteUpdateWithWaitsLockingStrategy;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.ThreadHints;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;

public final class BigSegmentHeader
implements SegmentHeader {
    public static final BigSegmentHeader INSTANCE = new BigSegmentHeader();
    static final long LOCK_OFFSET = 0L;
    static final long ENTRIES_OFFSET = 8L;
    static final long LOWEST_POSSIBLY_FREE_CHUNK_OFFSET = 12L;
    static final long NEXT_TIER_INDEX_OFFSET = 16L;
    static final long DELETED_OFFSET = 24L;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final VanillaReadWriteUpdateWithWaitsLockingStrategy LOCK = (VanillaReadWriteUpdateWithWaitsLockingStrategy)VanillaReadWriteUpdateWithWaitsLockingStrategy.instance();
    private static final NativeAccess A = (NativeAccess)Access.nativeAccess();
    private static final int TRY_LOCK_NANOS_THRESHOLD = 2000000;
    public static int LOCK_TIMEOUT_SECONDS;

    private BigSegmentHeader() {
    }

    private static InterProcessDeadLockException deadLock() {
        return new InterProcessDeadLockException("Failed to acquire the lock in " + LOCK_TIMEOUT_SECONDS + " seconds.\n" + "Possible reasons:\n" + " - The lock was not released by the previous holder. If you use contexts API,\n" + " for example map.queryContext(key), in a try-with-resources block.\n" + " - This Chronicle Map (or Set) instance is persisted to disk, and the previous\n" + " process (or one of parallel accessing processes) has crashed while holding\n" + " this lock. In this case you should use ChronicleMapBuilder.recoverPersistedTo()" + " procedure\n" + " to access the Chronicle Map instance.\n" + " - A concurrent thread or process, currently holding this lock, spends\n" + " unexpectedly long time (more than " + LOCK_TIMEOUT_SECONDS + " seconds) in\n" + " the context (try-with-resource block) or one of overridden interceptor\n" + " methods (or MapMethods, or MapEntryOperations, or MapRemoteOperations)\n" + " while performing an ordinary Map operation or replication. You should either\n" + " redesign your logic to spend less time in critical sections (recommended) or\n" + " acquire this lock with tryLock(time, timeUnit) method call, with sufficient\n" + " time specified.\n" + " - Segment(s) in your Chronicle Map are very large, and iteration over them\n" + " takes more than " + LOCK_TIMEOUT_SECONDS + " seconds. In this case you should\n" + " acquire this lock with tryLock(time, timeUnit) method call, with longer\n" + " timeout specified.\n" + " - This is a dead lock. If you perform multi-key queries, ensure you acquire\n" + " segment locks in the order (ascending by segmentIndex()), you can find\n" + " an example here: https://github.com/OpenHFT/Chronicle-Map#multi-key-queries\n");
    }

    private static long roundUpNanosToMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos + 900000L);
    }

    private static boolean innerTryReadLock(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        return LOCK.tryReadLock((Access)A, null, address + 0L) || BigSegmentHeader.tryReadLock0(address, time, unit, interruptible);
    }

    private static boolean tryReadLock0(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return BigSegmentHeader.tryReadLockNanos(address, timeInNanos, interruptible);
        }
        return BigSegmentHeader.tryReadLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos), interruptible);
    }

    private static boolean tryReadLockNanos(long address, long timeInNanos, boolean interruptible) throws InterruptedException {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (LOCK.tryReadLock((Access)A, null, address + 0L)) {
                return true;
            }
            BigSegmentHeader.checkInterrupted(interruptible);
            ThreadHints.onSpinWait();
        } while (System.nanoTime() <= end);
        return false;
    }

    private static boolean tryReadLockMillis(long address, long timeInMillis, boolean interruptible) throws InterruptedException {
        long lastTime = System.currentTimeMillis();
        do {
            if (LOCK.tryReadLock((Access)A, null, address + 0L)) {
                return true;
            }
            BigSegmentHeader.checkInterrupted(interruptible);
            ThreadHints.onSpinWait();
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    private static boolean innerTryUpdateLock(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        return LOCK.tryUpdateLock((Access)A, null, address + 0L) || BigSegmentHeader.tryUpdateLock0(address, time, unit, interruptible);
    }

    private static boolean tryUpdateLock0(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return BigSegmentHeader.tryUpdateLockNanos(address, timeInNanos, interruptible);
        }
        return BigSegmentHeader.tryUpdateLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos), interruptible);
    }

    private static boolean tryUpdateLockNanos(long address, long timeInNanos, boolean interruptible) throws InterruptedException {
        long end = System.nanoTime() + timeInNanos;
        do {
            if (LOCK.tryUpdateLock((Access)A, null, address + 0L)) {
                return true;
            }
            BigSegmentHeader.checkInterrupted(interruptible);
            ThreadHints.onSpinWait();
        } while (System.nanoTime() <= end);
        return false;
    }

    private static boolean tryUpdateLockMillis(long address, long timeInMillis, boolean interruptible) throws InterruptedException {
        long lastTime = System.currentTimeMillis();
        do {
            if (LOCK.tryUpdateLock((Access)A, null, address + 0L)) {
                return true;
            }
            BigSegmentHeader.checkInterrupted(interruptible);
            ThreadHints.onSpinWait();
            long now = System.currentTimeMillis();
            if (now == lastTime) continue;
            lastTime = now;
            --timeInMillis;
        } while (timeInMillis >= 0L);
        return false;
    }

    private static boolean innerTryWriteLock(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        return LOCK.tryWriteLock((Access)A, null, address + 0L) || BigSegmentHeader.tryWriteLock0(address, time, unit, interruptible);
    }

    private static boolean tryWriteLock0(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return BigSegmentHeader.tryWriteLockNanos(address, timeInNanos, interruptible);
        }
        return BigSegmentHeader.tryWriteLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos), interruptible);
    }

    private static boolean tryWriteLockNanos(long address, long timeInNanos, boolean interruptible) throws InterruptedException {
        long end = System.nanoTime() + timeInNanos;
        BigSegmentHeader.registerWait(address);
        try {
            do {
                if (LOCK.tryWriteLockAndDeregisterWait((Access)A, null, address + 0L)) {
                    return true;
                }
                BigSegmentHeader.checkInterrupted(interruptible);
                ThreadHints.onSpinWait();
            } while (System.nanoTime() <= end);
            BigSegmentHeader.deregisterWait(address);
            return false;
        }
        catch (Throwable t) {
            throw BigSegmentHeader.tryDeregisterWaitAndRethrow(address, t);
        }
    }

    private static boolean tryWriteLockMillis(long address, long timeInMillis, boolean interruptible) throws InterruptedException {
        long lastTime = System.currentTimeMillis();
        BigSegmentHeader.registerWait(address);
        try {
            do {
                if (LOCK.tryWriteLockAndDeregisterWait((Access)A, null, address + 0L)) {
                    return true;
                }
                BigSegmentHeader.checkInterrupted(interruptible);
                ThreadHints.onSpinWait();
                long now = System.currentTimeMillis();
                if (now == lastTime) continue;
                lastTime = now;
                --timeInMillis;
            } while (timeInMillis >= 0L);
            BigSegmentHeader.deregisterWait(address);
            return false;
        }
        catch (Throwable t) {
            throw BigSegmentHeader.tryDeregisterWaitAndRethrow(address, t);
        }
    }

    private static void checkInterrupted(boolean interruptible) throws InterruptedException {
        if (interruptible && Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static void registerWait(long address) {
        LOCK.registerWait((Access)A, null, address + 0L);
    }

    private static void deregisterWait(long address) {
        LOCK.deregisterWait((Access)A, null, address + 0L);
    }

    private static boolean innerTryUpgradeUpdateToWriteLock(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        return LOCK.tryUpgradeUpdateToWriteLock((Access)A, null, address + 0L) || BigSegmentHeader.tryUpgradeUpdateToWriteLock0(address, time, unit, interruptible);
    }

    private static boolean tryUpgradeUpdateToWriteLock0(long address, long time, TimeUnit unit, boolean interruptible) throws InterruptedException {
        long timeInNanos = unit.toNanos(time);
        if (timeInNanos < 2000000L) {
            return BigSegmentHeader.tryUpgradeUpdateToWriteLockNanos(address, timeInNanos, interruptible);
        }
        return BigSegmentHeader.tryUpgradeUpdateToWriteLockMillis(address, BigSegmentHeader.roundUpNanosToMillis(timeInNanos), interruptible);
    }

    private static boolean tryUpgradeUpdateToWriteLockNanos(long address, long timeInNanos, boolean interruptible) throws InterruptedException {
        long end = System.nanoTime() + timeInNanos;
        BigSegmentHeader.registerWait(address);
        try {
            do {
                if (BigSegmentHeader.tryUpgradeUpdateToWriteLockAndDeregisterWait0(address)) {
                    return true;
                }
                BigSegmentHeader.checkInterrupted(interruptible);
                ThreadHints.onSpinWait();
            } while (System.nanoTime() <= end);
            BigSegmentHeader.deregisterWait(address);
            return false;
        }
        catch (Throwable t) {
            throw BigSegmentHeader.tryDeregisterWaitAndRethrow(address, t);
        }
    }

    private static boolean tryUpgradeUpdateToWriteLockMillis(long address, long timeInMillis, boolean interruptible) throws InterruptedException {
        long lastTime = System.currentTimeMillis();
        BigSegmentHeader.registerWait(address);
        try {
            do {
                if (BigSegmentHeader.tryUpgradeUpdateToWriteLockAndDeregisterWait0(address)) {
                    return true;
                }
                BigSegmentHeader.checkInterrupted(interruptible);
                ThreadHints.onSpinWait();
                long now = System.currentTimeMillis();
                if (now == lastTime) continue;
                lastTime = now;
                --timeInMillis;
            } while (timeInMillis >= 0L);
            BigSegmentHeader.deregisterWait(address);
            return false;
        }
        catch (Throwable t) {
            throw BigSegmentHeader.tryDeregisterWaitAndRethrow(address, t);
        }
    }

    private static RuntimeException tryDeregisterWaitAndRethrow(long address, Throwable throwable) {
        try {
            BigSegmentHeader.deregisterWait(address);
        }
        catch (Throwable t) {
            throwable.addSuppressed(t);
        }
        throw Jvm.rethrow((Throwable)throwable);
    }

    private static boolean tryUpgradeUpdateToWriteLockAndDeregisterWait0(long address) {
        return LOCK.tryUpgradeUpdateToWriteLockAndDeregisterWait((Access)A, null, address + 0L);
    }

    @Override
    public long entries(long address) {
        return (long)OS.memory().readInt(address + 8L) & 0xFFFFFFFFL;
    }

    @Override
    public void entries(long address, long entries) {
        if (entries >= 0x100000000L) {
            throw new IllegalStateException("segment entries overflow: up to 4294967295 supported, " + entries + " given");
        }
        OS.memory().writeInt(address + 8L, (int)entries);
    }

    @Override
    public long deleted(long address) {
        return (long)OS.memory().readInt(address + 24L) & 0xFFFFFFFFL;
    }

    @Override
    public void deleted(long address, long deleted) {
        if (deleted >= 0x100000000L) {
            throw new IllegalStateException("segment deleted entries count overflow: up to 4294967295 supported, " + deleted + " given");
        }
        OS.memory().writeInt(address + 24L, (int)deleted);
    }

    @Override
    public long lowestPossiblyFreeChunk(long address) {
        return (long)OS.memory().readInt(address + 12L) & 0xFFFFFFFFL;
    }

    @Override
    public void lowestPossiblyFreeChunk(long address, long lowestPossiblyFreeChunk) {
        OS.memory().writeInt(address + 12L, (int)lowestPossiblyFreeChunk);
    }

    @Override
    public long nextTierIndex(long address) {
        return OS.memory().readLong(address + 16L);
    }

    @Override
    public void nextTierIndex(long address, long nextTierIndex) {
        OS.memory().writeLong(address + 16L, nextTierIndex);
    }

    @Override
    public void readLock(long address) {
        try {
            if (!BigSegmentHeader.innerTryReadLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS, false)) {
                throw BigSegmentHeader.deadLock();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void readLockInterruptibly(long address) throws InterruptedException {
        if (!this.tryReadLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
            throw BigSegmentHeader.deadLock();
        }
    }

    @Override
    public boolean tryReadLock(long address) {
        return LOCK.tryReadLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryReadLock(long address, long time, TimeUnit unit) throws InterruptedException {
        return BigSegmentHeader.innerTryReadLock(address, time, unit, true);
    }

    @Override
    public boolean tryUpgradeReadToUpdateLock(long address) {
        return LOCK.tryUpgradeReadToUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpgradeReadToWriteLock(long address) {
        return LOCK.tryUpgradeReadToWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public void updateLock(long address) {
        try {
            if (!BigSegmentHeader.innerTryUpdateLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS, false)) {
                throw BigSegmentHeader.deadLock();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void updateLockInterruptibly(long address) throws InterruptedException {
        if (!this.tryUpdateLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
            throw BigSegmentHeader.deadLock();
        }
    }

    @Override
    public boolean tryUpdateLock(long address) {
        return LOCK.tryUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpdateLock(long address, long time, TimeUnit unit) throws InterruptedException {
        return BigSegmentHeader.innerTryUpdateLock(address, time, unit, true);
    }

    @Override
    public void writeLock(long address) {
        try {
            if (!BigSegmentHeader.innerTryWriteLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS, false)) {
                throw BigSegmentHeader.deadLock();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeLockInterruptibly(long address) throws InterruptedException {
        if (!this.tryWriteLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
            throw BigSegmentHeader.deadLock();
        }
    }

    @Override
    public boolean tryWriteLock(long address) {
        return LOCK.tryWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryWriteLock(long address, long time, TimeUnit unit) throws InterruptedException {
        return BigSegmentHeader.innerTryWriteLock(address, time, unit, true);
    }

    @Override
    public void upgradeUpdateToWriteLock(long address) {
        try {
            if (!BigSegmentHeader.innerTryUpgradeUpdateToWriteLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS, false)) {
                throw BigSegmentHeader.deadLock();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void upgradeUpdateToWriteLockInterruptibly(long address) throws InterruptedException {
        if (!this.tryUpgradeUpdateToWriteLock(address, LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
            throw BigSegmentHeader.deadLock();
        }
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address) {
        return LOCK.tryUpgradeUpdateToWriteLock((Access)A, null, address + 0L);
    }

    @Override
    public boolean tryUpgradeUpdateToWriteLock(long address, long time, TimeUnit unit) throws InterruptedException {
        return BigSegmentHeader.innerTryUpgradeUpdateToWriteLock(address, time, unit, true);
    }

    @Override
    public void readUnlock(long address) {
        LOCK.readUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void updateUnlock(long address) {
        LOCK.updateUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeUpdateToReadLock(long address) {
        LOCK.downgradeUpdateToReadLock((Access)A, null, address + 0L);
    }

    @Override
    public void writeUnlock(long address) {
        LOCK.writeUnlock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeWriteToUpdateLock(long address) {
        LOCK.downgradeWriteToUpdateLock((Access)A, null, address + 0L);
    }

    @Override
    public void downgradeWriteToReadLock(long address) {
        LOCK.downgradeWriteToReadLock((Access)A, null, address + 0L);
    }

    @Override
    public void resetLock(long address) {
        LOCK.reset((Access)A, null, address + 0L);
    }

    @Override
    public long resetLockState() {
        return LOCK.resetState();
    }

    @Override
    public long getLockState(long address) {
        return LOCK.getState((ReadAccess)A, null, address + 0L);
    }

    @Override
    public String lockStateToString(long lockState) {
        return LOCK.toString(lockState);
    }

    static {
        int timeout = 60;
        try {
            timeout = Integer.parseInt(System.getProperty("net.openhft.chronicle.map.lockTimeoutSeconds", String.valueOf(timeout)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOCK_TIMEOUT_SECONDS = timeout;
    }
}

