/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.hash;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.sg.Stage;
import net.openhft.sg.Staged;

@Staged
public abstract class Chaining
extends ChainingInterface {
    public final List<ChainingInterface> contextChain;
    public final int indexInContextChain;
    public final ChainingInterface rootContextInThisThread;
    @Stage(value="Used")
    public boolean used;
    @Stage(value="Used")
    private boolean firstContextLockedInThisThread;

    public Chaining(VanillaChronicleMap map) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.initMap(map);
    }

    public Chaining(ChainingInterface rootContextInThisThread, VanillaChronicleMap map) {
        this.contextChain = rootContextInThisThread.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = rootContextInThisThread;
        this.initMap(map);
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public abstract void initMap(VanillaChronicleMap var1);

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used, VanillaChronicleMap map) {
        assert (used);
        this.initMap(map);
        this.firstContextLockedInThisThread = this.rootContextInThisThread.lockContextLocally(map);
        this.used = true;
    }

    void closeUsed() {
        this.used = false;
        if (this.firstContextLockedInThisThread) {
            this.rootContextInThisThread.unlockContextLocally();
        }
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, BiFunction<ChainingInterface, VanillaChronicleMap, T> createChaining, VanillaChronicleMap map) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true, map);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException(map.toIdentityString() + ": More than " + maxNestedContexts + " nested ChronicleHash contexts\n" + "are not supported. Very probable that you simply forgot to close context\n" + "somewhere (recommended to use try-with-resources statement).\n" + "Otherwise this is a bug, please report with this\n" + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this, map);
        context2.initUsed(true, map);
        return (T)context2;
    }
}

