/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ConcurrentFlatBitSetFrame;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.hash.VanillaGlobalMutableState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.ReplicatedGlobalMutableState;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.model.DataValueClasses;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
extends VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R>
implements Replica,
Replica.EntryExternalizable {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    private static final int SIZE_OF_BOOTSTRAP_TIME_STAMP = 8;
    public transient TimeProvider timeProvider;
    private transient byte localIdentifier;
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ATSDirectBitSet modIterSet;
    private transient AtomicReferenceArray<ModificationIterator> modificationIterators;
    private transient long startOfModificationIterators;
    private transient boolean bootstrapOnlyLocalEntries;
    public transient long cleanupTimeout;
    public transient TimeUnit cleanupTimeoutUnit;
    public transient MapRemoteOperations<K, V, R> remoteOperations;
    transient CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R> remoteOpContext;
    transient CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R> remoteItContext;
    transient BitSetFrame mainSegmentsModIterFrameForUpdates;
    transient BitSetFrame mainSegmentsModIterFrameForIteration;
    transient BitSetFrame tierBulkModIterFrameForUpdates;
    transient BitSetFrame tierBulkModIterFrameForIteration;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder, AbstractReplication replication) throws IOException {
        super(builder);
        this.initTransientsFromReplication(replication);
    }

    @Override
    protected VanillaGlobalMutableState createGlobalMutableState() {
        return (VanillaGlobalMutableState)DataValueClasses.newDirectReference(ReplicatedGlobalMutableState.class);
    }

    @Override
    protected ReplicatedGlobalMutableState globalMutableState() {
        return (ReplicatedGlobalMutableState)super.globalMutableState();
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(135L, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.initOwnTransients();
    }

    private void initOwnTransients() {
        this.modificationIterators = new AtomicReferenceArray(135);
        this.closeables = new CopyOnWriteArraySet<Closeable>();
        long mainSegmentsBitSetSize = MemoryUnit.BYTES.toBits(this.modIterBitSetSizeInBytes());
        this.mainSegmentsModIterFrameForUpdates = new SingleThreadedFlatBitSetFrame(mainSegmentsBitSetSize);
        this.mainSegmentsModIterFrameForIteration = new ConcurrentFlatBitSetFrame(mainSegmentsBitSetSize);
        long tierBulkBitSetSize = MemoryUnit.BYTES.toBits(this.tierBulkModIterBitSetSizeInBytes(this.tiersInBulk));
        this.tierBulkModIterFrameForUpdates = new SingleThreadedFlatBitSetFrame(tierBulkBitSetSize);
        this.tierBulkModIterFrameForIteration = new ConcurrentFlatBitSetFrame(tierBulkBitSetSize);
    }

    @Override
    void initTransientsFromBuilder(ChronicleMapBuilder<K, V> builder) {
        super.initTransientsFromBuilder(builder);
        this.remoteOperations = builder.remoteOperations;
        this.timeProvider = builder.timeProvider();
        this.cleanupTimeout = builder.cleanupTimeout;
        this.cleanupTimeoutUnit = builder.cleanupTimeoutUnit;
    }

    void initTransientsFromReplication(AbstractReplication replication) {
        this.localIdentifier = replication.identifier();
        this.bootstrapOnlyLocalEntries = replication.bootstrapOnlyLocalEntries();
        if (this.localIdentifier == -1) {
            throw new IllegalStateException("localIdentifier should not be -1");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initOwnTransients();
    }

    long modIterBitSetSizeInBytes() {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * (long)this.actualSegments);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    @Override
    protected long computeTierBulkInnerOffsetToTiers(long tiersInBulk) {
        return super.computeTierBulkInnerOffsetToTiers(tiersInBulk) + this.tierBulkModIterBitSetSizeInBytes(tiersInBulk) * 136L;
    }

    private long tierBulkModIterBitSetSizeInBytes(long numberOfTiersInBulk) {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * numberOfTiersInBulk);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.actualChunksPerSegment, (long)1024L);
    }

    @Override
    public long mapHeaderInnerSize() {
        return super.mapHeaderInnerSize() + 1024L + (long)this.assignedModIterBitSetSizeInBytes() + this.modIterBitSetSizeInBytes() * 136L;
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    public void onHeaderCreated() {
        long offset = super.mapHeaderInnerSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L);
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes());
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modIterSet = new ATSDirectBitSet(modDelBytes);
    }

    @Override
    protected void zeroOutNewlyMappedChronicleMapBytes() {
        super.zeroOutNewlyMappedChronicleMapBytes();
        this.bytes.zeroOut(super.mapHeaderInnerSize(), this.mapHeaderInnerSize(), true);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    public byte identifier() {
        byte id = this.localIdentifier;
        if (id == 0) {
            throw new IllegalStateException("Replication identifier is not set for this\nreplicated Chronicle Map. This should only be possible if persisted\nreplicated Chronicle Map access from another process/JVM run/after\na transfer from another machine, and replication identifier is not\nspecified when access is configured, e. g. ChronicleMap.of(...).createPersistedTo(existingFile).\nIn this case, replicated Chronicle Map \"doesn't know\" it's identifier,\nand is able to perform simple _read_ operations like map.get(), which\ndoesn't access the identifier. To perform updates, insertions, replication\ntasks, you should configure the current node identifier,\nby `replication(identifier)` method call in ChronicleMapBuilder\nconfiguration chain.");
        }
        assert (id > 0);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModificationIterator acquireModificationIterator(byte remoteIdentifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            ModificationIterator modIter = new ModificationIterator(remoteIdentifier);
            this.modificationIterators.set(remoteIdentifier, modIter);
            this.modIterSet.set((long)remoteIdentifier);
            return modIter;
        }
    }

    public void raiseChange(long tierIndex, long pos, long timestamp) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.acquireModificationIterator((byte)next).raiseChange(tierIndex, pos, timestamp);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public void dropChange(long tierIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.acquireModificationIterator((byte)next).dropChange(tierIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public void moveChange(long oldTierIndex, long oldPos, long newTierIndex, long newPos, long timestamp) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                ModificationIterator modificationIterator = this.acquireModificationIterator((byte)next);
                if (modificationIterator.dropChange(oldTierIndex, oldPos)) {
                    modificationIterator.raiseChange(newTierIndex, newPos, timestamp);
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public boolean isChanged(long tierIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            ModificationIterator modificationIterator = this.acquireModificationIterator((byte)next);
            if (modificationIterator.isChanged(tierIndex, pos)) {
                return true;
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
        return false;
    }

    @Override
    public boolean identifierCheck(@NotNull ReplicableEntry entry, int chronicleId) {
        return entry.originIdentifier() == this.identifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfEntry(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            if (identifier != this.identifier()) {
                int n = 0;
                return n;
            }
            entry.skip(1L);
            long valueSize = this.valueSizeMarshaller.readSize(entry);
            this.alignment.alignPositionAddr(entry);
            long result = entry.position() + valueSize - start;
            assert (result < Integer.MAX_VALUE);
            int n = (int)result + 8;
            return n;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId, long bootstrapTime) {
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.identifier()) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : this.valueSizeMarshaller.minEncodableSize();
        long valuePosition = entry.position();
        destination.writeLong(bootstrapTime);
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        if (identifier == 0) {
            throw new IllegalStateException("Identifier can't be 0");
        }
        destination.writeByte((int)identifier);
        destination.writeBoolean(isDeleted);
        entry.position(keyPosition);
        destination.write((RandomDataInput)entry, entry.position(), keySize);
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.identifier(), (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.identifier(), entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        destination.write((RandomDataInput)entry, entry.position(), valueSize);
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    private ChainingInterface q() {
        CompiledReplicatedMapQueryContext queryContext = (CompiledReplicatedMapQueryContext)this.cxt.get();
        if (queryContext == null) {
            queryContext = new CompiledReplicatedMapQueryContext(this);
            this.cxt.set(queryContext);
        }
        return queryContext;
    }

    public CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R> mapContext() {
        return this.q().getContext(CompiledReplicatedMapQueryContext.class, ci -> new CompiledReplicatedMapQueryContext((ChainingInterface)ci, this));
    }

    private CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R> remoteOpContext() {
        if (this.remoteOpContext == null) {
            this.remoteOpContext = (CompiledReplicatedMapQueryContext)this.q();
        }
        assert (!this.remoteOpContext.usedInit());
        this.remoteOpContext.initUsed(true);
        return this.remoteOpContext;
    }

    private CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R> remoteItContext() {
        if (this.remoteItContext == null) {
            this.remoteItContext = (CompiledReplicatedMapIterationContext)this.i();
        }
        assert (!this.remoteItContext.usedInit());
        this.remoteItContext.initUsed(true);
        return this.remoteItContext;
    }

    @Override
    public void readExternalEntry(@NotNull Bytes source) {
        try (QueryContextInterface remoteOpContext = this.mapContext();){
            ((CompiledReplicatedMapQueryContext)remoteOpContext).initReplicationInput(source);
            ((CompiledReplicatedMapQueryContext)remoteOpContext).processReplicatedEvent();
        }
    }

    private ChainingInterface i() {
        CompiledReplicatedMapIterationContext iterContext = (CompiledReplicatedMapIterationContext)this.cxt.get();
        if (iterContext == null) {
            iterContext = new CompiledReplicatedMapIterationContext(this);
            this.cxt.set(iterContext);
        }
        return iterContext;
    }

    public CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R> iterationContext() {
        return this.i().getContext(CompiledReplicatedMapIterationContext.class, ci -> new CompiledReplicatedMapIterationContext((ChainingInterface)ci, this));
    }

    class ModificationIterator
    implements Replica.ModificationIterator {
        private Replica.ModificationNotifier modificationNotifier;
        private final long mainSegmentsChangesBitSetAddr;
        private final int segmentIndexShift;
        private final long posMask;
        private final long offsetToBitSetWithinATierBulk;
        private AtomicLong bootStrapTimeStamp = new AtomicLong();
        private long lastBootStrapTimeStamp;
        private volatile long position;
        private int iterationMainSegmentsAreaOrTierBulk;
        private long tierBulkBitSetAddr;

        public ModificationIterator(int remoteIdentifier) {
            this.lastBootStrapTimeStamp = ReplicatedChronicleMap.this.timeProvider.currentTime();
            this.position = -1L;
            this.iterationMainSegmentsAreaOrTierBulk = -1;
            this.tierBulkBitSetAddr = 0L;
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.mainSegmentsChangesBitSetAddr = ReplicatedChronicleMap.this.ms.address() + ReplicatedChronicleMap.this.startOfModificationIterators + (long)remoteIdentifier * ReplicatedChronicleMap.this.modIterBitSetSizeInBytes();
            Access.nativeAccess().zeroOut(null, this.mainSegmentsChangesBitSetAddr, ReplicatedChronicleMap.this.modIterBitSetSizeInBytes());
            this.offsetToBitSetWithinATierBulk = (long)remoteIdentifier * ReplicatedChronicleMap.this.tierBulkModIterBitSetSizeInBytes(ReplicatedChronicleMap.this.tiersInBulk);
        }

        public ModificationIterator(int remoteIdentifier, Replica.ModificationNotifier notifier) {
            this(remoteIdentifier);
            this.setModificationNotifier(notifier);
        }

        @Override
        public void setModificationNotifier(Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
        }

        private long combine(long tierIndex, long pos) {
            long tierIndexMinusOne = tierIndex - 1L;
            if (tierIndexMinusOne < (long)ReplicatedChronicleMap.this.actualSegments) {
                return tierIndexMinusOne << this.segmentIndexShift | pos;
            }
            return this.combineExtraTier(tierIndexMinusOne, pos);
        }

        private long combineExtraTier(long tierIndexMinusOne, long pos) {
            long extraTierIndex = tierIndexMinusOne - (long)ReplicatedChronicleMap.this.actualSegments;
            long tierIndexOffsetWithinBulk = extraTierIndex & ReplicatedChronicleMap.this.tiersInBulk - 1L;
            return tierIndexOffsetWithinBulk << this.segmentIndexShift | pos;
        }

        void raiseChange(long tierIndex, long pos, long timestamp) {
            LOG.debug("raise change: id {}, tierIndex {}, pos {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, tierIndex, pos});
            long bitIndex = this.combine(tierIndex, pos);
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                ReplicatedChronicleMap.this.mainSegmentsModIterFrameForUpdates.set(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, bitIndex);
            } else {
                this.raiseExtraTierChange(tierIndex, bitIndex);
            }
            this.bootStrapTimeStamp.compareAndSet(0L, timestamp);
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        private void raiseExtraTierChange(long tierIndex, long bitIndex) {
            tierIndex = tierIndex - (long)ReplicatedChronicleMap.this.actualSegments - 1L;
            long bulkIndex = tierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk;
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get((int)bulkIndex);
            long bitSetAddr = tierBulkData.langBytes.address() + tierBulkData.offset + this.offsetToBitSetWithinATierBulk;
            ReplicatedChronicleMap.this.tierBulkModIterFrameForUpdates.set(Access.nativeAccess(), null, bitSetAddr, bitIndex);
        }

        boolean dropChange(long tierIndex, long pos) {
            LOG.debug("drop change: id {}, tierIndex {}, pos {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, tierIndex, pos});
            long bitIndex = this.combine(tierIndex, pos);
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                return ReplicatedChronicleMap.this.mainSegmentsModIterFrameForUpdates.clearIfSet(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, bitIndex);
            }
            return this.dropExtraTierChange(tierIndex, bitIndex);
        }

        private boolean dropExtraTierChange(long tierIndex, long bitIndex) {
            tierIndex = tierIndex - (long)ReplicatedChronicleMap.this.actualSegments - 1L;
            long bulkIndex = tierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk;
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get((int)bulkIndex);
            long bitSetAddr = tierBulkData.langBytes.address() + tierBulkData.offset + this.offsetToBitSetWithinATierBulk;
            return ReplicatedChronicleMap.this.tierBulkModIterFrameForUpdates.clearIfSet(Access.nativeAccess(), null, bitSetAddr, bitIndex);
        }

        boolean isChanged(long tierIndex, long pos) {
            long bitIndex = this.combine(tierIndex, pos);
            if (tierIndex <= (long)ReplicatedChronicleMap.this.actualSegments) {
                return ReplicatedChronicleMap.this.mainSegmentsModIterFrameForUpdates.isSet(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, bitIndex);
            }
            return this.isChangedExtraTier(tierIndex, bitIndex);
        }

        private boolean isChangedExtraTier(long tierIndex, long bitIndex) {
            long extraTierIndex = tierIndex - (long)ReplicatedChronicleMap.this.actualSegments - 1L;
            long bulkIndex = extraTierIndex >> ReplicatedChronicleMap.this.log2TiersInBulk;
            VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get((int)bulkIndex);
            long bitSetAddr = tierBulkData.langBytes.address() + tierBulkData.offset + this.offsetToBitSetWithinATierBulk;
            return ReplicatedChronicleMap.this.tierBulkModIterFrameForUpdates.isSet(Access.nativeAccess(), null, bitSetAddr, bitIndex);
        }

        @Override
        public boolean hasNext() {
            return this.nextPosition() >= 0L;
        }

        private long nextPosition() {
            long position = this.position;
            boolean allBitSetsScannedFromTheStart = false;
            while (!allBitSetsScannedFromTheStart) {
                long nextPos;
                if (this.iterationMainSegmentsAreaOrTierBulk == -1) {
                    allBitSetsScannedFromTheStart = position < 0L;
                    nextPos = ReplicatedChronicleMap.this.mainSegmentsModIterFrameForIteration.nextSetBit(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, position + 1L);
                    if (nextPos != -1L) {
                        return nextPos;
                    }
                    position = -1L;
                    this.position = -1L;
                    this.iterationMainSegmentsAreaOrTierBulk = 0;
                }
                while (this.iterationMainSegmentsAreaOrTierBulk < ReplicatedChronicleMap.this.globalMutableState().getAllocatedExtraTierBulks()) {
                    VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(this.iterationMainSegmentsAreaOrTierBulk);
                    this.tierBulkBitSetAddr = tierBulkData.langBytes.address() + tierBulkData.offset + this.offsetToBitSetWithinATierBulk;
                    nextPos = ReplicatedChronicleMap.this.tierBulkModIterFrameForIteration.nextSetBit(Access.nativeAccess(), null, this.tierBulkBitSetAddr, position + 1L);
                    if (nextPos != -1L) {
                        return nextPos;
                    }
                    ++this.iterationMainSegmentsAreaOrTierBulk;
                    position = -1L;
                    this.position = -1L;
                }
                this.iterationMainSegmentsAreaOrTierBulk = -1;
                position = -1L;
                this.position = -1L;
                this.bootStrapTimeStamp.set(0L);
            }
            return -1L;
        }

        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            while (true) {
                long position;
                if ((position = this.nextPosition()) == -1L) {
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                int segmentIndexOrTierIndexOffsetWithinBulk = (int)(position >>> this.segmentIndexShift);
                IterationContext context = ReplicatedChronicleMap.this.iterationContext();
                Throwable throwable = null;
                try {
                    if (this.iterationMainSegmentsAreaOrTierBulk < 0) {
                        ((CompiledReplicatedMapIterationContext)context).initSegmentIndex(segmentIndexOrTierIndexOffsetWithinBulk);
                    } else {
                        VanillaChronicleHash.TierBulkData tierBulkData = (VanillaChronicleHash.TierBulkData)ReplicatedChronicleMap.this.tierBulkOffsets.get(this.iterationMainSegmentsAreaOrTierBulk);
                        long tierBaseAddr = ReplicatedChronicleMap.this.tierAddr(tierBulkData, segmentIndexOrTierIndexOffsetWithinBulk);
                        long tierCountersAreaAddr = tierBaseAddr + ReplicatedChronicleMap.this.segmentHashLookupOuterSize;
                        ((CompiledReplicatedMapIterationContext)context).initSegmentIndex(TierCountersArea.segmentIndex(tierCountersAreaAddr));
                        int tier = TierCountersArea.tier(tierCountersAreaAddr);
                        long tierIndex = ReplicatedChronicleMap.this.actualSegments + (this.iterationMainSegmentsAreaOrTierBulk << ReplicatedChronicleMap.this.log2TiersInBulk) + segmentIndexOrTierIndexOffsetWithinBulk + 1;
                        ((CompiledReplicatedMapIterationContext)context).initSegmentTier(tier, tierIndex, tierBaseAddr);
                    }
                    ((CompiledReplicatedMapIterationContext)context).updateLock().lock();
                    if (!this.changesForUpdatesGet(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    ((CompiledReplicatedMapIterationContext)context).readExistingEntry(segmentPos);
                    if (entryCallback.shouldBeIgnored((ReplicableEntry)((Object)context), chronicleId)) {
                        this.changesForUpdatesClear(position);
                        continue;
                    }
                    ((CompiledReplicatedMapIterationContext)context).segmentBytes().limit(((CompiledReplicatedMapIterationContext)context).valueOffset() + ((CompiledReplicatedMapIterationContext)context).valueSize());
                    ((CompiledReplicatedMapIterationContext)context).segmentBytes().position(((CompiledReplicatedMapIterationContext)context).keySizeOffset());
                    boolean success = entryCallback.onEntry((Bytes)((CompiledReplicatedMapIterationContext)context).segmentBytes(), chronicleId, this.bootStrapTimeStamp());
                    entryCallback.onAfterEntry();
                    if (success) {
                        this.changesForUpdatesClear(position);
                    }
                    boolean bl = success;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            ((CompiledReplicatedMapIterationContext)context).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((CompiledReplicatedMapIterationContext)context).close();
                    continue;
                }
                break;
            }
        }

        private boolean changesForUpdatesGet(long position) {
            if (this.iterationMainSegmentsAreaOrTierBulk < 0) {
                return ReplicatedChronicleMap.this.mainSegmentsModIterFrameForUpdates.get(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, position);
            }
            return ReplicatedChronicleMap.this.tierBulkModIterFrameForUpdates.get(Access.nativeAccess(), null, this.tierBulkBitSetAddr, position);
        }

        private void changesForUpdatesClear(long position) {
            if (this.iterationMainSegmentsAreaOrTierBulk < 0) {
                ReplicatedChronicleMap.this.mainSegmentsModIterFrameForUpdates.clear(Access.nativeAccess(), null, this.mainSegmentsChangesBitSetAddr, position);
            } else {
                ReplicatedChronicleMap.this.tierBulkModIterFrameForUpdates.clear(Access.nativeAccess(), null, this.tierBulkBitSetAddr, position);
            }
        }

        private long bootStrapTimeStamp() {
            long result;
            long timeStamp = this.bootStrapTimeStamp.get();
            this.lastBootStrapTimeStamp = result = timeStamp == 0L ? this.lastBootStrapTimeStamp : timeStamp;
            return result;
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            try (IterationContext c = ReplicatedChronicleMap.this.iterationContext();){
                boolean debugEnabled = LOG.isDebugEnabled();
                for (int segmentIndex = 0; segmentIndex < ReplicatedChronicleMap.this.actualSegments; ++segmentIndex) {
                    ((CompiledReplicatedMapIterationContext)c).initSegmentIndex(segmentIndex);
                    ((CompiledReplicatedMapIterationContext)c).forEachSegmentReplicableEntry(arg_0 -> this.lambda$dirtyEntries$5(debugEnabled, (CompiledReplicatedMapIterationContext)c, fromTimeStamp, arg_0));
                }
            }
        }

        private /* synthetic */ void lambda$dirtyEntries$5(boolean bl, CompiledReplicatedMapIterationContext compiledReplicatedMapIterationContext, long l, ReplicableEntry e) {
            if (bl) {
                LOG.debug("Bootstrap entry: id {}, key {}, value {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, compiledReplicatedMapIterationContext.key(), compiledReplicatedMapIterationContext.value()});
            }
            if (bl) {
                LOG.debug("Bootstrap decision: bs ts: {}, entry ts: {}, entry id: {}, local id: {}", new Object[]{l, e.originTimestamp(), e.originIdentifier(), ReplicatedChronicleMap.this.localIdentifier});
            }
            if (!(e.originTimestamp() < l || ReplicatedChronicleMap.this.bootstrapOnlyLocalEntries && e.originIdentifier() != ReplicatedChronicleMap.this.localIdentifier)) {
                this.raiseChange(compiledReplicatedMapIterationContext.tierIndex(), compiledReplicatedMapIterationContext.pos(), compiledReplicatedMapIterationContext.timestamp());
            }
        }
    }
}

