/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.Objects;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.PublicMultiStoreBytes;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.ReadLock;
import net.openhft.chronicle.hash.impl.stage.entry.UpdateLock;
import net.openhft.chronicle.hash.impl.stage.entry.WriteLock;
import net.openhft.chronicle.hash.impl.stage.hash.Chaining;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class SegmentStages
implements SegmentLock,
LocksInterface {
    @StageRef
    Chaining chaining;
    @StageRef
    public VanillaChronicleHashHolder<?, ?, ?> hh;
    @StageRef
    public CheckOnEachPublicOperation checkOnEachPublicOperation;
    public int segmentIndex = -1;
    @Stage(value="SegmentHeader")
    long segmentHeaderAddress;
    @Stage(value="SegmentHeader")
    SegmentHeader segmentHeader = null;
    @Stage(value="Locks")
    public LocksInterface rootContextLockedOnThisSegment = null;
    @Stage(value="Locks")
    public boolean nestedContextsLockedOnSameSegment;
    @Stage(value="Locks")
    public int latestSameThreadSegmentModCount;
    @Stage(value="Locks")
    public int contextModCount;
    @Stage(value="Locks")
    LocksInterface nextNode;
    @Stage(value="Locks")
    LocalLockState localLockState;
    @Stage(value="Locks")
    int totalReadLockCount;
    @Stage(value="Locks")
    int totalUpdateLockCount;
    @Stage(value="Locks")
    int totalWriteLockCount;
    @StageRef
    public ReadLock innerReadLock;
    @StageRef
    public UpdateLock innerUpdateLock;
    @StageRef
    public WriteLock innerWriteLock;
    @Stage(value="SegmentTier")
    public int segmentTier = -1;
    @Stage(value="SegmentTier")
    public long tierIndex;
    @Stage(value="SegmentTier")
    public long segmentBaseAddr;
    @Stage(value="Segment")
    public final PublicMultiStoreBytes segmentBytes = new PublicMultiStoreBytes();
    @Stage(value="Segment")
    public final PointerBytesStore segmentBS = new PointerBytesStore();
    @Stage(value="Segment")
    public final ReusableBitSet freeList;
    @Stage(value="Segment")
    long entrySpaceOffset;

    public SegmentStages() {
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.hh.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.entrySpaceOffset = 0L;
    }

    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public abstract boolean segmentIndexInit();

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.hh.h().segmentHeaderAddress(this.segmentIndex);
        this.segmentHeader = BigSegmentHeader.INSTANCE;
    }

    public long entries() {
        return this.segmentHeader.size(this.segmentHeaderAddress);
    }

    public void entries(long size) {
        this.segmentHeader.size(this.segmentHeaderAddress, size);
    }

    long nextPosToSearchFrom() {
        if (this.segmentTier == 0) {
            return this.segmentHeader.nextPosToSearchFrom(this.segmentHeaderAddress);
        }
        return this.nextPosToSearchFromTiered();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        if (this.segmentTier == 0) {
            this.segmentHeader.nextPosToSearchFrom(this.segmentHeaderAddress, nextPosToSearchFrom);
        } else {
            this.nextPosToSearchFromTiered(nextPosToSearchFrom);
        }
    }

    public long deleted() {
        return this.segmentHeader.deleted(this.segmentHeaderAddress);
    }

    public void deleted(long deleted) {
        this.segmentHeader.deleted(this.segmentHeaderAddress, deleted);
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    @Override
    @Stage(value="Locks")
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Stage(value="Locks")
    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    @Override
    @Stage(value="Locks")
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    @Stage(value="Locks")
    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalReadLockCount(int change) {
        return this.totalReadLockCount += change;
    }

    @Stage(value="Locks")
    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalUpdateLockCount(int change) {
        return this.totalUpdateLockCount += change;
    }

    @Stage(value="Locks")
    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    @Override
    @Stage(value="Locks")
    public int changeAndGetTotalWriteLockCount(int change) {
        return this.totalWriteLockCount += change;
    }

    @Stage(value="Locks")
    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    @Stage(value="Locks")
    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    @Stage(value="Locks")
    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    @Stage(value="Locks")
    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    @Stage(value="Locks")
    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    @Stage(value="Locks")
    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    @Override
    public abstract boolean locksInit();

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.chaining.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.chaining.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
    }

    @Stage(value="Locks")
    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.chaining.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    void closeLocks() {
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    @Stage(value="Locks")
    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    @Stage(value="Locks")
    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = this.decrementRead();
                if (newTotalReadLockCount == 0) {
                    if (this.updateZero() && this.writeZero()) {
                        this.segmentHeader.readUnlock(this.segmentHeaderAddress);
                    }
                } else assert (newTotalReadLockCount > 0) : "read underflow";
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (this.writeZero()) {
                        if (this.readZero()) {
                            this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                        } else {
                            this.segmentHeader.downgradeUpdateToReadLock(this.segmentHeaderAddress);
                        }
                    }
                } else assert (newTotalUpdateLockCount > 0) : "update underflow";
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.updateZero()) {
                        this.segmentHeader.downgradeWriteToUpdateLock(this.segmentHeaderAddress);
                        break;
                    }
                    if (!this.readZero()) {
                        this.segmentHeader.downgradeWriteToReadLock(this.segmentHeaderAddress);
                        break;
                    }
                    this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
    }

    @Stage(value="Locks")
    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((KeySearch)((Object)innermostContextOnThisSegment)).inputKey, ((KeySearch)((Object)this)).inputKey)) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    @Stage(value="Locks")
    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while (true) {
            assert (prevContext.nextNode() != null);
            if (prevContext.nextNode() == this) break;
            prevContext = prevContext.nextNode();
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    @Stage(value="Locks")
    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    @Stage(value="Locks")
    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader.readUnlock(this.segmentHeaderAddress);
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader.updateUnlock(this.segmentHeaderAddress);
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader.writeUnlock(this.segmentHeaderAddress);
            }
        }
    }

    @Stage(value="Locks")
    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.chaining.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException("Update or Write locking is forbidden in the contextof locked iteration context");
        }
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.chaining.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.chaining.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    @Stage(value="Locks")
    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.chaining.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.chaining.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.chaining.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment.totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment.totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment.totalWriteLockCount();
        return s;
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex + 1;
        this.segmentBaseAddr = this.hh.h().segmentBaseAddr(this.segmentIndex);
        this.segmentTier = 0;
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.segmentBaseAddr = this.hh.h().tierIndexToBaseAddr(tierIndex);
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.segmentTier = tier;
        this.tierIndex = tierIndex;
        this.segmentBaseAddr = tierBaseAddr;
    }

    public long tierCountersAreaAddr() {
        return this.segmentBaseAddr + this.hh.h().segmentHashLookupOuterSize;
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public long nextPosToSearchFromTiered() {
        return TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr());
    }

    public void nextPosToSearchFromTiered(long nextPosToSearchFrom) {
        TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr(), nextPosToSearchFrom);
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void nextTier() {
        VanillaChronicleHash<?, ?, ?, ?, ?, ?> h = this.hh.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex, this.segmentTier + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex;
            this.initSegmentTier(this.segmentTier + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.segmentTier + 1, nextTierIndex);
        }
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void prevTier() {
        if (this.segmentTier == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.segmentTier - 1, this.prevTierIndex());
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    public void goToFirstTier() {
        while (this.segmentTier != 0) {
            this.prevTier();
        }
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash<?, ?, ?, ?, ?, ?> h = this.hh.h();
        PublicMultiStoreBytes segmentBytes = this.segmentBytes;
        segmentBytes.setBytesOffset(h.tierBytes(this.tierIndex), h.tierBytesOffset(this.tierIndex));
        long segmentBaseAddr = this.segmentBaseAddr;
        this.segmentBS.set(segmentBaseAddr, h.segmentSize);
        long freeListOffset = h.segmentHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.segmentFreeListOuterSize + (long)h.segmentEntrySpaceInnerOffset;
    }

    void closeSegment() {
        this.entrySpaceOffset = 0L;
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<?, ?, ?, ?, ?, ?> h = this.hh.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList.setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList.clearRange(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList.setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList.clearRange(ret, h.actualChunksPerSegment);
                }
                return -1L;
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList.isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList.clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.hh.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }
}

