/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.replication;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashAbsentEntry;
import net.openhft.chronicle.hash.replication.AcceptanceDecision;
import net.openhft.chronicle.hash.replication.DefaultEventualConsistencyStrategy;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;

public interface MapRemoteOperations<K, V, R> {
    default public void remove(MapRemoteQueryContext<K, V, R> q) {
        MapEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)entry), q) == AcceptanceDecision.ACCEPT) {
                q.remove(entry);
                ReplicableEntry replicableAbsentEntry = (ReplicableEntry)((Object)q.absentEntry());
                replicableAbsentEntry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                replicableAbsentEntry.dropChanged();
            }
        } else {
            ReplicableEntry replicableAbsentEntry;
            HashAbsentEntry absentEntry = q.absentEntry();
            if (!(absentEntry instanceof ReplicableEntry)) {
                absentEntry.doInsert(q.dummyZeroValue());
                q.entry().doRemove();
                replicableAbsentEntry = (ReplicableEntry)((Object)q.absentEntry());
            } else {
                replicableAbsentEntry = (ReplicableEntry)((Object)absentEntry);
                if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(replicableAbsentEntry, q) == AcceptanceDecision.DISCARD) {
                    return;
                }
            }
            replicableAbsentEntry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
            replicableAbsentEntry.dropChanged();
        }
    }

    default public void put(MapRemoteQueryContext<K, V, R> q, Data<V> newValue) {
        MapEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)entry), q) == AcceptanceDecision.ACCEPT) {
                q.replaceValue(entry, newValue);
                entry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                entry.dropChanged();
            }
        } else {
            HashAbsentEntry absentEntry = q.absentEntry();
            if (!(absentEntry instanceof ReplicableEntry) || DefaultEventualConsistencyStrategy.decideOnRemoteModification((ReplicableEntry)((Object)absentEntry), q) == AcceptanceDecision.ACCEPT) {
                q.insert((MapAbsentEntry<K, V>)absentEntry, newValue);
                entry = q.entry();
                entry.updateOrigin(q.remoteIdentifier(), q.remoteTimestamp());
                entry.dropChanged();
            }
        }
    }
}

