/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public final class IntegerMarshaller
extends Enum<IntegerMarshaller>
implements BytesInterop<Integer>,
BytesReader<Integer>,
SizeMarshaller {
    public static final /* enum */ IntegerMarshaller INSTANCE = new IntegerMarshaller();
    private static final /* synthetic */ IntegerMarshaller[] $VALUES;

    public static IntegerMarshaller[] values() {
        return (IntegerMarshaller[])$VALUES.clone();
    }

    public static IntegerMarshaller valueOf(String name) {
        return Enum.valueOf(IntegerMarshaller.class, name);
    }

    @Override
    public long size(@NotNull Integer e) {
        return 4L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public long minEncodableSize() {
        return 4L;
    }

    @Override
    public int minSizeEncodingSize() {
        return 0;
    }

    @Override
    public int maxSizeEncodingSize() {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
        assert (size == 4L);
    }

    @Override
    public boolean startsWith(@NotNull Bytes bytes, @NotNull Integer e) {
        return e.intValue() == bytes.readInt(bytes.position());
    }

    @Override
    public boolean equivalent(@NotNull Integer a, @NotNull Integer b) {
        return a.intValue() == b.intValue();
    }

    @Override
    public long hash(@NotNull LongHashFunction hashFunction, @NotNull Integer e) {
        return hashFunction.hashInt(e);
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Integer e) {
        bytes.writeInt(e.intValue());
    }

    @Override
    public long readSize(Bytes bytes) {
        return 4L;
    }

    @Override
    @NotNull
    public Integer read(@NotNull Bytes bytes, long size) {
        return bytes.readInt();
    }

    @Override
    @NotNull
    public Integer read(@NotNull Bytes bytes, long size, Integer toReuse) {
        return bytes.readInt();
    }

    static {
        $VALUES = new IntegerMarshaller[]{INSTANCE};
    }
}

