/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.lang.io.NativeBytes;

public final class IntCompactOffHeapLinearHashTable
extends CompactOffHeapLinearHashTable {
    private static final long SCALE = 4L;

    IntCompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        super(h);
    }

    @Override
    long indexToPos(long index) {
        return index * 4L;
    }

    @Override
    public long step(long pos) {
        return pos + 4L & this.capacityMask2;
    }

    @Override
    public long stepBack(long pos) {
        return pos - 4L & this.capacityMask2;
    }

    @Override
    public long readEntry(long addr, long pos) {
        return NativeBytes.UNSAFE.getInt(addr + pos);
    }

    @Override
    public void writeEntryVolatile(long addr, long pos, long prevEntry, long key, long value) {
        NativeBytes.UNSAFE.putIntVolatile(null, addr + pos, (int)this.entry(key, value));
    }

    @Override
    void writeEntry(long addr, long pos, long prevEntry, long anotherEntry) {
        NativeBytes.UNSAFE.putInt(addr + pos, (int)anotherEntry);
    }

    @Override
    void clearEntry(long addr, long pos, long prevEntry) {
        NativeBytes.UNSAFE.putInt(addr + pos, 0);
    }
}

