/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.lang.MemoryUnit;

public abstract class CompactOffHeapLinearHashTable {
    public static final int MAX_SEGMENT_CHUNKS = 0x40000000;
    public static final int MAX_SEGMENT_ENTRIES = 0x20000000;
    public static final long UNSET_KEY = 0L;
    public static final long UNSET_ENTRY = 0L;
    private final long capacityMask;
    final long capacityMask2;
    private final int keyBits;
    private final long keyMask;
    private final long valueMask;

    public static int valueBits(long actualChunksPerSegment) {
        return 64 - Long.numberOfLeadingZeros(actualChunksPerSegment - 1L);
    }

    public static int keyBits(long entriesPerSegment, int valueBits) {
        int minKeyBits = 64 - Long.numberOfLeadingZeros(entriesPerSegment - 1L);
        int actualEntryBits = (int)MemoryUnit.BYTES.align((long)((minKeyBits += 3) + valueBits), MemoryUnit.BITS);
        return actualEntryBits - valueBits;
    }

    public static int entrySize(int keyBits, int valueBits) {
        int entrySize = (int)MemoryUnit.BYTES.alignAndConvert((long)(keyBits + valueBits), MemoryUnit.BITS);
        if (entrySize <= 4) {
            return 4;
        }
        if (entrySize <= 8) {
            return 8;
        }
        return entrySize;
    }

    public static long capacityFor(long entriesPerSegment) {
        if (entriesPerSegment < 0L) {
            throw new IllegalArgumentException("entriesPerSegment should be positive");
        }
        long capacity = Maths.nextPower2((long)entriesPerSegment, (long)64L);
        if ((double)entriesPerSegment / (double)capacity > 0.6666666666666666) {
            capacity <<= 1;
        }
        return capacity;
    }

    public static long mask(int bits) {
        return (1L << bits) - 1L;
    }

    CompactOffHeapLinearHashTable(long capacity, int entrySize, int keyBits, int valueBits) {
        this.capacityMask = capacity - 1L;
        this.capacityMask2 = this.capacityMask * (long)entrySize;
        this.keyBits = keyBits;
        this.keyMask = CompactOffHeapLinearHashTable.mask(keyBits);
        this.valueMask = CompactOffHeapLinearHashTable.mask(valueBits);
    }

    CompactOffHeapLinearHashTable(VanillaChronicleHash h) {
        this(h.segmentHashLookupCapacity, h.segmentHashLookupEntrySize, h.segmentHashLookupKeyBits, h.segmentHashLookupValueBits);
    }

    abstract long indexToPos(long var1);

    public long maskUnsetKey(long key) {
        return (key &= this.keyMask) != 0L ? key : this.keyMask;
    }

    public void checkValueForPut(long value) {
        assert ((value & (this.valueMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) : "Value out of range, was " + value;
    }

    public boolean empty(long entry) {
        return entry == 0L;
    }

    public long key(long entry) {
        return entry & this.keyMask;
    }

    public long value(long entry) {
        return entry >>> this.keyBits & this.valueMask;
    }

    long entry(long key, long value) {
        return key | value << this.keyBits;
    }

    public long hlPos(long key) {
        return this.indexToPos(key & this.capacityMask);
    }

    public abstract long step(long var1);

    public abstract long stepBack(long var1);

    public abstract long readEntry(long var1, long var3);

    public abstract void writeEntryVolatile(long var1, long var3, long var5, long var7, long var9);

    public void putValueVolatile(long addr, long pos, long value) {
        this.checkValueForPut(value);
        long currentEntry = this.readEntry(addr, pos);
        this.writeEntryVolatile(addr, pos, currentEntry, this.key(currentEntry), value);
    }

    abstract void writeEntry(long var1, long var3, long var5, long var7);

    abstract void clearEntry(long var1, long var3, long var5);

    public long remove(long addr, long posToRemove) {
        long entryToShift;
        long entryToRemove = this.readEntry(addr, posToRemove);
        long posToShift = posToRemove;
        while (!this.empty(entryToShift = this.readEntry(addr, posToShift = this.step(posToShift)))) {
            boolean cond2;
            long insertPos = this.hlPos(this.key(entryToShift));
            boolean cond1 = insertPos <= posToRemove;
            boolean bl = cond2 = posToRemove <= posToShift;
            if ((!cond1 || !cond2) && (posToShift >= insertPos || !cond1 && !cond2)) continue;
            this.writeEntry(addr, posToRemove, entryToRemove, entryToShift);
            posToRemove = posToShift;
            entryToRemove = entryToShift;
        }
        this.clearEntry(addr, posToRemove, entryToRemove);
        return posToRemove;
    }
}

