/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashInstanceBuilder;
import net.openhft.chronicle.hash.replication.SingleChronicleHashReplication;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.DummyValue;
import net.openhft.chronicle.hash.serialization.internal.DummyValueMarshaller;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.SetFromMap;
import net.openhft.chronicle.set.SetInstanceBuilder;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;

public final class ChronicleSetBuilder<K>
implements ChronicleHashBuilder<K, ChronicleSet<K>, ChronicleSetBuilder<K>> {
    private ChronicleMapBuilder<K, DummyValue> chronicleMapBuilder;

    ChronicleSetBuilder(Class<K> keyClass) {
        this.chronicleMapBuilder = ChronicleMapBuilder.of(keyClass, DummyValue.class).valueMarshallers(DummyValueMarshaller.INSTANCE, DummyValueMarshaller.INSTANCE).valueSizeMarshaller(DummyValueMarshaller.INSTANCE);
    }

    public static <K> ChronicleSetBuilder<K> of(Class<K> keyClass) {
        return new ChronicleSetBuilder<K>(keyClass);
    }

    @Override
    public ChronicleSetBuilder<K> clone() {
        try {
            ChronicleSetBuilder result = (ChronicleSetBuilder)super.clone();
            result.chronicleMapBuilder = this.chronicleMapBuilder.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleSetBuilder<K> actualSegments(int actualSegments) {
        this.chronicleMapBuilder.actualSegments(actualSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> minSegments(int minSegments) {
        this.chronicleMapBuilder.minSegments(minSegments);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> entriesPerSegment(long entriesPerSegment) {
        this.chronicleMapBuilder.entriesPerSegment(entriesPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> actualChunksPerSegment(long actualChunksPerSegment) {
        this.chronicleMapBuilder.actualChunksPerSegment(actualChunksPerSegment);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> averageKeySize(double averageKeySize) {
        this.chronicleMapBuilder.averageKeySize(averageKeySize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> constantKeySizeBySample(K sampleKey) {
        this.chronicleMapBuilder.constantKeySizeBySample((Object)sampleKey);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> actualChunkSize(int actualChunkSize) {
        this.chronicleMapBuilder.actualChunkSize(actualChunkSize);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> maxChunksPerEntry(int maxChunksPerEntry) {
        this.chronicleMapBuilder.maxChunksPerEntry(maxChunksPerEntry);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> entries(long entries) {
        this.chronicleMapBuilder.entries(entries);
        return this;
    }

    public String toString() {
        return " ChronicleSetBuilder{chronicleMapBuilder=" + this.chronicleMapBuilder + '}';
    }

    public boolean equals(Object o) {
        return o instanceof ChronicleSetBuilder && this.chronicleMapBuilder.equals(((ChronicleSetBuilder)o).chronicleMapBuilder);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public ChronicleSetBuilder<K> timeProvider(TimeProvider timeProvider) {
        this.chronicleMapBuilder.timeProvider(timeProvider);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> bytesMarshallerFactory(BytesMarshallerFactory bytesMarshallerFactory) {
        this.chronicleMapBuilder.bytesMarshallerFactory(bytesMarshallerFactory);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> objectSerializer(ObjectSerializer objectSerializer) {
        this.chronicleMapBuilder.objectSerializer(objectSerializer);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keyMarshaller(@NotNull BytesMarshaller<? super K> keyMarshaller) {
        this.chronicleMapBuilder.keyMarshaller((BytesMarshaller)keyMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keyMarshallers(@NotNull BytesWriter<? super K> keyWriter, @NotNull BytesReader<K> keyReader) {
        this.chronicleMapBuilder.keyMarshallers(keyWriter, (BytesReader)keyReader);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.chronicleMapBuilder.keySizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> keyDeserializationFactory(@NotNull ObjectFactory<? extends K> keyDeserializationFactory) {
        this.chronicleMapBuilder.keyDeserializationFactory((ObjectFactory)keyDeserializationFactory);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> immutableKeys() {
        this.chronicleMapBuilder.immutableKeys();
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> replication(SingleChronicleHashReplication replication) {
        this.chronicleMapBuilder.replication(replication);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> replication(byte identifier, TcpTransportAndNetworkConfig tcpTransportAndNetwork) {
        this.chronicleMapBuilder.replication(identifier, tcpTransportAndNetwork);
        return this;
    }

    @Override
    public ChronicleSetBuilder<K> replication(byte identifier) {
        this.chronicleMapBuilder.replication(identifier);
        return this;
    }

    @Override
    public ChronicleHashInstanceBuilder<ChronicleSet<K>> instance() {
        return new SetInstanceBuilder(this.chronicleMapBuilder.instance());
    }

    @Override
    public ChronicleSet<K> create() {
        ChronicleHash map = this.chronicleMapBuilder.create();
        return new SetFromMap(map);
    }

    @Override
    public ChronicleSet<K> createPersistedTo(File file) throws IOException {
        ChronicleHash map = this.chronicleMapBuilder.createPersistedTo(file);
        return new SetFromMap(map);
    }
}

