/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public final class DoubleMarshaller
extends Enum<DoubleMarshaller>
implements BytesInterop<Double>,
BytesReader<Double>,
SizeMarshaller {
    public static final /* enum */ DoubleMarshaller INSTANCE = new DoubleMarshaller();
    private static final /* synthetic */ DoubleMarshaller[] $VALUES;

    public static DoubleMarshaller[] values() {
        return (DoubleMarshaller[])$VALUES.clone();
    }

    public static DoubleMarshaller valueOf(String name) {
        return Enum.valueOf(DoubleMarshaller.class, name);
    }

    @Override
    public long size(@NotNull Double e) {
        return 8L;
    }

    @Override
    public int sizeEncodingSize(long size) {
        return 0;
    }

    @Override
    public long minEncodableSize() {
        return 8L;
    }

    @Override
    public int minSizeEncodingSize() {
        return 0;
    }

    @Override
    public int maxSizeEncodingSize() {
        return 0;
    }

    @Override
    public void writeSize(Bytes bytes, long size) {
        assert (size == 8L);
    }

    @Override
    public boolean startsWith(@NotNull Bytes bytes, @NotNull Double e) {
        return Double.doubleToLongBits(e) == bytes.readLong(bytes.position());
    }

    @Override
    public boolean equivalent(@NotNull Double a, @NotNull Double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    @Override
    public long hash(@NotNull LongHashFunction hashFunction, @NotNull Double e) {
        return hashFunction.hashLong(Double.doubleToLongBits(e));
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Double e) {
        bytes.writeLong(Double.doubleToLongBits(e));
    }

    @Override
    public long readSize(Bytes bytes) {
        return 8L;
    }

    @Override
    @NotNull
    public Double read(@NotNull Bytes bytes, long size) {
        return Double.longBitsToDouble(bytes.readLong());
    }

    @Override
    @NotNull
    public Double read(@NotNull Bytes bytes, long size, Double toReuse) {
        return this.read(bytes, size);
    }

    static {
        $VALUES = new DoubleMarshaller[]{INSTANCE};
    }
}

