/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.replication;

import net.openhft.chronicle.hash.AcceptanceDecision;
import net.openhft.chronicle.hash.HashAbsentEntry;
import net.openhft.chronicle.hash.Value;
import net.openhft.chronicle.hash.replication.DefaultEventualConsistencyStrategy;
import net.openhft.chronicle.hash.replication.HashReplicableEntry;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;

public interface MapRemoteOperations<K, V, R> {
    default public AcceptanceDecision remove(MapRemoteQueryContext<K, V, R> q) {
        MapEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(entry, q) == AcceptanceDecision.ACCEPT) {
                q.remove(entry);
                return AcceptanceDecision.ACCEPT;
            }
            return AcceptanceDecision.DISCARD;
        }
        HashAbsentEntry absentEntry = q.absentEntry();
        if (!1.$assertionsDisabled && absentEntry == null) {
            throw new AssertionError();
        }
        if (absentEntry instanceof HashReplicableEntry) {
            return DefaultEventualConsistencyStrategy.decideOnRemoteModification((HashReplicableEntry)((Object)absentEntry), q);
        }
        return AcceptanceDecision.ACCEPT;
    }

    default public AcceptanceDecision put(MapRemoteQueryContext<K, V, R> q, Value<V, ?> newValue) {
        MapEntry entry = q.entry();
        if (entry != null) {
            if (DefaultEventualConsistencyStrategy.decideOnRemoteModification(entry, q) == AcceptanceDecision.ACCEPT) {
                q.replaceValue(entry, newValue);
                return AcceptanceDecision.ACCEPT;
            }
            return AcceptanceDecision.DISCARD;
        }
        HashAbsentEntry absentEntry = q.absentEntry();
        if (!1.$assertionsDisabled && absentEntry == null) {
            throw new AssertionError();
        }
        if (!(absentEntry instanceof HashReplicableEntry) || DefaultEventualConsistencyStrategy.decideOnRemoteModification((HashReplicableEntry)((Object)absentEntry), q) == AcceptanceDecision.ACCEPT) {
            q.insert((MapAbsentEntry<K, V>)absentEntry, newValue);
            return AcceptanceDecision.ACCEPT;
        }
        return AcceptanceDecision.DISCARD;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

