/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.WriteAccess;
import org.jetbrains.annotations.Nullable;

public interface Value<V, T> {
    public ReadAccess<T> access();

    public T handle();

    public long offset();

    public long size();

    default public long hash(LongHashFunction f) {
        return f.hash(this.handle(), this.access(), this.offset(), this.size());
    }

    default public <T2> boolean equivalent(ReadAccess<T2> access, T2 handle, long offset) {
        return Access.equivalent(this.access(), this.handle(), (long)this.offset(), access, handle, (long)offset, (long)this.size());
    }

    default public <S, T2, A extends ReadAccess<T2>> boolean equivalent(Accessor<S, T2, A> accessor, S source, long index) {
        return this.equivalent((ReadAccess)accessor.access(source), accessor.handle(source), accessor.offset(source, index));
    }

    default public <T2> void writeTo(WriteAccess<T2> access, T2 handle, long offset) {
        Access.copy(this.access(), this.handle(), (long)this.offset(), access, handle, (long)offset, (long)this.size());
    }

    default public <T2> void writeTo(StreamingDataOutput<?, ?, T2> output) {
        long offset = output.accessPositionOffset();
        output.skip(this.size());
        this.writeTo(output.access(), output.accessHandle(), offset);
    }

    default public <S, T2, A extends WriteAccess<T2>> void writeTo(Accessor<S, T2, A> accessor, S source, long index) {
        this.writeTo((WriteAccess)accessor.access(source), accessor.handle(source), accessor.offset(source, index));
    }

    public V get();

    public V getUsing(@Nullable V var1);

    public static <T1, T2> boolean bytesEquivalent(Value<?, T1> v1, Value<?, T2> v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        return Access.equivalent(v1.access(), v1.handle(), (long)v1.offset(), v2.access(), v2.handle(), (long)v2.offset(), (long)v1.size());
    }
}

