/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.nio.BufferOverflowException;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.SerializationBuilder;
import net.openhft.chronicle.map.BufferResizer;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.Nullable;

final class WriterWithSize<T> {
    private final SizeMarshaller sizeMarshaller;
    private final Object originalWriter;
    private final Provider writerProvider;
    private final MetaBytesInterop originalMetaWriter;
    private final MetaProvider metaWriterProvider;
    private final BufferResizer bufferResizer;

    WriterWithSize(SerializationBuilder<T> serializationBuilder, @Nullable BufferResizer bufferResizer) {
        this.bufferResizer = bufferResizer;
        this.sizeMarshaller = serializationBuilder.sizeMarshaller();
        this.originalWriter = serializationBuilder.interop();
        this.writerProvider = Provider.of(this.originalWriter.getClass());
        this.originalMetaWriter = serializationBuilder.metaInterop();
        this.metaWriterProvider = serializationBuilder.metaInteropProvider();
    }

    ThreadLocalCopies getCopies(ThreadLocalCopies copies) {
        copies = this.writerProvider.getCopies(copies);
        return this.metaWriterProvider.getCopies(copies);
    }

    public ThreadLocalCopies write(Bytes out, T t, @Nullable ThreadLocalCopies copies) {
        copies = this.writerProvider.getCopies(copies);
        Object writer = this.writerProvider.get(copies, this.originalWriter);
        copies = this.metaWriterProvider.getCopies(copies);
        MetaBytesInterop metaWriter = this.metaWriterProvider.get(copies, this.originalMetaWriter, writer, t);
        long size = metaWriter.size(writer, t);
        if (this.bufferResizer != null) {
            out = this.resizeIfRequired(out, size);
        }
        this.sizeMarshaller.writeSize(out, size);
        metaWriter.write(writer, out, t);
        return copies;
    }

    private Bytes resizeIfRequired(Bytes out, long size) {
        if (out.remaining() < size + 8L) {
            long newCapacity = out.capacity() + (size - out.remaining()) + 8L;
            if (newCapacity > Integer.MAX_VALUE) {
                throw new BufferOverflowException();
            }
            return this.bufferResizer.resizeBuffer((int)newCapacity);
        }
        return out;
    }

    public ThreadLocalCopies writeNullable(Bytes out, T t, @Nullable ThreadLocalCopies copies) {
        out.writeBoolean(t == null);
        if (t == null) {
            return copies;
        }
        return this.write(out, t, copies);
    }

    public Object writerForLoop(@Nullable ThreadLocalCopies copies) {
        copies = this.writerProvider.getCopies(copies);
        return this.writerProvider.get(copies, this.originalWriter);
    }

    public ThreadLocalCopies writeInLoop(Bytes out, T t, Object writer, @Nullable ThreadLocalCopies copies) {
        copies = this.metaWriterProvider.getCopies(copies);
        MetaBytesInterop metaWriter = this.metaWriterProvider.get(copies, this.originalMetaWriter, writer, t);
        long size = metaWriter.size(writer, t);
        if (this.bufferResizer != null) {
            out = this.resizeIfRequired(out, size);
        }
        this.sizeMarshaller.writeSize(out, size);
        metaWriter.write(writer, out, t);
        return copies;
    }

    public ThreadLocalCopies writeNullableInLoop(Bytes out, T t, Object writer, @Nullable ThreadLocalCopies copies) {
        out.writeBoolean(t == null);
        if (t == null) {
            return copies;
        }
        return this.writeInLoop(out, t, writer, copies);
    }
}

