/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.HashReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContextInterface;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
extends VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R>
implements Replica,
Replica.EntryExternalizable,
Replica.EntryResolver<K, V> {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    public final TimeProvider timeProvider;
    private final byte localIdentifier;
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ATSDirectBitSet modIterSet;
    private transient AtomicReferenceArray<ModificationIterator> modificationIterators;
    private transient long startOfModificationIterators;
    private boolean bootstrapOnlyLocalEntries;
    public transient MapRemoteOperations<K, V, R> remoteOperations = DefaultSpi.mapRemoteOperations();
    transient CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> remoteOpContext;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder, AbstractReplication replication) throws IOException {
        super(builder, true);
        this.timeProvider = builder.timeProvider();
        this.localIdentifier = replication.identifier();
        this.bootstrapOnlyLocalEntries = replication.bootstrapOnlyLocalEntries();
        if (this.localIdentifier == -1) {
            throw new IllegalStateException("localIdentifier should not be -1");
        }
    }

    @Override
    void initQueryContext() {
        this.queryCxt = new ThreadLocal<CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?>>(){

            @Override
            protected CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> initialValue() {
                return new CompiledReplicatedMapQueryContext(ReplicatedChronicleMap.this);
            }
        };
    }

    @Override
    void initIterationContext() {
        this.iterCxt = new ThreadLocal<CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?>>(){

            @Override
            protected CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> initialValue() {
                return new CompiledReplicatedMapIterationContext(ReplicatedChronicleMap.this);
            }
        };
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(135L, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.ownInitTransients();
    }

    private void ownInitTransients() {
        this.modificationIterators = new AtomicReferenceArray(135);
        this.closeables = new CopyOnWriteArraySet<Closeable>();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ownInitTransients();
    }

    long modIterBitSetSizeInBytes() {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * (long)this.actualSegments);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.actualChunksPerSegment, (long)1024L);
    }

    @Override
    public long mapHeaderInnerSize() {
        return super.mapHeaderInnerSize() + 1024L + this.modIterBitSetSizeInBytes() * 136L + (long)this.assignedModIterBitSetSizeInBytes();
    }

    void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    public void onHeaderCreated() {
        long offset = super.mapHeaderInnerSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L).zeroOut();
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modIterSet = new ATSDirectBitSet(modDelBytes);
    }

    @Override
    public void clear() {
        this.forEachEntry(KeyContext::remove);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    public byte identifier() {
        return this.localIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replica.ModificationIterator acquireModificationIterator(byte remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            Bytes bytes = this.ms.bytes(this.startOfModificationIterators + this.modIterBitSetSizeInBytes() * (long)remoteIdentifier, this.modIterBitSetSizeInBytes());
            ModificationIterator newModificationIterator = new ModificationIterator(bytes, modificationNotifier);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    public void raiseChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).raiseChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public void dropChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).dropChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    @Override
    public boolean identifierCheck(@NotNull HashReplicableEntry<?> entry, int chronicleId) {
        return entry.originIdentifier() == this.localIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfEntry(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                int n = 0;
                return n;
            }
            entry.skip(1L);
            long valueSize = this.valueSizeMarshaller.readSize(entry);
            this.alignment.alignPositionAddr(entry);
            long result = entry.position() + valueSize - start;
            assert (result < Integer.MAX_VALUE);
            int n = (int)result;
            return n;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId) {
        long initialLimit = entry.limit();
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long keyLimit = entry.position();
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.localIdentifier) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : this.valueSizeMarshaller.minEncodableSize();
        long valuePosition = entry.position();
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        destination.writeByte((int)identifier);
        destination.writeBoolean(isDeleted);
        entry.position(keyPosition);
        entry.limit(keyLimit);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.limit(initialLimit);
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        entry.limit(entry.position() + valueSize);
        destination.write((RandomDataInput)entry, entry.position(), entry.remaining());
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    private CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> q() {
        return (CompiledReplicatedMapQueryContext)this.queryCxt.get();
    }

    public CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> mapContext() {
        CompiledReplicatedMapQueryContext q = (CompiledReplicatedMapQueryContext)this.q().getContext();
        q.initUsed(true);
        return q;
    }

    private CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> remoteOpContext() {
        if (this.remoteOpContext == null) {
            this.remoteOpContext = (CompiledReplicatedMapQueryContext)this.q().getContext();
        }
        return this.remoteOpContext;
    }

    @Override
    public void readExternalEntry(@NotNull Bytes source) {
        try (CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> remoteOpContext = this.remoteOpContext();){
            if (remoteOpContext.usedInit()) {
                throw new IllegalStateException();
            }
            remoteOpContext.initUsed(true);
            remoteOpContext.initReplicationInput(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K key(@NotNull Bytes entry, K usingKey) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            ThreadLocalCopies copies = this.keyReaderProvider.getCopies(null);
            Object e = ((BytesReader)this.keyReaderProvider.get(copies, (Object)this.originalKeyReader)).read(entry, keySize);
            return (K)e;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V value(@NotNull Bytes entry, V usingValue) {
        long start = entry.position();
        try {
            long valueSize;
            entry.skip(this.keySizeMarshaller.readSize(entry));
            entry.readLong();
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                V v = null;
                return v;
            }
            boolean isDeleted = entry.readBoolean();
            if (!isDeleted) {
                valueSize = this.valueSizeMarshaller.readSize(entry);
                assert (valueSize > 0L);
            } else {
                V v = null;
                return v;
            }
            this.alignment.alignPositionAddr(entry);
            ThreadLocalCopies copies = this.valueReaderProvider.getCopies(null);
            BytesReader valueReader = (BytesReader)this.valueReaderProvider.get(copies, (Object)this.originalValueReader);
            V v = valueReader.read(entry, valueSize, usingValue);
            return v;
        }
        finally {
            entry.position(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasRemoved(@NotNull Bytes entry) {
        long start = entry.position();
        try {
            boolean bl = entry.readBoolean(this.keySizeMarshaller.readSize(entry) + 9L);
            return bl;
        }
        finally {
            entry.position(start);
        }
    }

    private CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> i() {
        return (CompiledReplicatedMapIterationContext)this.iterCxt.get();
    }

    public CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> iterationContext() {
        CompiledReplicatedMapIterationContext c = (CompiledReplicatedMapIterationContext)this.i().getContext();
        c.initUsed(true);
        return c;
    }

    class ModificationIterator
    implements Replica.ModificationIterator {
        private final Replica.ModificationNotifier modificationNotifier;
        private final SingleThreadedDirectBitSet changesForUpdates;
        private final ATSDirectBitSet changesForIteration;
        private final int segmentIndexShift;
        private final long posMask;
        private final CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, ?, ?> context;
        private volatile long position;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.context = ReplicatedChronicleMap.this.mapContext();
            this.position = -1L;
            this.modificationNotifier = modificationNotifier;
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changesForUpdates = new SingleThreadedDirectBitSet(bytes);
            this.changesForIteration = new ATSDirectBitSet(bytes);
        }

        private long combine(long segmentIndex, long pos) {
            return segmentIndex << this.segmentIndexShift | pos;
        }

        void raiseChange(long segmentIndex, long pos) {
            this.changesForUpdates.set(this.combine(segmentIndex, pos));
            this.modificationNotifier.onChange();
        }

        void dropChange(long segmentIndex, long pos) {
            this.changesForUpdates.clear(this.combine(segmentIndex, pos));
        }

        @Override
        public boolean hasNext() {
            long position = this.position;
            return this.changesForIteration.nextSetBit(position == -1L ? 0L : position) != -1L || position > 0L && this.changesForIteration.nextSetBit(0L) != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changesForIteration.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition != -1L) continue;
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                int segmentIndex = (int)(position >>> this.segmentIndexShift);
                if (this.context.theSegmentIndexInit() && this.context.segmentIndex() != segmentIndex) {
                    this.context.initTheSegmentIndex(segmentIndex);
                }
                this.context.updateLock().lock();
                try {
                    if (!this.changesForUpdates.get(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    this.context.initEntry(segmentPos);
                    if (entryCallback.shouldBeIgnored((HashReplicableEntry<?>)((Object)this.context.entry()), chronicleId)) {
                        this.changesForUpdates.clear(position);
                        continue;
                    }
                    this.context.entryBytes().limit(this.context.valueOffset() + this.context.valueSize());
                    this.context.entryBytes().position(this.context.keySizeOffset());
                    boolean success = entryCallback.onEntry(this.context.entryBytes(), chronicleId);
                    entryCallback.onAfterEntry();
                    if (success) {
                        this.changesForUpdates.clear(position);
                    }
                    boolean bl = success;
                    return bl;
                }
                finally {
                    this.context.updateLock().unlock();
                    continue;
                }
                break;
            }
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            try (IterationContextInterface c = ReplicatedChronicleMap.this.iterationContext();){
                int i = 0;
                while (i < ReplicatedChronicleMap.this.actualSegments) {
                    int segmentIndex = i++;
                    ((CompiledReplicatedMapIterationContext)c).initTheSegmentIndex(segmentIndex);
                    ((CompiledReplicatedMapIterationContext)c).forEachRemoving(arg_0 -> this.lambda$dirtyEntries$13(fromTimeStamp, segmentIndex, (CompiledReplicatedMapIterationContext)c, arg_0));
                }
            }
        }

        private /* synthetic */ boolean lambda$dirtyEntries$13(long l, int n, CompiledReplicatedMapIterationContext compiledReplicatedMapIterationContext, MapEntry entry) {
            MapReplicableEntry re = (MapReplicableEntry)entry;
            assert (re.originTimestamp() > 0L);
            if (!((long)re.originIdentifier() < l || ReplicatedChronicleMap.this.bootstrapOnlyLocalEntries && re.originIdentifier() != ReplicatedChronicleMap.this.localIdentifier)) {
                this.raiseChange(n, compiledReplicatedMapIterationContext.pos());
            }
            return false;
        }
    }
}

