/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import java.util.Arrays;
import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public enum ByteArrayMarshaller implements BytesInterop<byte[]>,
BytesReader<byte[]>
{
    INSTANCE;


    @Override
    public long size(@NotNull byte[] ba) {
        return ba.length;
    }

    @Override
    public boolean startsWith(@NotNull Bytes bytes, @NotNull byte[] ba) {
        if (bytes.capacity() - bytes.position() < (long)ba.length) {
            return false;
        }
        long pos = bytes.position();
        for (int i = 0; i < ba.length; ++i) {
            if (bytes.readByte(pos + (long)i) == ba[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equivalent(@NotNull byte[] a, @NotNull byte[] b) {
        return Arrays.equals(a, b);
    }

    @Override
    public long hash(@NotNull LongHashFunction hashFunction, @NotNull byte[] ba) {
        return hashFunction.hashBytes(ba);
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull byte[] ba) {
        bytes.write(ba);
    }

    @Override
    @NotNull
    public byte[] read(@NotNull Bytes bytes, long size) {
        byte[] ba = new byte[this.resLen(size)];
        bytes.read(ba);
        return ba;
    }

    @Override
    @NotNull
    public byte[] read(@NotNull Bytes bytes, long size, byte[] toReuse) {
        int resLen = this.resLen(size);
        if (toReuse == null || resLen != toReuse.length) {
            toReuse = new byte[resLen];
        }
        bytes.read(toReuse);
        return toReuse;
    }

    private int resLen(long size) {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byte[] size should be non-negative int, " + size + " given. Memory corruption?");
        }
        return (int)size;
    }
}

